/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.recipe.ModRecipes;
import org.jetbrains.annotations.Nullable;

public class ToolCastBlastingRecipeBuilder
implements RecipeBuilder {
    private final ItemLike result;
    private final float experience;
    private final int cookTime;
    private final Map<String, Integer> materialInput = new HashMap<String, Integer>();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    private String toolType;
    @Nullable
    private Boolean needPolishing = null;
    @Nullable
    private String group = "misc";
    @Nullable
    private String category = "misc";

    public ToolCastBlastingRecipeBuilder(ItemLike result, float experience, int cookTime) {
        this.result = result;
        this.experience = experience;
        this.cookTime = cookTime;
    }

    public static ToolCastBlastingRecipeBuilder cast(ItemLike result, float xp, int time) {
        return new ToolCastBlastingRecipeBuilder(result, xp, time);
    }

    public ToolCastBlastingRecipeBuilder toolType(String type) {
        this.toolType = type;
        return this;
    }

    public ToolCastBlastingRecipeBuilder material(String material, int amount) {
        this.materialInput.put(material, amount);
        return this;
    }

    public ToolCastBlastingRecipeBuilder needsPolishing(boolean flag) {
        this.needPolishing = flag;
        return this;
    }

    public RecipeBuilder m_126132_(String name, CriterionTriggerInstance trigger) {
        this.advancement.m_138386_(name, trigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String group) {
        this.group = group;
        return this;
    }

    public ToolCastBlastingRecipeBuilder category(String category) {
        this.category = category;
        return this;
    }

    public Item m_142372_() {
        return this.result.m_5456_();
    }

    public void m_126140_(Consumer<FinishedRecipe> out, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        out.accept(new Result(id, this.result, this.group, this.category, this.toolType, this.materialInput, this.experience, this.cookTime, this.needPolishing, this.advancement, id.m_246208_("recipes/misc/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.toolType == null) {
            throw new IllegalStateException("Tool type missing for " + id);
        }
        if (this.materialInput.isEmpty()) {
            throw new IllegalStateException("No material input for " + id);
        }
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No unlock criteria for " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ItemLike result;
        private final String group;
        private final String category;
        private final String toolType;
        private final Map<String, Integer> input;
        private final float xp;
        private final int time;
        private final Boolean needPolishing;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, ItemLike result, String group, String category, String toolType, Map<String, Integer> input, float xp, int time, Boolean needPolishing, Advancement.Builder adv, ResourceLocation advId) {
            this.id = id;
            this.result = result;
            this.group = group;
            this.category = category;
            this.toolType = toolType;
            this.input = input;
            this.xp = xp;
            this.time = time;
            this.needPolishing = needPolishing;
            this.advancement = adv;
            this.advancementId = advId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("category", this.category);
            json.addProperty("tool_type", this.toolType);
            JsonObject inputObj = new JsonObject();
            this.input.forEach((mat, amt) -> inputObj.add(mat, (JsonElement)new JsonPrimitive((Number)amt)));
            json.add("input", (JsonElement)inputObj);
            JsonObject resultObj = new JsonObject();
            resultObj.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result.m_5456_()).toString());
            json.add("result", (JsonElement)resultObj);
            if (this.needPolishing != null) {
                json.addProperty("need_polishing", this.needPolishing);
            }
            json.addProperty("experience", (Number)Float.valueOf(this.xp));
            json.addProperty("cookingtime", (Number)this.time);
        }

        public ResourceLocation m_6445_() {
            return new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_from_cast_blasting");
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.CAST_BLASTING.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

