/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.datapack;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class DurabilityBlacklistReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, Ingredient> DATA = new ConcurrentHashMap<ResourceLocation, Ingredient>();
    public static final DurabilityBlacklistReloadListener INSTANCE = new DurabilityBlacklistReloadListener();
    private static final Gson GSON = new Gson();

    public DurabilityBlacklistReloadListener() {
        super(GSON, "durability_blacklist");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, ResourceManager resourceManager, ProfilerFiller profiler) {
        DATA.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resources.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonElement jsonElement = entry.getValue();
            try {
                if (jsonElement.isJsonObject()) {
                    JsonObject json = jsonElement.getAsJsonObject();
                    Ingredient ingredient = this.parseIngredient(json);
                    DATA.put(id, ingredient);
                    continue;
                }
                throw new JsonSyntaxException("Expected JSON object for durability multiplier blacklist entry: " + id);
            }
            catch (Exception e) {
                System.err.println("Failed to parse durability multiplier blacklist entry: " + id + ", error: " + e.getMessage());
            }
        }
        System.out.println("Loaded " + DATA.size() + " durability blacklist entries");
        for (Map.Entry<ResourceLocation, JsonElement> entry : DATA.entrySet()) {
            System.out.println("Blacklist entry: " + entry.getKey() + " -> " + Arrays.toString(((Ingredient)entry.getValue()).m_43908_()));
        }
    }

    private Ingredient parseIngredient(JsonObject json) {
        if (!json.has("item")) {
            throw new JsonSyntaxException("Missing 'item' for durability multiplier blacklist entry");
        }
        JsonElement itemElement = json.get("item");
        return Ingredient.m_43917_((JsonElement)itemElement);
    }

    public static Map<ResourceLocation, Ingredient> getData() {
        return Collections.unmodifiableMap(DATA);
    }

    public static List<Ingredient> getAllIngredients() {
        return List.copyOf(DATA.values());
    }

    public static List<ItemStack> getAllBlacklistedItems() {
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        for (Ingredient ingredient : DATA.values()) {
            ItemStack[] stacks = ingredient.m_43908_();
            if (stacks.length <= 0) continue;
            allItems.addAll(Arrays.asList(stacks));
        }
        return allItems;
    }

    public static boolean isBlacklisted(ItemStack stack) {
        for (Ingredient ingredient : DATA.values()) {
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static void clear() {
        DATA.clear();
    }
}

