/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.datapack;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class MaterialSettingsReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, List<MaterialEntry>> DATA = new ConcurrentHashMap<ResourceLocation, List<MaterialEntry>>();
    public static final MaterialSettingsReloadListener INSTANCE = new MaterialSettingsReloadListener();
    private static final Gson GSON = new Gson();

    public MaterialSettingsReloadListener() {
        super(GSON, "material_settings");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, ResourceManager resourceManager, ProfilerFiller profiler) {
        DATA.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resources.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonElement jsonElement = entry.getValue();
            try {
                if (jsonElement.isJsonObject()) {
                    JsonObject json = jsonElement.getAsJsonObject();
                    List<MaterialEntry> materialEntries = this.parseMaterialEntries(json);
                    DATA.put(id, materialEntries);
                    continue;
                }
                throw new JsonSyntaxException("Expected JSON object for material settings entry: " + id);
            }
            catch (Exception e) {
                System.err.println("Failed to parse material settings entry: " + id + ", error: " + e.getMessage());
            }
        }
        System.out.println("Loaded " + DATA.size() + " material settings entries");
    }

    private List<MaterialEntry> parseMaterialEntries(JsonObject json) {
        ArrayList<MaterialEntry> entries = new ArrayList<MaterialEntry>();
        if (!json.has("materials")) {
            throw new JsonSyntaxException("Missing 'materials' array for material settings entry");
        }
        JsonArray materialsArray = json.getAsJsonArray("materials");
        for (JsonElement materialElement : materialsArray) {
            if (!materialElement.isJsonArray()) {
                throw new JsonSyntaxException("Expected array for material entry");
            }
            JsonArray materialArray = materialElement.getAsJsonArray();
            if (materialArray.size() != 3) {
                throw new JsonSyntaxException("Material entry must have exactly 3 elements: [item_or_tag, material_id, material_value]");
            }
            String itemOrTag = materialArray.get(0).getAsString();
            String materialId = materialArray.get(1).getAsString();
            int materialValue = materialArray.get(2).getAsInt();
            if (materialValue <= 0) {
                throw new JsonSyntaxException("Material value must be positive: " + materialValue);
            }
            entries.add(new MaterialEntry(itemOrTag, materialId, materialValue));
        }
        return entries;
    }

    public static Map<ResourceLocation, List<MaterialEntry>> getData() {
        return Collections.unmodifiableMap(DATA);
    }

    public static List<MaterialEntry> getAllMaterialEntries() {
        ArrayList<MaterialEntry> allEntries = new ArrayList<MaterialEntry>();
        for (List<MaterialEntry> entries : DATA.values()) {
            allEntries.addAll(entries);
        }
        return allEntries;
    }

    public static List<MaterialEntry> getEntriesForMaterial(String materialId) {
        ArrayList<MaterialEntry> result = new ArrayList<MaterialEntry>();
        for (MaterialEntry entry : MaterialSettingsReloadListener.getAllMaterialEntries()) {
            if (!entry.getMaterialId().equals(materialId)) continue;
            result.add(entry);
        }
        return result;
    }

    public static Optional<MaterialEntry> getEntryForItem(String itemId) {
        for (MaterialEntry entry : MaterialSettingsReloadListener.getAllMaterialEntries()) {
            if (!entry.getItemOrTag().equals(itemId)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    public static Map<String, Integer> getMaterialValuesForItem(String itemId) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (MaterialEntry entry : MaterialSettingsReloadListener.getAllMaterialEntries()) {
            if (!entry.getItemOrTag().equals(itemId)) continue;
            result.put(entry.getMaterialId(), entry.getMaterialValue());
        }
        return result;
    }

    public static void clear() {
        DATA.clear();
    }

    public static class MaterialEntry {
        private final String itemOrTag;
        private final String materialId;
        private final int materialValue;
        private final boolean isTag;

        public MaterialEntry(String itemOrTag, String materialId, int materialValue) {
            this.itemOrTag = itemOrTag;
            this.materialId = materialId;
            this.materialValue = materialValue;
            this.isTag = itemOrTag.startsWith("#");
        }

        public String getItemOrTag() {
            return this.itemOrTag;
        }

        public String getMaterialId() {
            return this.materialId;
        }

        public int getMaterialValue() {
            return this.materialValue;
        }

        public boolean isTag() {
            return this.isTag;
        }

        public String getActualTagName() {
            return this.isTag ? this.itemOrTag.substring(1) : this.itemOrTag;
        }
    }
}

