/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.item.custom.ToolCastItem;
import net.stirdrem.overgeared.recipe.ModRecipes;
import org.jetbrains.annotations.NotNull;

public class CastSmeltingRecipe
extends SmeltingRecipe {
    private final Map<String, Double> requiredMaterials;
    private final String toolType;
    private final boolean needPolishing;

    public CastSmeltingRecipe(ResourceLocation id, String group, CookingBookCategory category, ItemStack result, float xp, int time, Map<String, Double> reqMaterials, String toolType, boolean needPolishing) {
        super(id, group, category, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CLAY_TOOL_CAST.get(), (ItemLike)ModItems.NETHER_TOOL_CAST.get()}), result, xp, time);
        this.requiredMaterials = reqMaterials;
        this.toolType = toolType;
        this.needPolishing = needPolishing;
    }

    public static Map<String, Double> readMaterials(CompoundTag tag) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (String key : tag.m_128431_()) {
            if (tag.m_128425_(key, 6)) {
                map.put(key, tag.m_128459_(key));
                continue;
            }
            if (!tag.m_128425_(key, 3)) continue;
            map.put(key, Double.valueOf(tag.m_128451_(key)));
        }
        return map;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("ToolType", this.toolType);
        CompoundTag mats = new CompoundTag();
        double total = 0.0;
        for (Map.Entry<String, Double> entry : this.requiredMaterials.entrySet()) {
            String mat = entry.getKey();
            double amt = entry.getValue();
            total += amt;
            mats.m_128347_(mat, amt);
        }
        tag.m_128365_("Materials", (Tag)mats);
        tag.m_128347_("Amount", total);
        tag.m_128347_("MaxAmount", total);
        ItemStack firedCast = new ItemStack((ItemLike)ModItems.CLAY_TOOL_CAST.get());
        firedCast.m_41751_(tag.m_6426_());
        ItemStack netherCast = new ItemStack((ItemLike)ModItems.NETHER_TOOL_CAST.get());
        netherCast.m_41751_(tag.m_6426_());
        list.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{firedCast, netherCast}));
        return list;
    }

    public boolean m_5818_(Container inv, Level level) {
        ItemStack input = inv.m_8020_(0);
        if (!(input.m_41720_() instanceof ToolCastItem)) {
            return false;
        }
        CompoundTag tag = input.m_41783_();
        if (tag == null || !tag.m_128441_("Materials")) {
            return false;
        }
        if (!this.toolType.equals(tag.m_128461_("ToolType").toLowerCase())) {
            return false;
        }
        if (tag.m_128441_("Amount") && tag.m_128457_("Amount") <= 0.0f) {
            return false;
        }
        if (!tag.m_128441_("Amount")) {
            return false;
        }
        Map<String, Double> materials = CastSmeltingRecipe.readMaterials(tag.m_128469_("Materials"));
        for (Map.Entry<String, Double> entry : this.requiredMaterials.entrySet()) {
            String material = entry.getKey().toLowerCase();
            double needed = entry.getValue();
            double available = materials.getOrDefault(material, 0.0);
            if (!(available < needed)) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        String q;
        ItemStack input = inv.m_8020_(0);
        ItemStack cast = input.m_41777_();
        CompoundTag castTag = cast.m_41784_();
        ItemStack result = super.m_5874_(inv, registryAccess);
        CompoundTag resultTag = result.m_41784_();
        if (input.m_41782_() && input.m_41783_().m_128441_("Quality") && !(q = input.m_41783_().m_128461_("Quality")).equals("none")) {
            resultTag.m_128359_("ForgingQuality", q);
        }
        if (this.needPolishing) {
            resultTag.m_128379_("Polished", false);
        }
        resultTag.m_128379_("Heated", true);
        if (input.m_41788_() && ((Boolean)ServerConfig.PLAYER_AUTHOR_TOOLTIPS.get()).booleanValue()) {
            resultTag.m_128359_("Creator", input.m_41786_().getString());
        }
        castTag.m_128365_("Output", (Tag)result.m_41739_(new CompoundTag()));
        castTag.m_128365_("Materials", (Tag)new CompoundTag());
        castTag.m_128379_("Heated", true);
        if (cast.m_41763_()) {
            if (cast.m_41773_() + 1 >= cast.m_41776_()) {
                cast.m_41774_(1);
                return result;
            }
            cast.m_41721_(cast.m_41773_() + 1);
        }
        return cast;
    }

    @NotNull
    private CompoundTag getCompoundTag(ItemStack castCopy) {
        CompoundTag tag = castCopy.m_41784_();
        if (tag.m_128441_("input")) {
            tag.m_128473_("input");
        }
        if (tag.m_128441_("Materials")) {
            CompoundTag mats = tag.m_128469_("Materials");
            ArrayList<String> toRemove = new ArrayList<String>();
            for (Map.Entry<String, Double> entry : this.requiredMaterials.entrySet()) {
                String mat = entry.getKey().toLowerCase();
                double cost = entry.getValue();
                if (!mats.m_128441_(mat)) continue;
                double current = mats.m_128459_(mat);
                double newAmount = Math.max(0.0, current - cost);
                if (newAmount <= 0.0) {
                    toRemove.add(mat);
                    continue;
                }
                mats.m_128347_(mat, newAmount);
            }
            for (String r : toRemove) {
                mats.m_128473_(r);
            }
            tag.m_128347_("Amount", 0.0);
            tag.m_128365_("Materials", (Tag)new CompoundTag());
        }
        return tag;
    }

    public Map<String, Double> getMaterialInputs() {
        return this.requiredMaterials;
    }

    public Map<String, Double> getRequiredMaterials() {
        return this.requiredMaterials;
    }

    public String getToolType() {
        return this.toolType;
    }

    public boolean requiresPolishing() {
        return this.needPolishing;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return RecipeType.f_44108_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.CAST_SMELTING.get();
    }

    public static class Serializer
    implements RecipeSerializer<CastSmeltingRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public CastSmeltingRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CookingBookCategory category = CookingBookCategory.MISC;
            JsonObject inputObj = GsonHelper.m_13930_((JsonObject)json, (String)"input");
            HashMap<String, Double> reqMaterials = new HashMap<String, Double>();
            inputObj.entrySet().forEach(e -> reqMaterials.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsDouble()));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            float xp = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int time = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)200);
            String toolType = GsonHelper.m_13906_((JsonObject)json, (String)"tool_type").toLowerCase();
            boolean needPolishing = GsonHelper.m_13855_((JsonObject)json, (String)"need_polishing", (boolean)false);
            return new CastSmeltingRecipe(id, group, category, result, xp, time, reqMaterials, toolType, needPolishing);
        }

        public CastSmeltingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            CookingBookCategory category = CookingBookCategory.MISC;
            int size = buf.readInt();
            HashMap<String, Double> reqMaterials = new HashMap<String, Double>();
            for (int i = 0; i < size; ++i) {
                reqMaterials.put(buf.m_130277_(), buf.readDouble());
            }
            ItemStack result = buf.m_130267_();
            float xp = buf.readFloat();
            int time = buf.m_130242_();
            String toolType = buf.m_130277_();
            boolean needPolish = buf.readBoolean();
            return new CastSmeltingRecipe(id, group, category, result, xp, time, reqMaterials, toolType, needPolish);
        }

        public void toNetwork(FriendlyByteBuf buf, CastSmeltingRecipe recipe) {
            buf.m_130070_(recipe.m_6076_());
            buf.writeInt(recipe.requiredMaterials.size());
            recipe.requiredMaterials.forEach((k, v) -> {
                buf.m_130070_(k);
                buf.writeDouble(v.doubleValue());
            });
            buf.m_130055_(recipe.m_8043_(null));
            buf.writeFloat(recipe.m_43750_());
            buf.m_130130_(recipe.m_43753_());
            buf.m_130070_(recipe.toolType);
            buf.writeBoolean(recipe.needPolishing);
        }
    }
}

