/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.item.custom.ToolCastItem;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.recipe.ModRecipes;
import net.stirdrem.overgeared.util.ConfigHelper;
import org.jetbrains.annotations.NotNull;

public class CastingRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final String group;
    private final CookingBookCategory category;
    private final ItemStack result;
    private final float experience;
    private final int cookingTime;
    private final Map<String, Double> requiredMaterials;
    private final String toolType;
    private final boolean needPolishing;

    public CastingRecipe(ResourceLocation id, String group, CookingBookCategory category, ItemStack result, float experience, int cookingTime, Map<String, Double> requiredMaterials, String toolType, boolean needPolishing) {
        this.id = id;
        this.group = group;
        this.category = category;
        this.result = result;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.requiredMaterials = requiredMaterials;
        this.toolType = toolType.toLowerCase();
        this.needPolishing = needPolishing;
    }

    public boolean m_5818_(Container inv, Level level) {
        if (level.f_46443_) {
            return false;
        }
        ItemStack cast = inv.m_8020_(3);
        if (!(cast.m_41720_() instanceof ToolCastItem)) {
            return false;
        }
        CompoundTag castTag = cast.m_41783_();
        if (castTag == null) {
            return false;
        }
        if (!castTag.m_128441_("ToolType")) {
            return false;
        }
        if (!this.toolType.equals(castTag.m_128461_("ToolType").toLowerCase())) {
            return false;
        }
        ItemStack materialStack = inv.m_8020_(0);
        if (materialStack.m_41619_()) {
            return false;
        }
        if (!ConfigHelper.isValidMaterial(materialStack)) {
            return false;
        }
        Map<String, Integer> availableMaterials = ConfigHelper.getMaterialValuesForItem(materialStack);
        for (Map.Entry<String, Double> entry : this.requiredMaterials.entrySet()) {
            String material = entry.getKey().toLowerCase();
            double needed = entry.getValue();
            double available = availableMaterials.getOrDefault(material, 0).intValue();
            if (!(available < needed)) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        String q;
        ItemStack cast = inv.m_8020_(3);
        if (cast.m_41619_()) {
            return ItemStack.f_41583_;
        }
        CompoundTag castTag = cast.m_41784_();
        ItemStack out = this.result.m_41777_();
        CompoundTag outTag = out.m_41784_();
        if (castTag.m_128441_("Quality") && !(q = castTag.m_128461_("Quality")).equals("none")) {
            outTag.m_128359_("ForgingQuality", q);
        }
        if (this.needPolishing) {
            outTag.m_128379_("Polished", false);
        }
        outTag.m_128379_("Heated", true);
        if (cast.m_41788_() && ((Boolean)ServerConfig.PLAYER_AUTHOR_TOOLTIPS.get()).booleanValue()) {
            outTag.m_128359_("Creator", cast.m_41786_().getString());
        }
        if (cast.m_41763_()) {
            int newDamage = cast.m_41773_() + 1;
            if (newDamage >= cast.m_41776_()) {
                cast.m_41774_(1);
            } else {
                cast.m_41721_(newDamage);
            }
        }
        return out;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("ToolType", this.toolType);
        CompoundTag mats = new CompoundTag();
        double total = 0.0;
        for (Map.Entry<String, Double> e : this.requiredMaterials.entrySet()) {
            mats.m_128347_(e.getKey(), e.getValue().doubleValue());
            total += e.getValue().doubleValue();
        }
        tag.m_128365_("Materials", (Tag)mats);
        tag.m_128347_("Amount", total);
        tag.m_128347_("MaxAmount", total);
        ItemStack dummyCast = new ItemStack((ItemLike)ModItems.CLAY_TOOL_CAST.get());
        dummyCast.m_41751_(tag);
        list.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{dummyCast}));
        return list;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public boolean m_8004_(int w, int h) {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.CASTING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.CASTING.get();
    }

    public static Map<String, Double> readMaterials(CompoundTag tag) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (String key : tag.m_128431_()) {
            if (tag.m_128425_(key, 6)) {
                map.put(key, tag.m_128459_(key));
                continue;
            }
            if (!tag.m_128425_(key, 3)) continue;
            map.put(key, Double.valueOf(tag.m_128451_(key)));
        }
        return map;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public boolean requiresPolishing() {
        return this.needPolishing;
    }

    public Map<String, Double> getRequiredMaterials() {
        return this.requiredMaterials;
    }

    public String getToolType() {
        return this.toolType;
    }

    public static class Serializer
    implements RecipeSerializer<CastingRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public CastingRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CookingBookCategory category = CookingBookCategory.MISC;
            JsonObject input = GsonHelper.m_13930_((JsonObject)json, (String)"input").getAsJsonObject("material");
            HashMap<String, Double> mats = new HashMap<String, Double>();
            input.entrySet().forEach(e -> mats.put(((String)e.getKey()).toLowerCase(), ((JsonElement)e.getValue()).getAsDouble()));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            float xp = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int time = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)200);
            String toolType = GsonHelper.m_13906_((JsonObject)json, (String)"tool_type").toLowerCase();
            boolean polish = GsonHelper.m_13855_((JsonObject)json, (String)"need_polishing", (boolean)false);
            return new CastingRecipe(id, group, category, result, xp, time, mats, toolType, polish);
        }

        public CastingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            CookingBookCategory category = CookingBookCategory.MISC;
            int size = buf.readInt();
            HashMap<String, Double> mats = new HashMap<String, Double>();
            for (int i = 0; i < size; ++i) {
                mats.put(buf.m_130277_(), buf.readDouble());
            }
            ItemStack result = buf.m_130267_();
            float xp = buf.readFloat();
            int time = buf.m_130242_();
            String toolType = buf.m_130277_();
            boolean polish = buf.readBoolean();
            return new CastingRecipe(id, group, category, result, xp, time, mats, toolType, polish);
        }

        public void toNetwork(FriendlyByteBuf buf, CastingRecipe recipe) {
            buf.m_130070_(recipe.group);
            buf.writeInt(recipe.requiredMaterials.size());
            recipe.requiredMaterials.forEach((k, v) -> {
                buf.m_130070_(k);
                buf.writeDouble(v.doubleValue());
            });
            buf.m_130055_(recipe.result);
            buf.writeFloat(recipe.experience);
            buf.m_130130_(recipe.cookingTime);
            buf.m_130070_(recipe.toolType);
            buf.writeBoolean(recipe.needPolishing);
        }
    }

    public static class Type
    implements RecipeType<CastingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "casting";
    }
}

