/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.recipe.ModRecipes;

public class RockKnappingRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final boolean[][] pattern;
    private final boolean mirrored;

    public RockKnappingRecipe(ResourceLocation id, ItemStack output, boolean[][] pattern, boolean mirrored) {
        this.id = id;
        this.output = output;
        this.pattern = pattern;
        this.mirrored = mirrored;
        if (pattern.length != 3 || pattern[0].length != 3) {
            throw new IllegalArgumentException("Knapping pattern must be 3x3");
        }
    }

    public boolean m_5818_(Container inv, Level world) {
        if (inv.m_6643_() != 9) {
            return false;
        }
        boolean[][] inputGrid = new boolean[3][3];
        for (int i = 0; i < 9; ++i) {
            int row = i / 3;
            int col = i % 3;
            inputGrid[row][col] = inv.m_8020_(i).m_41619_();
        }
        for (int offsetY = -2; offsetY <= 2; ++offsetY) {
            for (int offsetX = -2; offsetX <= 2; ++offsetX) {
                if (!this.matchesPattern(inputGrid, offsetX, offsetY, false) && (!this.mirrored || !this.matchesPattern(inputGrid, offsetX, offsetY, true))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesPattern(boolean[][] inputGrid, int offsetX, int offsetY, boolean mirror) {
        int patternX;
        for (int py = 0; py < 3; ++py) {
            for (int px = 0; px < 3; ++px) {
                if (py >= this.pattern.length || px >= this.pattern[py].length) continue;
                patternX = mirror ? this.pattern[py].length - 1 - px : px;
                int inputX = px + offsetX;
                int inputY = py + offsetY;
                if (!(inputX < 0 || inputX >= 3 || inputY < 0 || inputY >= 3 ? this.pattern[py][patternX] : this.pattern[py][patternX] != inputGrid[inputY][inputX])) continue;
                return false;
            }
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                boolean inPattern;
                patternX = x - offsetX;
                int patternY = y - offsetY;
                if (mirror) {
                    patternX = this.pattern[y].length - 1 - patternX;
                }
                boolean bl = inPattern = patternY >= 0 && patternY < this.pattern.length && patternX >= 0 && patternX < this.pattern[patternY].length;
                if (inPattern || !inputGrid[y][x]) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width == 3 && height == 3;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ROCK_KNAPPING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.KNAPPING.get();
    }

    public boolean[][] getPattern() {
        return this.pattern;
    }

    public static class Serializer
    implements RecipeSerializer<RockKnappingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"overgeared", (String)"rock_knapping");

        public RockKnappingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            ItemStack output = buffer.m_130267_();
            boolean[][] pattern = new boolean[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    pattern[i][j] = buffer.readBoolean();
                }
            }
            boolean mirrored = buffer.readBoolean();
            return new RockKnappingRecipe(id, output, pattern, mirrored);
        }

        public void toNetwork(FriendlyByteBuf buffer, RockKnappingRecipe recipe) {
            buffer.m_130055_(recipe.output);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    buffer.writeBoolean(recipe.pattern[i][j]);
                }
            }
            buffer.writeBoolean(recipe.mirrored);
        }

        public RockKnappingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"result"));
            JsonArray patternArray = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"pattern");
            boolean[][] pattern = new boolean[3][3];
            for (int i = 0; i < patternArray.size(); ++i) {
                String row = GsonHelper.m_13805_((JsonElement)patternArray.get(i), (String)"pattern row");
                for (int j = 0; j < row.length(); ++j) {
                    char c = row.charAt(j);
                    pattern[i][j] = c == 'x' || c == 'X';
                }
            }
            boolean mirrored = GsonHelper.m_13855_((JsonObject)pSerializedRecipe, (String)"mirrored", (boolean)false);
            return new RockKnappingRecipe(pRecipeId, output, pattern, mirrored);
        }
    }

    public static class Type
    implements RecipeType<RockKnappingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "rock_knapping";
    }
}

