/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.screen;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.advancement.ModAdvancementTriggers;
import net.stirdrem.overgeared.item.custom.KnappableRockItem;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.recipe.RockKnappingRecipe;
import net.stirdrem.overgeared.screen.ModMenuTypes;

public class RockKnappingMenu
extends AbstractContainerMenu {
    private final Container craftingGrid = new SimpleContainer(9);
    private final Container resultContainer = new SimpleContainer(1);
    private final Level level;
    private final RecipeManager recipeManager;
    private final Player player;
    private ItemStack inputRock;
    private boolean knappingFinished = false;
    private boolean resultCollected = false;
    private boolean rockConsumed = false;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 36;
    private static final int PLAYER_FIRST_SLOT_INDEX = 0;
    private static final int PLAYER_LAST_SLOT_INDEX = 35;
    private static final int GRID_FIRST_SLOT_INDEX = 36;
    private static final int GRID_LAST_SLOT_INDEX = 44;
    private static final int RESULT_SLOT_INDEX = 45;

    public RockKnappingMenu(int id, Inventory playerInv, FriendlyByteBuf extraData) {
        this(id, playerInv, playerInv.f_35978_.m_9236_().m_7465_());
    }

    public RockKnappingMenu(int id, Inventory playerInv, RecipeManager recipeManager) {
        super((MenuType)ModMenuTypes.ROCK_KNAPPING_MENU.get(), id);
        this.level = playerInv.f_35978_.m_9236_();
        this.recipeManager = recipeManager;
        this.player = playerInv.f_35978_;
        ItemStack mainHandItem = this.player.m_21205_();
        ItemStack offHandItem = this.player.m_21206_();
        if (mainHandItem.m_41720_() instanceof KnappableRockItem) {
            this.inputRock = mainHandItem.m_41777_();
        } else if (offHandItem.m_41720_() instanceof KnappableRockItem) {
            this.inputRock = offHandItem.m_41777_();
        } else {
            playerInv.f_35978_.m_6915_();
            return;
        }
        this.addPlayerHotbar(playerInv);
        this.addPlayerInventory(playerInv);
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot(this.craftingGrid, i, -1000, -1000){

                public boolean m_5857_(ItemStack stack) {
                    return false;
                }

                public boolean m_8010_(Player player) {
                    return false;
                }
            });
        }
        this.m_38897_(new Slot(this.resultContainer, 0, 124, 35){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                super.m_142406_(player, stack);
                RockKnappingMenu.this.knappingFinished = true;
                RockKnappingMenu.this.resultCollected = true;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ModAdvancementTriggers.KNAPPING.trigger(serverPlayer);
                }
            }

            public boolean m_8010_(Player player) {
                return !this.m_7993_().m_41619_() && !RockKnappingMenu.this.knappingFinished;
            }
        });
    }

    public boolean isResultCollected() {
        return this.resultCollected;
    }

    public void markResultCollected() {
        this.resultCollected = true;
        this.knappingFinished = true;
    }

    private void addPlayerInventory(Inventory playerInv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInv) {
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 142));
        }
    }

    public boolean m_6875_(Player player) {
        if (!this.rockConsumed) {
            return this.hasInputRock(player);
        }
        return true;
    }

    private boolean hasInputRock(Player player) {
        boolean hasRock;
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        boolean bl = hasRock = ItemStack.m_150942_((ItemStack)mainHand, (ItemStack)this.inputRock) && mainHand.m_41613_() > 0 || ItemStack.m_150942_((ItemStack)offHand, (ItemStack)this.inputRock) && offHand.m_41613_() > 0;
        if (!hasRock && !player.m_9236_().f_46443_) {
            player.m_6915_();
        }
        return hasRock;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 45) {
                if (!this.m_38903_(itemstack1, 0, 36, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
                if (itemstack1.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                    this.knappingFinished = true;
                    this.resultCollected = true;
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ModAdvancementTriggers.KNAPPING.trigger(serverPlayer);
                    }
                } else {
                    slot.m_6654_();
                }
                return itemstack;
            }
            if (index >= 0 && index <= 35 ? (index < 27 ? !this.m_38903_(itemstack1, 27, 36, false) : !this.m_38903_(itemstack1, 0, 27, false)) : index >= 36 && index <= 44) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public void setChip(int index) {
        if (this.knappingFinished || this.resultCollected) {
            return;
        }
        if (!this.rockConsumed) {
            this.consumeInputRock();
            this.rockConsumed = true;
        }
        if (!this.craftingGrid.m_8020_(index).m_41619_()) {
            this.craftingGrid.m_6836_(index, ItemStack.f_41583_);
        } else {
            this.craftingGrid.m_6836_(index, new ItemStack((ItemLike)Items.f_42484_));
        }
        this.updateResult();
    }

    private void consumeInputRock() {
        if (this.level.f_46443_) {
            return;
        }
        ItemStack mainHand = this.player.m_21205_();
        ItemStack offHand = this.player.m_21206_();
        if (ItemStack.m_150942_((ItemStack)mainHand, (ItemStack)this.inputRock) && mainHand.m_41613_() > 0) {
            mainHand.m_41774_(1);
            this.player.m_150109_().m_6596_();
        } else if (ItemStack.m_150942_((ItemStack)offHand, (ItemStack)this.inputRock) && offHand.m_41613_() > 0) {
            offHand.m_41774_(1);
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_36095_.m_38946_();
            }
        }
    }

    private void updateResult() {
        if (this.level == null || this.knappingFinished || this.resultCollected) {
            return;
        }
        RockKnappingRecipe matchingRecipe = this.recipeManager.m_44015_((RecipeType)ModRecipeTypes.KNAPPING.get(), this.craftingGrid, this.level).orElse(null);
        if (matchingRecipe != null) {
            this.resultContainer.m_6836_(0, matchingRecipe.m_8043_(this.level.m_9598_()).m_41777_());
        } else {
            this.resultContainer.m_6836_(0, ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public boolean isChipped(int index) {
        return !this.craftingGrid.m_8020_(index).m_41619_();
    }

    public void clearGrid() {
        for (int i = 0; i < 9; ++i) {
            this.craftingGrid.m_6836_(i, ItemStack.f_41583_);
        }
        this.resultContainer.m_6836_(0, ItemStack.f_41583_);
        this.m_38946_();
    }

    public boolean isKnappingFinished() {
        return this.knappingFinished;
    }

    public boolean hasAnyChippedSpots() {
        for (int i = 0; i < 9; ++i) {
            if (!this.isChipped(i)) continue;
            return true;
        }
        return false;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        ItemStack result = this.resultContainer.m_8020_(0);
        if (!result.m_41619_() && !this.resultCollected) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModAdvancementTriggers.KNAPPING.trigger(serverPlayer);
            }
            if (!player.m_150109_().m_36054_(result.m_41777_())) {
                player.m_36176_(result.m_41777_(), false);
            }
            this.resultContainer.m_6836_(0, ItemStack.f_41583_);
        }
    }

    public boolean[][] getGridState() {
        boolean[][] grid = new boolean[3][3];
        for (int i = 0; i < 9; ++i) {
            int row = i / 3;
            int col = i % 3;
            grid[row][col] = this.isChipped(i);
        }
        return grid;
    }
}

