/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.compat;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.recipe.NetherAlloySmeltingRecipe;

public class NetherAlloySmeltingRecipeCategory
implements IRecipeCategory<NetherAlloySmeltingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.m_214293_((String)"overgeared", (String)"nether_alloy_smelting");
    public static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/nether_furnace_jei.png");
    public static final RecipeType<NetherAlloySmeltingRecipe> ALLOY_SMELTING_TYPE = new RecipeType(UID, NetherAlloySmeltingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final int animationTime = 100;
    private final IDrawableAnimated arrowAnimated;
    private final IDrawableStatic arrowStatic;
    private final IDrawableAnimated flameAnimated;
    private final IDrawableStatic flameStatic;
    private final int textureWidth = 143;
    private final int textureHeight = 54;

    public NetherAlloySmeltingRecipeCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 0, 120, 54).setTextureSize(143, 54).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.NETHER_ALLOY_FURNACE.get()));
        this.arrowStatic = helper.drawableBuilder(TEXTURE, 120, 14, 23, 16).setTextureSize(143, 54).build();
        this.arrowAnimated = helper.createAnimatedDrawable(this.arrowStatic, 100, IDrawableAnimated.StartDirection.LEFT, false);
        this.flameStatic = helper.drawableBuilder(TEXTURE, 120, 0, 14, 13).setTextureSize(143, 54).build();
        this.flameAnimated = helper.createAnimatedDrawable(this.flameStatic, 50, IDrawableAnimated.StartDirection.TOP, true);
    }

    public RecipeType<NetherAlloySmeltingRecipe> getRecipeType() {
        return ALLOY_SMELTING_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.overgeared.jei.category.nether_alloy_smelting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(NetherAlloySmeltingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Float exp = Float.valueOf(recipe.getExperience());
        this.arrowAnimated.draw(guiGraphics, 60, 19);
        this.flameAnimated.draw(guiGraphics, 64, 39);
        Object expText = exp.floatValue() == (float)exp.intValue() ? exp.intValue() + " XP" : String.format("%.1f XP", exp);
        int textWidth = Minecraft.m_91087_().f_91062_.m_92895_((String)expText);
        int xPos = this.background.getWidth() - textWidth;
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, (String)expText, xPos, 45, -1, true);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, NetherAlloySmeltingRecipe recipe, IFocusGroup focuses) {
        List<Ingredient> ingredients = recipe.getIngredientsList();
        int inputCount = ingredients.size();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int slotIndex = row * 3 + col;
                if (slotIndex >= ingredients.size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, 1 + col * 18, 1 + row * 18).addIngredients(ingredients.get(slotIndex));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 99, 20).addItemStack(recipe.m_8043_(null));
    }
}

