/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.item.ToolType;

public class ToolTypeRegistry {
    private static final List<ToolType> DEFAULT_TYPES = List.of(ToolType.SWORD, ToolType.AXE, ToolType.PICKAXE, ToolType.SHOVEL, ToolType.HOE, ToolType.MULTITOOL);
    private static final List<ToolType> HIDDEN_TYPES = new ArrayList<ToolType>();
    private static final Map<String, ToolType> BY_ID = new HashMap<String, ToolType>();

    public static void init() {
        List hiddenIds;
        BY_ID.clear();
        HIDDEN_TYPES.clear();
        DEFAULT_TYPES.forEach(type -> BY_ID.put(type.getId(), (ToolType)type));
        List availableIds = (List)ServerConfig.AVAILABLE_TOOL_TYPES.get();
        if (availableIds != null) {
            for (String id : availableIds) {
                ToolTypeRegistry.byId(id).ifPresent(type -> {});
            }
        }
        if ((hiddenIds = (List)ServerConfig.HIDDEN_TOOL_TYPES.get()) != null) {
            for (String id : hiddenIds) {
                BY_ID.computeIfPresent(id.toUpperCase(Locale.ROOT), (k, t) -> {
                    HIDDEN_TYPES.add((ToolType)t);
                    return t;
                });
            }
        }
        System.out.println("Registered tool types: " + BY_ID.keySet().stream().collect(Collectors.joining(", ")));
    }

    public static List<ToolType> getRegisteredTypes() {
        ArrayList<ToolType> list = new ArrayList<ToolType>();
        List allowed = (List)ServerConfig.AVAILABLE_TOOL_TYPES.get();
        if (allowed == null) {
            return list;
        }
        for (String id : allowed) {
            String key = id.toUpperCase(Locale.ROOT);
            Optional<ToolType> existing = ToolTypeRegistry.byId(key);
            if (existing.isPresent()) {
                list.add(existing.get());
                continue;
            }
            ToolType newType = new ToolType(key);
            BY_ID.put(key, newType);
            list.add(newType);
        }
        return list;
    }

    public static List<ToolType> getRegisteredTypesAll() {
        List<ToolType> list = ToolTypeRegistry.getRegisteredTypes();
        list.addAll(HIDDEN_TYPES);
        return list;
    }

    public static Optional<ToolType> byId(String id) {
        if (id == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(BY_ID.get(id.toUpperCase(Locale.ROOT)));
    }
}

