/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.networking.packet;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.stirdrem.overgeared.OvergearedMod;
import net.stirdrem.overgeared.block.entity.AbstractSmithingAnvilBlockEntity;
import net.stirdrem.overgeared.event.AnvilMinigameEvents;
import net.stirdrem.overgeared.event.ModItemInteractEvents;

public class ResetMinigameS2CPacket {
    private final BlockPos anvilPos;

    public ResetMinigameS2CPacket(BlockPos anvilPos) {
        this.anvilPos = anvilPos;
    }

    public ResetMinigameS2CPacket(FriendlyByteBuf buf) {
        this.anvilPos = buf.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.anvilPos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            try {
                BlockEntity be;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null && (be = player.f_19853_.m_7702_(this.anvilPos)) instanceof AbstractSmithingAnvilBlockEntity) {
                    AbstractSmithingAnvilBlockEntity anvil = (AbstractSmithingAnvilBlockEntity)be;
                    String quality = anvil.blueprintQuality();
                    OvergearedMod.LOGGER.info("Resetting minigame for {} at anvil {} with quality {}", new Object[]{player.m_7755_().getString(), this.anvilPos, quality});
                    if (ModItemInteractEvents.playerAnvilPositions.getOrDefault(player.m_20148_(), BlockPos.f_121853_).equals((Object)this.anvilPos)) {
                        ModItemInteractEvents.playerAnvilPositions.remove(player.m_20148_());
                        ModItemInteractEvents.playerMinigameVisibility.remove(player.m_20148_());
                        AnvilMinigameEvents.reset(quality);
                    }
                }
            }
            catch (Exception e) {
                OvergearedMod.LOGGER.error("Failed to process ResetMinigameS2CPacket for anvil at {}", (Object)this.anvilPos, (Object)e);
            }
        });
        return true;
    }

    public BlockPos getAnvilPos() {
        return this.anvilPos;
    }
}

