/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.recipe.ModRecipes;

public class AlloySmeltingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final String group;
    private final CraftingBookCategory category;
    private final List<Ingredient> inputs;
    private final ItemStack output;
    private final float experience;
    private final int cookingTime;

    public AlloySmeltingRecipe(ResourceLocation id, String group, CraftingBookCategory category, List<Ingredient> inputs, ItemStack output, float experience, int cookingTime) {
        this.id = id;
        this.group = group;
        this.category = category;
        this.inputs = inputs;
        this.output = output;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    public boolean matches(SimpleContainer inv, Level level) {
        if (level.f_46443_) {
            return false;
        }
        ArrayList<Ingredient> remainingIngredients = new ArrayList<Ingredient>();
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>();
        for (Ingredient ingredient : this.inputs) {
            if (ingredient.m_43947_()) continue;
            remainingIngredients.add(ingredient);
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            remainingItems.add(stack);
        }
        if (remainingItems.size() != remainingIngredients.size()) {
            return false;
        }
        for (ItemStack stack : remainingItems) {
            boolean matched = false;
            for (int i = 0; i < remainingIngredients.size(); ++i) {
                if (!((Ingredient)remainingIngredients.get(i)).test(stack)) continue;
                remainingIngredients.remove(i);
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return remainingIngredients.isEmpty();
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int w, int h) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ALLOY_SMELTING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.ALLOY_SMELTING.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public List<Ingredient> getIngredientsList() {
        return this.inputs;
    }

    public static class Serializer
    implements RecipeSerializer<AlloySmeltingRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public AlloySmeltingRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = json.has("group") ? json.get("group").getAsString() : "";
            CraftingBookCategory category = json.has("category") ? (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(json.get("category").getAsString(), (Enum)CraftingBookCategory.MISC) : CraftingBookCategory.MISC;
            JsonArray ingredients = json.getAsJsonArray("ingredients");
            ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
            for (int i = 0; i < ingredients.size(); ++i) {
                inputList.add(Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject("result"));
            float experience = json.has("experience") ? json.get("experience").getAsFloat() : 0.0f;
            int cookingTime = json.has("cookingtime") ? json.get("cookingtime").getAsInt() : 200;
            return new AlloySmeltingRecipe(id, group, category, inputList, result, experience, cookingTime);
        }

        public AlloySmeltingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            int count = buf.m_130242_();
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (int i = 0; i < count; ++i) {
                inputs.add(Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack result = buf.m_130267_();
            float experience = buf.readFloat();
            int cookingTime = buf.m_130242_();
            return new AlloySmeltingRecipe(id, group, category, inputs, result, experience, cookingTime);
        }

        public void toNetwork(FriendlyByteBuf buf, AlloySmeltingRecipe recipe) {
            buf.m_130070_(recipe.group);
            buf.m_130068_((Enum)recipe.category);
            buf.m_130130_(recipe.inputs.size());
            recipe.inputs.forEach(i -> i.m_43923_(buf));
            buf.m_130055_(recipe.output);
            buf.writeFloat(recipe.experience);
            buf.m_130130_(recipe.cookingTime);
        }
    }

    public static class Type
    implements RecipeType<AlloySmeltingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "alloy_smelting";
    }
}

