/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.recipe.ModRecipes;

public class FletchingRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient tip;
    private final Ingredient shaft;
    private final Ingredient feather;
    private final Ingredient potion;
    private final ItemStack result;
    private final ItemStack resultTipped;
    private final ItemStack resultLingering;
    private final String tippedTag;
    private final String lingeringTag;

    public FletchingRecipe(ResourceLocation id, Ingredient tip, Ingredient shaft, Ingredient feather, Ingredient potion, ItemStack result, ItemStack resultTipped, ItemStack resultLingering, String tippedTag, String lingeringTag) {
        this.id = id;
        this.tip = tip;
        this.shaft = shaft;
        this.feather = feather;
        this.potion = potion != null ? potion : Ingredient.f_43901_;
        this.result = result;
        this.resultTipped = resultTipped;
        this.resultLingering = resultLingering;
        this.tippedTag = tippedTag != null ? tippedTag : "Potion";
        this.lingeringTag = lingeringTag != null ? lingeringTag : "LingeringPotion";
    }

    public boolean m_5818_(Container container, Level level) {
        return !(this.tip != Ingredient.f_43901_ && !this.tip.test(container.m_8020_(0)) || this.shaft != Ingredient.f_43901_ && !this.shaft.test(container.m_8020_(1)) || this.feather != Ingredient.f_43901_ && !this.feather.test(container.m_8020_(2)) || this.potion != Ingredient.f_43901_ && !this.potion.test(container.m_8020_(3)));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.getDefaultResult();
    }

    public Ingredient getTip() {
        return this.tip;
    }

    public Ingredient getShaft() {
        return this.shaft;
    }

    public Ingredient getFeather() {
        return this.feather;
    }

    public Ingredient getPotion() {
        return this.potion;
    }

    public boolean hasPotion() {
        return this.potion != null && !this.potion.m_43947_();
    }

    public ItemStack getDefaultResult() {
        return this.result.m_41777_();
    }

    public ItemStack getTippedResult() {
        return this.resultTipped.m_41777_();
    }

    public ItemStack getLingeringResult() {
        return this.resultLingering.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.getDefaultResult();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.FLETCHING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.FLETCHING.get();
    }

    public boolean hasTippedResult() {
        return !this.resultTipped.m_41619_();
    }

    public boolean hasLingeringResult() {
        return !this.resultLingering.m_41619_();
    }

    public String getTippedTag() {
        return this.tippedTag;
    }

    public String getLingeringTag() {
        return this.lingeringTag;
    }

    public static class Serializer
    implements RecipeSerializer<FletchingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"overgeared", (String)"fletching");

        public FletchingRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonObject material = GsonHelper.m_13930_((JsonObject)json, (String)"material");
            Ingredient tip = material.has("tip") ? Ingredient.m_43917_((JsonElement)material.get("tip")) : Ingredient.f_43901_;
            Ingredient shaft = material.has("shaft") ? Ingredient.m_43917_((JsonElement)material.get("shaft")) : Ingredient.f_43901_;
            Ingredient feather = material.has("feather") ? Ingredient.m_43917_((JsonElement)material.get("feather")) : Ingredient.f_43901_;
            Ingredient potion = json.has("potion") ? Ingredient.m_43917_((JsonElement)json.get("potion")) : Ingredient.f_43901_;
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            ItemStack resultTipped = ItemStack.f_41583_;
            String tippedTag = null;
            if (json.has("result_tipped")) {
                JsonObject tippedJson = GsonHelper.m_13930_((JsonObject)json, (String)"result_tipped");
                resultTipped = ShapedRecipe.m_151274_((JsonObject)tippedJson);
                if (tippedJson.has("tag")) {
                    tippedTag = GsonHelper.m_13906_((JsonObject)tippedJson, (String)"tag");
                }
            }
            ItemStack resultLingering = ItemStack.f_41583_;
            String lingeringTag = null;
            if (json.has("result_lingering")) {
                JsonObject lingeringJson = GsonHelper.m_13930_((JsonObject)json, (String)"result_lingering");
                resultLingering = ShapedRecipe.m_151274_((JsonObject)lingeringJson);
                if (lingeringJson.has("tag")) {
                    lingeringTag = GsonHelper.m_13906_((JsonObject)lingeringJson, (String)"tag");
                }
            }
            return new FletchingRecipe(id, tip, shaft, feather, potion, result, resultTipped, resultLingering, tippedTag, lingeringTag);
        }

        public FletchingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient tip = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient shaft = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient feather = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient potion = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            ItemStack resultTipped = buffer.m_130267_();
            ItemStack resultLingering = buffer.m_130267_();
            String tippedTag = buffer.readBoolean() ? buffer.m_130277_() : null;
            String lingeringTag = buffer.readBoolean() ? buffer.m_130277_() : null;
            return new FletchingRecipe(id, tip, shaft, feather, potion, result, resultTipped, resultLingering, tippedTag, lingeringTag);
        }

        public void toNetwork(FriendlyByteBuf buffer, FletchingRecipe recipe) {
            recipe.tip.m_43923_(buffer);
            recipe.shaft.m_43923_(buffer);
            recipe.feather.m_43923_(buffer);
            recipe.potion.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
            buffer.m_130055_(recipe.resultTipped);
            buffer.m_130055_(recipe.resultLingering);
            if (recipe.tippedTag != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(recipe.tippedTag);
            } else {
                buffer.writeBoolean(false);
            }
            if (recipe.lingeringTag != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(recipe.lingeringTag);
            } else {
                buffer.writeBoolean(false);
            }
        }
    }

    public static class Type
    implements RecipeType<FletchingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "fletching";
    }
}

