/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.datapack;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class CastingToolTypesReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, List<CastingToolEntry>> DATA = new ConcurrentHashMap<ResourceLocation, List<CastingToolEntry>>();
    public static final CastingToolTypesReloadListener INSTANCE = new CastingToolTypesReloadListener();
    private static final Gson GSON = new Gson();

    public CastingToolTypesReloadListener() {
        super(GSON, "casting_tooltypes");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, ResourceManager resourceManager, ProfilerFiller profiler) {
        DATA.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resources.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonElement jsonElement = entry.getValue();
            try {
                if (jsonElement.isJsonObject()) {
                    JsonObject json = jsonElement.getAsJsonObject();
                    List<CastingToolEntry> toolEntries = this.parseToolEntries(json);
                    DATA.put(id, toolEntries);
                    continue;
                }
                throw new JsonSyntaxException("Expected JSON object for casting tool types entry: " + id);
            }
            catch (Exception e) {
                System.err.println("Failed to parse casting tool types entry: " + id + ", error: " + e.getMessage());
            }
        }
        System.out.println("Loaded " + DATA.size() + " casting tool types entries");
    }

    private List<CastingToolEntry> parseToolEntries(JsonObject json) {
        ArrayList<CastingToolEntry> entries = new ArrayList<CastingToolEntry>();
        if (!json.has("tools")) {
            throw new JsonSyntaxException("Missing 'tools' array for casting tool types entry");
        }
        JsonArray toolsArray = json.getAsJsonArray("tools");
        for (JsonElement toolElement : toolsArray) {
            if (!toolElement.isJsonArray()) {
                throw new JsonSyntaxException("Expected array for tool entry");
            }
            JsonArray toolArray = toolElement.getAsJsonArray();
            if (toolArray.size() != 2) {
                throw new JsonSyntaxException("Tool entry must have exactly 2 elements: [tool_type, max_material_amount]");
            }
            String toolType = toolArray.get(0).getAsString();
            int maxMaterialAmount = toolArray.get(1).getAsInt();
            if (maxMaterialAmount <= 0) {
                throw new JsonSyntaxException("Max material amount must be positive: " + maxMaterialAmount);
            }
            entries.add(new CastingToolEntry(toolType, maxMaterialAmount));
        }
        return entries;
    }

    public static Map<ResourceLocation, List<CastingToolEntry>> getData() {
        return Collections.unmodifiableMap(DATA);
    }

    public static List<CastingToolEntry> getAllToolEntries() {
        ArrayList<CastingToolEntry> allEntries = new ArrayList<CastingToolEntry>();
        for (List<CastingToolEntry> entries : DATA.values()) {
            allEntries.addAll(entries);
        }
        return allEntries;
    }

    public static Optional<CastingToolEntry> getEntryForToolType(String toolType) {
        return CastingToolTypesReloadListener.getAllToolEntries().stream().filter(entry -> entry.getToolType().equalsIgnoreCase(toolType)).findFirst();
    }

    public static int getMaxMaterialAmount(String toolType) {
        return CastingToolTypesReloadListener.getEntryForToolType(toolType).map(CastingToolEntry::getMaxMaterialAmount).orElse(0);
    }

    public static Set<String> getAllToolTypes() {
        HashSet<String> toolTypes = new HashSet<String>();
        for (CastingToolEntry entry : CastingToolTypesReloadListener.getAllToolEntries()) {
            toolTypes.add(entry.getToolType());
        }
        return toolTypes;
    }

    public static void clear() {
        DATA.clear();
    }

    public static class CastingToolEntry {
        private final String toolType;
        private final int maxMaterialAmount;

        public CastingToolEntry(String toolType, int maxMaterialAmount) {
            this.toolType = toolType;
            this.maxMaterialAmount = maxMaterialAmount;
        }

        public String getToolType() {
            return this.toolType;
        }

        public int getMaxMaterialAmount() {
            return this.maxMaterialAmount;
        }
    }
}

