/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.stirdrem.overgeared.OvergearedMod;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.block.custom.StoneSmithingAnvil;
import net.stirdrem.overgeared.block.entity.AbstractSmithingAnvilBlockEntity;
import net.stirdrem.overgeared.client.ClientAnvilMinigameData;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.datapack.GrindingBlacklistReloadListener;
import net.stirdrem.overgeared.event.AnvilMinigameEvents;
import net.stirdrem.overgeared.heatedtem.HeatedItemProvider;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.networking.ModMessages;
import net.stirdrem.overgeared.networking.packet.HideMinigameS2CPacket;
import net.stirdrem.overgeared.networking.packet.MinigameSetStartedC2SPacket;
import net.stirdrem.overgeared.networking.packet.MinigameSyncS2CPacket;
import net.stirdrem.overgeared.networking.packet.SetMinigameVisibleC2SPacket;
import net.stirdrem.overgeared.recipe.CoolingRecipe;
import net.stirdrem.overgeared.recipe.ForgingRecipe;
import net.stirdrem.overgeared.recipe.GrindingRecipe;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.screen.FletchingStationMenu;
import net.stirdrem.overgeared.util.ModTags;
import net.stirdrem.overgeared.util.QualityHelper;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="overgeared")
public class ModItemInteractEvents {
    public static final Map<UUID, BlockPos> playerAnvilPositions = new HashMap<UUID, BlockPos>();
    public static final Map<UUID, Boolean> playerMinigameVisibility = new HashMap<UUID, Boolean>();
    private static final Set<ItemEntity> trackedEntities = ConcurrentHashMap.newKeySet();
    private static final ConcurrentMap<ItemEntity, Long> trackedSinceMs = new ConcurrentHashMap<ItemEntity, Long>();
    private static final long TRACKED_PRUNE_MS = 120000L;
    private static final Random RANDOM = new Random();
    private static final Map<ServerLevel, List<ItemEntity>> trackedEntitiesPerWorld = new HashMap<ServerLevel, List<ItemEntity>>();
    private static final Map<Item, Boolean> COOLING_CACHE = new HashMap<Item, Boolean>();

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        boolean isHeatedItem;
        ItemStack heldStack = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        BlockState state = level.m_8055_(pos);
        boolean bl = isHeatedItem = heldStack.m_204117_(ModTags.Items.HEATED_METALS) || heldStack.m_41782_() && heldStack.m_41783_().m_128471_("Heated");
        if (!isHeatedItem) {
            return;
        }
        if (state.m_60713_(Blocks.f_152476_)) {
            ModItemInteractEvents.handleCauldronInteraction(level, pos, player, heldStack, state);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    private static void triggerAdvancement(ServerPlayer player, String path) {
        AdvancementProgress progress;
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(ResourceLocation.m_214293_((String)"overgeared", (String)path));
        if (advancement != null && !(progress = player.m_8960_().m_135996_(advancement)).m_8193_()) {
            for (String criterion : progress.m_8219_()) {
                player.m_8960_().m_135988_(advancement, criterion);
            }
        }
    }

    @SubscribeEvent
    public static void onUseSmithingHammer(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        ItemStack heldItem = event.getItemStack();
        if (!heldItem.m_204117_(ModTags.Items.SMITHING_HAMMERS)) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        BlockEntity be = level.m_7702_(pos);
        BlockState clickedState = level.m_8055_(pos);
        if (!level.f_46443_ && player.m_6047_() && clickedState.m_204336_(ModTags.Blocks.ANVIL_BASES) && ((Boolean)ServerConfig.ENABLE_STONE_TO_ANVIL.get()).booleanValue()) {
            BlockState newState = (BlockState)((Block)ModBlocks.STONE_SMITHING_ANVIL.get()).m_49966_().m_61124_((Property)StoneSmithingAnvil.FACING, (Comparable)player.m_6350_().m_122427_());
            level.m_7731_(pos, newState, 3);
            level.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModItemInteractEvents.triggerAdvancement(serverPlayer, "making_anvil");
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (!level.f_46443_ && player.m_6047_() && clickedState.m_60713_(Blocks.f_50322_) && ((Boolean)ServerConfig.ENABLE_ANVIL_TO_SMITHING.get()).booleanValue()) {
            BlockState newState = (BlockState)((Block)ModBlocks.SMITHING_ANVIL.get()).m_49966_().m_61124_((Property)StoneSmithingAnvil.FACING, (Comparable)player.m_6350_().m_122427_());
            level.m_7731_(pos, newState, 3);
            level.m_5594_(null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModItemInteractEvents.triggerAdvancement(serverPlayer, "making_anvil");
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (!level.m_5776_() && !(be instanceof AbstractSmithingAnvilBlockEntity)) {
            ModItemInteractEvents.hideMinigame((ServerPlayer)player);
        }
        if (!(be instanceof AbstractSmithingAnvilBlockEntity)) {
            return;
        }
        AbstractSmithingAnvilBlockEntity anvilBE = (AbstractSmithingAnvilBlockEntity)be;
        UUID playerUUID = player.m_20148_();
        if (!player.m_6047_()) {
            return;
        }
        if (!level.f_46443_) {
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (anvilBE.hasRecipe() && !((Boolean)ServerConfig.ENABLE_MINIGAME.get()).booleanValue()) {
                serverPlayer.m_240418_((Component)Component.m_237115_((String)"message.overgeared.no_minigame").m_130940_(ChatFormatting.RED), true);
                return;
            }
            if (!anvilBE.hasRecipe()) {
                serverPlayer.m_240418_((Component)Component.m_237115_((String)"message.overgeared.no_recipe").m_130940_(ChatFormatting.RED), true);
                return;
            }
            if (!anvilBE.hasQuality() && !anvilBE.needsMinigame()) {
                serverPlayer.m_240418_((Component)Component.m_237115_((String)"message.overgeared.item_has_no_quality").m_130940_(ChatFormatting.RED), true);
                return;
            }
            UUID currentOwner = anvilBE.getOwnerUUID();
            if (currentOwner != null && !currentOwner.equals(playerUUID)) {
                serverPlayer.m_240418_((Component)Component.m_237115_((String)"message.overgeared.anvil_in_use_by_another").m_130940_(ChatFormatting.RED), true);
                return;
            }
            if (currentOwner == null && !playerAnvilPositions.containsKey(player.m_20148_())) {
                anvilBE.setOwner(playerUUID);
                playerAnvilPositions.put(playerUUID, pos);
                playerMinigameVisibility.put(playerUUID, true);
                CompoundTag sync = new CompoundTag();
                sync.m_128362_("anvilOwner", playerUUID);
                sync.m_128356_("anvilPos", pos.m_121878_());
                ModMessages.sendToAll(new MinigameSyncS2CPacket(sync));
                return;
            }
            if (playerAnvilPositions.get(player.m_20148_()) != null && !pos.equals((Object)playerAnvilPositions.get(player.m_20148_()))) {
                serverPlayer.m_240418_((Component)Component.m_237115_((String)"message.overgeared.another_anvil_in_use").m_130940_(ChatFormatting.RED), true);
                return;
            }
        } else {
            if (anvilBE.hasRecipe() && !((Boolean)ServerConfig.ENABLE_MINIGAME.get()).booleanValue()) {
                return;
            }
            if (!anvilBE.hasRecipe()) {
                return;
            }
            if (!anvilBE.hasQuality() && !anvilBE.needsMinigame()) {
                return;
            }
            UUID currentOwner = ClientAnvilMinigameData.getOccupiedAnvil(pos);
            if (currentOwner != null && !currentOwner.equals(player.m_20148_())) {
                return;
            }
            if (player.m_20148_().equals(currentOwner) || currentOwner == null && ClientAnvilMinigameData.getPendingMinigamePos() == null) {
                BlockPos pos1 = pos;
                BlockPos anvilPos = playerAnvilPositions.get(player.m_20148_());
                if (playerAnvilPositions.get(player.m_20148_()) != null && !pos.equals((Object)playerAnvilPositions.get(player.m_20148_()))) {
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.PASS);
                    return;
                }
                if (anvilBE.hasRecipe() || anvilBE.needsMinigame()) {
                    anvilBE.setOwner(playerUUID);
                    AtomicReference<String> quality = new AtomicReference<String>("perfect");
                    Optional<ForgingRecipe> recipeOpt = anvilBE.getCurrentRecipe();
                    recipeOpt.ifPresent(recipe -> {
                        if (AnvilMinigameEvents.minigameStarted) {
                            boolean isVisible = AnvilMinigameEvents.isIsVisible();
                            AnvilMinigameEvents.setIsVisible(pos, !isVisible);
                            ModMessages.sendToServer(new SetMinigameVisibleC2SPacket(pos, !isVisible));
                            playerMinigameVisibility.put(player.m_20148_(), !isVisible);
                        } else {
                            quality.set(anvilBE.minigameQuality());
                            AnvilMinigameEvents.reset((String)quality.get());
                            playerAnvilPositions.put(player.m_20148_(), pos);
                            playerMinigameVisibility.put(player.m_20148_(), true);
                            AnvilMinigameEvents.setMinigameStarted(pos, true);
                            ModMessages.sendToServer(new MinigameSetStartedC2SPacket(pos));
                            ModMessages.sendToServer(new SetMinigameVisibleC2SPacket(pos, true));
                            AnvilMinigameEvents.setHitsRemaining(anvilBE.getRequiredProgress());
                        }
                    });
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.PASS);
                return;
            }
            ClientAnvilMinigameData.setPendingMinigame(pos);
            return;
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    public static void handleAnvilOwnershipSync(CompoundTag syncData) {
        AbstractSmithingAnvilBlockEntity anvilBE;
        BlockEntity be;
        UUID owner = null;
        if (syncData.m_128441_("anvilOwner") && (owner = syncData.m_128342_("anvilOwner")).getMostSignificantBits() == 0L && owner.getLeastSignificantBits() == 0L) {
            owner = null;
        }
        BlockPos pos = BlockPos.m_122022_((long)syncData.m_128454_("anvilPos"));
        ClientAnvilMinigameData.putOccupiedAnvil(pos, owner);
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20148_().equals(owner) && pos.equals((Object)ClientAnvilMinigameData.getPendingMinigamePos()) && (be = Minecraft.m_91087_().f_91073_.m_7702_(pos)) instanceof AbstractSmithingAnvilBlockEntity && (anvilBE = (AbstractSmithingAnvilBlockEntity)be).hasRecipe()) {
            Optional<ForgingRecipe> recipeOpt = anvilBE.getCurrentRecipe();
            recipeOpt.ifPresent(recipe -> ClientAnvilMinigameData.clearPendingMinigame());
        }
    }

    public static void releaseAnvil(ServerPlayer player, BlockPos pos) {
        UUID playerId = player.m_20148_();
        BlockEntity be = player.m_9236_().m_7702_(pos);
        String quality = "perfect";
        if (be instanceof AbstractSmithingAnvilBlockEntity) {
            AbstractSmithingAnvilBlockEntity anvilBE = (AbstractSmithingAnvilBlockEntity)be;
            anvilBE.clearOwner();
            quality = anvilBE.minigameQuality();
        }
        if (playerAnvilPositions.get(playerId) != null && playerAnvilPositions.get(playerId).equals((Object)pos)) {
            playerAnvilPositions.remove(playerId);
            playerMinigameVisibility.remove(playerId);
        }
        ClientAnvilMinigameData.putOccupiedAnvil(pos, null);
        AnvilMinigameEvents.reset(quality);
        CompoundTag syncData = new CompoundTag();
        syncData.m_128356_("anvilPos", pos.m_121878_());
        syncData.m_128362_("anvilOwner", new UUID(0L, 0L));
        ModMessages.sendToAll(new MinigameSyncS2CPacket(syncData));
    }

    public static ServerPlayer getUsingPlayer(BlockPos pos) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return null;
        }
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            UUID playerId = player.m_20148_();
            if (!playerAnvilPositions.containsKey(playerId) || !playerAnvilPositions.get(playerId).equals((Object)pos)) continue;
            return player;
        }
        return null;
    }

    @SubscribeEvent
    public static void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        Player player = event.getEntity();
        Level world = event.getLevel();
        if (world.m_5776_()) {
            return;
        }
        ModItemInteractEvents.hideMinigame((ServerPlayer)player);
    }

    public static void hideMinigame(ServerPlayer player) {
        ModMessages.sendToPlayer(new HideMinigameS2CPacket(), player);
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        BlockPos pos;
        BlockState state;
        HitResult hit;
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        Level world = event.getLevel();
        if (world.m_5776_()) {
            return;
        }
        if (stack.m_204117_(ModTags.Items.HEATED_METALS) && (hit = player.m_19907_(5.0, 0.0f, false)).m_6662_() == HitResult.Type.BLOCK && (state = world.m_8055_(pos = ((BlockHitResult)hit).m_82425_())).m_60819_().m_76170_() && state.m_60734_() == Blocks.f_49990_) {
            ModItemInteractEvents.coolIngot(player, stack);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if (!world.m_5776_()) {
            hit = player.m_19907_(5.0, 0.0f, false);
            pos = ((BlockHitResult)hit).m_82425_();
            state = world.m_8055_(pos);
            if (player.m_6047_() && state.m_204336_(ModTags.Blocks.GRINDSTONES)) {
                if (player.m_21205_() != stack) {
                    return;
                }
                if (ModItemInteractEvents.hasGrindingRecipe(stack.m_41720_(), event.getLevel())) {
                    ModItemInteractEvents.grindItem(player, stack);
                    world.m_5594_(null, player.m_20183_(), SoundEvents.f_11998_, SoundSource.BLOCKS, 1.0f, 1.2f);
                    ModItemInteractEvents.spawnGrindParticles(world, pos);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
                if (stack.m_41782_() && stack.m_41783_().m_128441_("Polished") && !stack.m_41783_().m_128471_("Polished")) {
                    if (stack.m_41613_() > 1) {
                        ItemStack polishedItem = stack.m_41777_();
                        polishedItem.m_41764_(1);
                        polishedItem.m_41784_().m_128379_("Polished", true);
                        stack.m_41774_(1);
                        if (!player.m_150109_().m_36054_(polishedItem)) {
                            player.m_36176_(polishedItem, false);
                        }
                    } else {
                        stack.m_41784_().m_128379_("Polished", true);
                    }
                    world.m_5594_(null, player.m_20183_(), SoundEvents.f_11998_, SoundSource.BLOCKS, 1.0f, 1.2f);
                    ModItemInteractEvents.spawnGrindParticles(world, pos);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
                if (stack.m_41763_() && stack.m_41773_() > 0) {
                    if (!((Boolean)ServerConfig.GRINDING_RESTORE_DURABILITY.get()).booleanValue()) {
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        event.setCanceled(true);
                        return;
                    }
                    Item item = stack.m_41720_();
                    ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
                    List blacklist = (List)ServerConfig.GRINDING_BLACKLIST.get();
                    for (String entry : blacklist) {
                        if (entry.startsWith("#")) {
                            ResourceLocation tagId = new ResourceLocation(entry.substring(1));
                            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
                            if (!stack.m_204117_(tag)) continue;
                            event.setCancellationResult(InteractionResult.PASS);
                            event.setCanceled(true);
                            return;
                        }
                        if (itemId == null || !itemId.equals((Object)new ResourceLocation(entry))) continue;
                        event.setCancellationResult(InteractionResult.PASS);
                        event.setCanceled(true);
                        return;
                    }
                    boolean isBlacklisted = GrindingBlacklistReloadListener.isBlacklisted(stack);
                    if (isBlacklisted) {
                        event.setCancellationResult(InteractionResult.PASS);
                        event.setCanceled(true);
                        return;
                    }
                    CompoundTag tag = stack.m_41784_();
                    int reducedCount = tag.m_128451_("ReducedMaxDurability");
                    int originalDurability = stack.m_41720_().m_41462_();
                    float baseMultiplier = ((Double)ServerConfig.BASE_DURABILITY_MULTIPLIER.get()).floatValue();
                    float grindReduction = ((Double)ServerConfig.DURABILITY_REDUCE_PER_GRIND.get()).floatValue();
                    float qualityMultiplier = 1.0f;
                    if (tag.m_128441_("ForgingQuality")) {
                        qualityMultiplier = QualityHelper.getQualityMultiplier(stack);
                    }
                    int newOriginalDurability = (int)((float)originalDurability * baseMultiplier * qualityMultiplier);
                    float penaltyMultiplier = Math.max(0.1f, 1.0f - (float)reducedCount * grindReduction);
                    int effectiveMaxDurability = (int)((float)newOriginalDurability * penaltyMultiplier);
                    effectiveMaxDurability = Math.max(1, effectiveMaxDurability);
                    int currentDamage = stack.m_41773_();
                    if (currentDamage <= newOriginalDurability - effectiveMaxDurability) {
                        tag.m_128405_("ReducedMaxDurability", reducedCount + 1);
                        stack.m_41721_(0);
                        event.getLevel().m_5594_(null, pos, SoundEvents.f_11998_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        ModItemInteractEvents.spawnGrindParticles(world, pos);
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        event.setCanceled(true);
                        return;
                    }
                    float restorePercent = ((Double)ServerConfig.DAMAGE_RESTORE_PER_GRIND.get()).floatValue();
                    int theoreticalMaxDurability = (int)((float)originalDurability * baseMultiplier * qualityMultiplier);
                    int repairAmount = Math.max(1, (int)((float)theoreticalMaxDurability * restorePercent));
                    int newDamage = Math.max(theoreticalMaxDurability - effectiveMaxDurability, currentDamage - repairAmount);
                    stack.m_41721_(newDamage);
                    tag.m_128405_("ReducedMaxDurability", reducedCount + 1);
                    event.getLevel().m_5594_(null, pos, SoundEvents.f_11998_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    ModItemInteractEvents.spawnGrindParticles(world, pos);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }
        if (!world.m_5776_()) {
            ItemStack mainHand = player.m_21205_();
            HitResult hit2 = player.m_19907_(5.0, 0.0f, false);
            BlockPos pos2 = ((BlockHitResult)hit2).m_82425_();
            BlockState state2 = world.m_8055_(pos2);
            if (!mainHand.m_204117_(ModTags.Items.SMITHING_HAMMERS) || !state2.m_204336_(ModTags.Blocks.SMITHING_ANVIL)) {
                ModItemInteractEvents.hideMinigame((ServerPlayer)player);
            }
        }
    }

    private static void spawnGrindParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 10, 0.2, 0.2, 0.2, 0.1);
        }
    }

    private static void handleCauldronInteraction(Level level, BlockPos pos, Player player, ItemStack heldStack, BlockState state) {
        IntegerProperty levelProperty = LayeredCauldronBlock.f_153514_;
        int waterLevel = (Integer)state.m_61143_((Property)levelProperty);
        if (waterLevel > 0) {
            ModItemInteractEvents.coolIngot(player, heldStack);
        }
    }

    private static void coolIngot(Player player, ItemStack stack) {
        Item cooled = OvergearedMod.getCooledIngot(stack.m_41720_(), player.m_9236_());
        if (cooled == null) {
            return;
        }
        if (stack.m_41613_() <= 0) {
            return;
        }
        ItemStack cooledStack = new ItemStack((ItemLike)cooled, 1);
        if (stack.m_41782_()) {
            cooledStack.m_41751_(stack.m_41783_().m_6426_());
            cooledStack.m_41749_("HeatedSince");
            cooledStack.m_41749_("Heated");
        }
        stack.m_41774_(1);
        if (stack.m_41619_()) {
            if (player.m_21205_() == stack) {
                player.m_21008_(InteractionHand.MAIN_HAND, cooledStack);
            } else if (player.m_21206_() == stack) {
                player.m_21008_(InteractionHand.OFF_HAND, cooledStack);
            } else if (!player.m_150109_().m_36054_(cooledStack)) {
                player.m_36176_(cooledStack, false);
            }
        } else if (!player.m_150109_().m_36054_(cooledStack)) {
            player.m_36176_(cooledStack, false);
        }
        player.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
    }

    private static boolean coolIngotEntity(ItemEntity entity) {
        ItemStack stack = entity.m_32055_();
        Level level = entity.m_9236_();
        int count = stack.m_41613_();
        Item cooled = OvergearedMod.getCooledIngot(stack.m_41720_(), level);
        if (cooled == null || stack.m_41613_() <= 0) {
            return false;
        }
        CompoundTag oldTag = stack.m_41782_() ? stack.m_41783_().m_6426_() : null;
        ItemStack cooledStack = new ItemStack((ItemLike)cooled, stack.m_41613_());
        if (oldTag != null) {
            CompoundTag newTag = oldTag.m_6426_();
            newTag.m_128473_("Heated");
            newTag.m_128473_("HeatedSince");
            if (newTag.m_128456_()) {
                cooledStack.m_41751_(null);
            } else {
                cooledStack.m_41751_(newTag);
            }
        }
        entity.m_32045_(cooledStack);
        entity.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
        return true;
    }

    private static void grindItem(Player player, ItemStack heldStack) {
        Item cooledItem = ModItemInteractEvents.getGrindable(heldStack.m_41720_(), player.m_9236_());
        if (cooledItem != null) {
            ItemStack cooledIngot = new ItemStack((ItemLike)cooledItem);
            if (heldStack.m_41782_()) {
                cooledIngot.m_41751_(heldStack.m_41783_().m_6426_());
            }
            cooledIngot.m_41784_().m_128379_("Polished", true);
            heldStack.m_41774_(1);
            if (heldStack.m_41619_()) {
                player.m_21008_(player.m_7655_(), cooledIngot);
            } else if (!player.m_150109_().m_36054_(cooledIngot)) {
                player.m_36176_(cooledIngot, false);
            }
            if (player != null) {
                player.m_5496_(SoundEvents.f_11998_, 1.0f, 1.0f);
            }
        }
    }

    private static Item getGrindable(@Nullable Item heatedItem, @NotNull Level level) {
        if (heatedItem == null || level == null) {
            return null;
        }
        SimpleContainer container = new SimpleContainer(new ItemStack[]{new ItemStack((ItemLike)heatedItem)});
        Optional<GrindingRecipe> recipeOpt = level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.GRINDING_RECIPE.get()).stream().filter(r -> r.matches(container, level)).findFirst();
        if (recipeOpt.isEmpty()) {
            return heatedItem;
        }
        GrindingRecipe recipe = recipeOpt.get();
        ItemStack result = recipe.m_8043_(level.m_9598_());
        return result.m_41619_() ? heatedItem : result.m_41720_();
    }

    public static boolean hasCoolingRecipe(@Nullable Item heatedItem, @NotNull Level level) {
        if (heatedItem == null) {
            return false;
        }
        SimpleContainer container = new SimpleContainer(new ItemStack[]{new ItemStack((ItemLike)heatedItem)});
        Optional<CoolingRecipe> recipeOpt = level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.COOLING_RECIPE.get()).stream().filter(r -> r.matches(container, level)).findFirst();
        return recipeOpt.map(recipe -> !recipe.m_8043_(level.m_9598_()).m_41619_()).orElse(false);
    }

    public static boolean hasGrindingRecipe(@Nullable Item heatedItem, @NotNull Level level) {
        if (heatedItem == null) {
            return false;
        }
        SimpleContainer container = new SimpleContainer(new ItemStack[]{new ItemStack((ItemLike)heatedItem)});
        Optional<GrindingRecipe> recipeOpt = level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.GRINDING_RECIPE.get()).stream().filter(r -> r.matches(container, level)).findFirst();
        return recipeOpt.map(recipe -> !recipe.m_8043_(level.m_9598_()).m_41619_()).orElse(false);
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        ItemStack stack = itemEntity.m_32055_();
        boolean isHeatedItem = stack.m_41782_() && stack.m_41783_().m_128471_("Heated");
        Item cooled = OvergearedMod.getCooledIngot(stack.m_41720_(), event.getLevel());
        if (ModItemInteractEvents.hasCoolingRecipe(stack.m_41720_(), event.getLevel()) || isHeatedItem) {
            Level level = event.getLevel();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            trackedEntitiesPerWorld.computeIfAbsent(serverLevel, w -> new ArrayList()).add(itemEntity);
            if (stack.m_41782_() && stack.m_41783_().m_128441_("HeatedSince")) {
                long heatedSince = stack.m_41783_().m_128454_("HeatedSince");
                trackedSinceMs.put(itemEntity, heatedSince);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityPickupItem(EntityItemPickupEvent event) {
        Level level = event.getItem().f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        List<ItemEntity> tracked = trackedEntitiesPerWorld.get(serverLevel);
        if (tracked != null) {
            tracked.remove(event.getItem());
            if (tracked.isEmpty()) {
                trackedEntitiesPerWorld.remove(serverLevel);
            }
        }
        trackedSinceMs.remove(event.getItem());
    }

    private static boolean hasCoolingRecipeCached(Item item, Level level) {
        return COOLING_CACHE.computeIfAbsent(item, i -> ModItemInteractEvents.hasCoolingRecipe(i, level));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        for (ServerLevel level : server.m_129785_()) {
            List<ItemEntity> tracked;
            long now = level.m_46467_();
            if (now % 10L != 0L || (tracked = trackedEntitiesPerWorld.get(level)) == null || tracked.isEmpty()) continue;
            Iterator<ItemEntity> it = tracked.iterator();
            while (it.hasNext()) {
                BlockPos.MutableBlockPos pos;
                BlockState state;
                boolean isHeated;
                ItemEntity entity = it.next();
                if (!entity.m_6084_()) {
                    it.remove();
                    trackedSinceMs.remove(entity);
                    continue;
                }
                ItemStack stack = entity.m_32055_();
                boolean bl = isHeated = stack.m_41782_() && stack.m_41783_().m_128471_("Heated") || ModItemInteractEvents.hasCoolingRecipeCached(stack.m_41720_(), (Level)level);
                if (!isHeated) {
                    it.remove();
                    trackedSinceMs.remove(entity);
                    continue;
                }
                Long started = (Long)trackedSinceMs.get(entity);
                boolean cooled = false;
                if (started != null && now - started > (long)((Integer)ServerConfig.HEATED_ITEM_COOLDOWN_TICKS.get()).intValue()) {
                    cooled = true;
                }
                if ((state = level.m_8055_((BlockPos)(pos = new BlockPos.MutableBlockPos(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())))).m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_152476_)) {
                    cooled = true;
                }
                if (!cooled) continue;
                ModItemInteractEvents.coolIngotEntity(entity);
                trackedSinceMs.remove(entity);
                if (!entity.m_32055_().m_41619_()) continue;
                it.remove();
            }
            if (!tracked.isEmpty()) continue;
            trackedEntitiesPerWorld.remove(level);
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ItemEntity) {
            event.addCapability(ResourceLocation.m_214293_((String)"overgeared", (String)"heated_item"), (ICapabilityProvider)new HeatedItemProvider());
        }
    }

    @SubscribeEvent
    public static void onFlintUsedOnStone(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        ItemStack heldItem = event.getItemStack();
        Player player = event.getEntity();
        if (state.m_60713_(Blocks.f_50069_) && heldItem.m_150930_(Items.f_42484_) && ((Boolean)ServerConfig.GET_ROCK_USING_FLINT.get()).booleanValue()) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean shouldConsumeFlint = false;
            if ((double)RANDOM.nextFloat() < (Double)ServerConfig.ROCK_DROPPING_CHANCE.get()) {
                double dz;
                double dy;
                ItemStack dropStack = new ItemStack((ItemLike)ModItems.ROCK.get());
                double sx = (double)pos.m_123341_() + 0.5;
                double sy = (double)pos.m_123342_() + 0.9;
                double sz = (double)pos.m_123343_() + 0.5;
                double dx = player.m_20185_() - sx;
                double len = Math.sqrt(dx * dx + (dy = player.m_20186_() + (double)player.m_20192_() - sy) * dy + (dz = player.m_20189_() - sz) * dz);
                if (len != 0.0) {
                    dx /= len;
                    dy /= len;
                    dz /= len;
                }
                double speed = 0.25;
                ItemEntity item = new ItemEntity((Level)serverLevel, sx, sy, sz, dropStack);
                item.m_20334_(dx * speed, dy * speed, dz * speed);
                item.m_32060_();
                serverLevel.m_7967_((Entity)item);
                level.m_46597_(pos, Blocks.f_50652_.m_49966_());
            }
            boolean bl = shouldConsumeFlint = (double)RANDOM.nextFloat() < (Double)ServerConfig.FLINT_BREAKING_CHANCE.get();
            if (shouldConsumeFlint) {
                heldItem.m_41774_(1);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 0.8f, 0.8f + RANDOM.nextFloat() * 0.4f);
                player.m_6674_(event.getHand());
            } else {
                level.m_5594_(null, pos, SoundEvents.f_12446_, SoundSource.BLOCKS, 1.0f, 0.8f + RANDOM.nextFloat() * 0.4f);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_()) {
            ModItemInteractEvents.hideMinigame((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_()) {
            ModItemInteractEvents.hideMinigame((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onArrowTipping(PlayerInteractEvent.RightClickItem event) {
        ItemStack resultArrow;
        boolean isCustomArrow;
        Player player = event.getEntity();
        Level level = event.getLevel();
        InteractionHand hand = event.getHand();
        if (level.m_5776_()) {
            return;
        }
        ItemStack usedHand = player.m_21120_(hand);
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack otherStack = player.m_21120_(otherHand);
        boolean isVanillaArrow = usedHand.m_150930_(Items.f_42412_) && otherStack.m_150930_(Items.f_42589_);
        boolean bl = isCustomArrow = (Boolean)ServerConfig.UPGRADE_ARROW_POTION_TOGGLE.get() != false && (usedHand.m_150930_((Item)ModItems.IRON_UPGRADE_ARROW.get()) || usedHand.m_150930_((Item)ModItems.STEEL_UPGRADE_ARROW.get()) || usedHand.m_150930_((Item)ModItems.DIAMOND_UPGRADE_ARROW.get())) && otherStack.m_150930_(Items.f_42589_);
        if (!isVanillaArrow && !isCustomArrow) {
            return;
        }
        CompoundTag potionTag = otherStack.m_41784_();
        int used = potionTag.m_128451_("TippedUsed");
        int maxUse = (Integer)ServerConfig.MAX_POTION_TIPPING_USE.get();
        Potion basePotion = PotionUtils.m_43579_((ItemStack)otherStack);
        if (isVanillaArrow) {
            resultArrow = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)basePotion);
        } else {
            resultArrow = usedHand.m_41777_();
            resultArrow.m_41764_(1);
            CompoundTag arrowTag = resultArrow.m_41784_();
            arrowTag.m_128359_("Potion", basePotion.m_43492_(""));
            if (potionTag.m_128425_("CustomPotionEffects", 9)) {
                arrowTag.m_128365_("CustomPotionEffects", (Tag)potionTag.m_128437_("CustomPotionEffects", 10));
            }
            if (potionTag.m_128425_("CustomPotionColor", 3)) {
                arrowTag.m_128405_("CustomPotionColor", potionTag.m_128451_("CustomPotionColor"));
            }
        }
        if (usedHand.m_41613_() == 1) {
            player.m_21008_(hand, resultArrow);
        } else {
            usedHand.m_41774_(1);
            player.m_21008_(hand, usedHand);
            if (!player.m_150109_().m_36054_(resultArrow)) {
                player.m_36176_(resultArrow, false);
            }
        }
        if (otherStack.m_41613_() > 1) {
            ItemStack onePotion = otherStack.m_41620_(1);
            CompoundTag oneTag = onePotion.m_41784_();
            oneTag.m_128405_("TippedUsed", used + 1);
            PotionUtils.m_43549_((ItemStack)onePotion, (Potion)basePotion);
            player.m_21008_(otherHand, otherStack);
        } else if (++used >= maxUse) {
            player.m_21008_(otherHand, new ItemStack((ItemLike)Items.f_42590_));
        } else {
            potionTag.m_128405_("TippedUsed", used);
            PotionUtils.m_43549_((ItemStack)otherStack, (Potion)basePotion);
            player.m_21008_(otherHand, otherStack);
        }
        level.m_5594_(null, player.m_20183_(), SoundEvents.f_11772_, SoundSource.PLAYERS, 0.6f, 1.2f);
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    @SubscribeEvent
    public static void onRightClickFletching(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        if (!((Boolean)ServerConfig.ENABLE_FLETCHING_RECIPES.get()).booleanValue()) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        if (!state.m_60713_(Blocks.f_50622_)) {
            return;
        }
        if (level.f_46443_) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        SimpleMenuProvider provider = new SimpleMenuProvider((windowId, playerInv, p) -> new FletchingStationMenu(windowId, playerInv, ContainerLevelAccess.m_39289_((Level)level, (BlockPos)pos)), (Component)Component.m_237115_((String)"container.overgeared.fletching_table"));
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)pos);
        event.setCancellationResult(InteractionResult.m_19078_((boolean)false));
        event.setCanceled(true);
    }
}

