/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.datapack.BlueprintTooltypesReloadListener;
import net.stirdrem.overgeared.item.ToolType;

public class ToolTypeRegistry {
    private static final List<ToolType> HIDDEN_TYPES = new ArrayList<ToolType>();
    private static final Map<String, ToolType> BY_ID = new HashMap<String, ToolType>();

    public static void init() {
        List hiddenIds;
        BY_ID.clear();
        HIDDEN_TYPES.clear();
        BlueprintTooltypesReloadListener.DATA.values().forEach(data -> {
            for (String id : data.getToolTypes()) {
                BY_ID.computeIfAbsent(id, ToolType::new);
            }
        });
        List availableIds = (List)ServerConfig.AVAILABLE_TOOL_TYPES.get();
        if (availableIds != null) {
            for (String id : availableIds) {
                ToolTypeRegistry.byId(id).ifPresent(type -> {});
            }
        }
        if ((hiddenIds = (List)ServerConfig.HIDDEN_TOOL_TYPES.get()) != null) {
            for (String id : hiddenIds) {
                BY_ID.computeIfPresent(id.toLowerCase(Locale.ROOT), (k, t) -> {
                    HIDDEN_TYPES.add((ToolType)t);
                    return t;
                });
            }
        }
        System.out.println("Registered tool types: " + BY_ID.keySet().stream().collect(Collectors.joining(", ")));
    }

    public static List<ToolType> getRegisteredTypes() {
        ArrayList<ToolType> result = new ArrayList<ToolType>();
        List allowed = (List)ServerConfig.AVAILABLE_TOOL_TYPES.get();
        if (allowed == null || allowed.isEmpty()) {
            for (ToolType type : BY_ID.values()) {
                if (HIDDEN_TYPES.contains(type)) continue;
                result.add(type);
            }
            return result;
        }
        for (ToolType type : BY_ID.values()) {
            boolean isHidden = HIDDEN_TYPES.contains(type);
            if (isHidden) continue;
            result.add(type);
        }
        return result;
    }

    public static List<ToolType> getRegisteredTypesAll() {
        List<ToolType> list = ToolTypeRegistry.getRegisteredTypes();
        list.addAll(HIDDEN_TYPES);
        return list;
    }

    public static Optional<ToolType> byId(String id) {
        if (id == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(BY_ID.get(id.toLowerCase(Locale.ROOT)));
    }
}

