/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared;

public enum ForgingQuality {
    POOR("poor"),
    WELL("well"),
    EXPERT("expert"),
    PERFECT("perfect"),
    MASTER("master"),
    NONE("none");

    private final String displayName;

    private ForgingQuality(String displayName) {
        this.displayName = displayName;
    }

    public static ForgingQuality fromString(String quality) {
        for (ForgingQuality q : ForgingQuality.values()) {
            if (!q.displayName.equalsIgnoreCase(quality)) continue;
            return q;
        }
        return POOR;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ForgingQuality getLowerQuality() {
        if (this == NONE) {
            return NONE;
        }
        ForgingQuality[] values = ForgingQuality.values();
        int index = this.ordinal();
        return index > 0 ? values[index - 1] : this;
    }
}

