/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.stirdrem.overgeared.AnvilTier;
import net.stirdrem.overgeared.block.custom.AbstractSmithingAnvilNew;
import net.stirdrem.overgeared.block.entity.ModBlockEntities;
import net.stirdrem.overgeared.block.entity.StoneSmithingAnvilBlockEntity;
import org.jetbrains.annotations.Nullable;

public class StoneSmithingAnvil
extends AbstractSmithingAnvilNew {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape Z1 = Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape Z2 = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)16.0);
    private static final VoxelShape X1 = StoneSmithingAnvil.rotateShape(Direction.NORTH, Direction.EAST, Z1);
    private static final VoxelShape X2 = StoneSmithingAnvil.rotateShape(Direction.NORTH, Direction.EAST, Z2);
    private static final VoxelShape SHAPE_Z = Shapes.m_83110_((VoxelShape)Z1, (VoxelShape)Z2);
    private static final VoxelShape SHAPE_X = Shapes.m_83110_((VoxelShape)X1, (VoxelShape)X2);
    private static final int HAMMER_SOUND_DURATION_TICKS = 6;

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_166049_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public StoneSmithingAnvil(BlockBehaviour.Properties properties) {
        super(AnvilTier.STONE, properties);
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        return direction.m_122434_() == Direction.Axis.X ? SHAPE_X : SHAPE_Z;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122427_());
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new StoneSmithingAnvilBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (!pLevel.f_46443_ && pBlockEntityType == ModBlockEntities.STONE_SMITHING_ANVIL_BE.get()) {
            return StoneSmithingAnvil.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.STONE_SMITHING_ANVIL_BE.get()), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel, pPos, pState1));
        }
        return null;
    }

    @Override
    public void m_48792_(Level level, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity fallingBlock) {
        if (!level.f_46443_) {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)fallingState));
            level.m_46597_(pos, Blocks.f_50652_.m_49966_());
            level.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_142525_(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        if (!level.f_46443_) {
            BlockState state = fallingBlock.m_31980_();
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42594_));
            level.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

