/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.compat;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.recipe.CastBlastingRecipe;

public class CastBlastingRecipeCategory
implements IRecipeCategory<CastBlastingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.m_214293_((String)"minecraft", (String)"blasting");
    public static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/furnace_jei.png");
    public static final RecipeType<CastBlastingRecipe> CAST_BLASTING_TYPE = new RecipeType(UID, CastBlastingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final int animationTime = 100;
    private final IDrawableAnimated arrowAnimated;
    private final IDrawableStatic arrowStatic;
    private final IDrawableAnimated flameAnimated;
    private final IDrawableStatic flameStatic;

    public CastBlastingRecipeCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 38, 82, 38).setTextureSize(106, 38).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.CLAY_TOOL_CAST.get()));
        this.arrowStatic = helper.drawableBuilder(TEXTURE, 83, 14, 22, 16).setTextureSize(106, 38).build();
        this.arrowAnimated = helper.createAnimatedDrawable(this.arrowStatic, 100, IDrawableAnimated.StartDirection.LEFT, false);
        this.flameStatic = helper.drawableBuilder(TEXTURE, 82, 0, 14, 13).setTextureSize(106, 38).build();
        this.flameAnimated = helper.createAnimatedDrawable(this.flameStatic, 50, IDrawableAnimated.StartDirection.TOP, true);
    }

    public RecipeType<CastBlastingRecipe> getRecipeType() {
        return CAST_BLASTING_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.overgeared.jei.category.cast_blasting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(CastBlastingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Float exp = Float.valueOf(recipe.m_43750_());
        this.arrowAnimated.draw(guiGraphics, 25, 5);
        this.flameAnimated.draw(guiGraphics, 1, 24);
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, exp + " XP", 26, 28, -1, true);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CastBlastingRecipe recipe, IFocusGroup focuses) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("ToolType", recipe.getToolType());
        CompoundTag mats = new CompoundTag();
        AtomicInteger total = new AtomicInteger();
        recipe.getMaterialInputs().forEach((material, amount) -> {
            mats.m_128405_(material, amount.intValue());
            total.addAndGet(amount.intValue());
        });
        tag.m_128365_("Materials", (Tag)mats);
        tag.m_128405_("Amount", total.get());
        tag.m_128405_("MaxAmount", total.get());
        ItemStack firedCast = new ItemStack((ItemLike)ModItems.CLAY_TOOL_CAST.get());
        firedCast.m_41751_(tag.m_6426_());
        ItemStack netherCast = new ItemStack((ItemLike)ModItems.NETHER_TOOL_CAST.get());
        netherCast.m_41751_(tag.m_6426_());
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 5).addItemStacks(List.of(firedCast, netherCast));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 5).addItemStack(recipe.m_8043_(null));
    }
}

