/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.item.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.BlueprintQuality;
import net.stirdrem.overgeared.util.CastingConfigHelper;

public class ToolCastItem
extends Item {
    private final Supplier<Integer> durabilitySupplier;
    private final boolean allowMaterialInsert;

    public ToolCastItem(Supplier<Integer> durabilitySupplier, boolean allowMaterialInsert, Item.Properties props) {
        super(props);
        this.durabilitySupplier = durabilitySupplier;
        this.allowMaterialInsert = allowMaterialInsert;
    }

    public ToolCastItem(boolean allowMaterialInsert, Item.Properties props) {
        super(props);
        this.durabilitySupplier = null;
        this.allowMaterialInsert = allowMaterialInsert;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player.m_6047_()) {
            return this.calculateAndReturnMaterials(stack, player);
        }
        return super.m_7203_(level, player, hand);
    }

    private InteractionResultHolder<ItemStack> calculateAndReturnMaterials(ItemStack castStack, Player player) {
        CompoundTag tag = castStack.m_41783_();
        if (tag == null) {
            player.m_5661_((Component)Component.m_237115_((String)"message.overgeared.cast_empty"), true);
            return InteractionResultHolder.m_19100_((Object)castStack);
        }
        List<ItemStack> inputItems = this.getInputItemsFromCast(castStack);
        if (inputItems.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.overgeared.cast_empty"), true);
            return InteractionResultHolder.m_19100_((Object)castStack);
        }
        boolean returnedAny = false;
        for (ItemStack inputItem : inputItems) {
            if (inputItem.m_41619_()) continue;
            if (!player.m_150109_().m_36054_(inputItem.m_41777_())) {
                player.m_36176_(inputItem.m_41777_(), false);
            }
            returnedAny = true;
        }
        if (returnedAny) {
            tag.m_128365_("Materials", (Tag)new CompoundTag());
            tag.m_128405_("Amount", 0);
            tag.m_128473_("input");
            player.m_5661_((Component)Component.m_237115_((String)"message.overgeared.materials_returned"), true);
            return InteractionResultHolder.m_19092_((Object)castStack, (boolean)player.m_9236_().m_5776_());
        }
        player.m_5661_((Component)Component.m_237115_((String)"message.overgeared.no_materials"), true);
        return InteractionResultHolder.m_19100_((Object)castStack);
    }

    public boolean m_142207_(ItemStack castStack, Slot slot, ClickAction action, Player player) {
        if (!this.allowMaterialInsert) {
            return false;
        }
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (!slot.m_150651_(player)) {
            return false;
        }
        ItemStack slotStack = slot.m_7993_();
        if (slotStack.m_41619_()) {
            return false;
        }
        if (this.insertMaterial(castStack, slotStack, player)) {
            slot.m_6201_(1);
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack castStack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        if (!this.allowMaterialInsert) {
            return false;
        }
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (this.insertMaterial(castStack, otherStack, player)) {
            otherStack.m_41774_(1);
            return true;
        }
        return false;
    }

    private boolean insertMaterial(ItemStack cast, ItemStack material, Player player) {
        int maxAmount;
        if (material.m_41619_()) {
            return false;
        }
        CompoundTag tag = cast.m_41784_();
        ListTag list = tag.m_128437_("input", 10);
        String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)material.m_41720_()).toString();
        if (!CastingConfigHelper.isValidMaterial(material)) {
            player.m_5661_((Component)Component.m_237115_((String)"message.overgeared.invalid_material"), true);
            return false;
        }
        int value = CastingConfigHelper.getMaterialValue(material);
        if (value <= 0) {
            return false;
        }
        int amount = tag.m_128451_("Amount");
        int n = maxAmount = tag.m_128441_("MaxAmount") ? tag.m_128451_("MaxAmount") : Integer.MAX_VALUE;
        if (amount + value > maxAmount) {
            return false;
        }
        String mat = CastingConfigHelper.getMaterialForItem(material);
        CompoundTag mats = tag.m_128441_("Materials") ? tag.m_128469_("Materials") : new CompoundTag();
        int prev = mats.m_128451_(mat);
        mats.m_128405_(mat, prev + value);
        tag.m_128365_("Materials", (Tag)mats);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            ItemStack entryStack = ItemStack.m_41712_((CompoundTag)entry);
            if (!ItemStack.m_150942_((ItemStack)entryStack, (ItemStack)material)) continue;
            entryStack.m_41769_(1);
            entryStack.m_41739_(entry);
            list.set(i, (Tag)entry);
            tag.m_128365_("input", (Tag)list);
            tag.m_128405_("Amount", amount + value);
            this.playInsertSound(player);
            return true;
        }
        ItemStack stored = material.m_41777_();
        stored.m_41764_(1);
        list.add((Object)stored.m_41739_(new CompoundTag()));
        tag.m_128365_("input", (Tag)list);
        tag.m_128405_("Amount", amount + value);
        this.playInsertSound(player);
        return true;
    }

    private void playInsertSound(Player player) {
        player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_184215_, SoundSource.PLAYERS, 0.7f, 1.1f);
    }

    private List<ItemStack> getInputItemsFromCast(ItemStack cast) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        CompoundTag tag = cast.m_41783_();
        if (tag != null && tag.m_128425_("input", 9)) {
            ListTag inputList = tag.m_128437_("input", 10);
            for (Tag inputTag : inputList) {
                ItemStack item;
                if (!(inputTag instanceof CompoundTag) || (item = ItemStack.m_41712_((CompoundTag)((CompoundTag)inputTag))).m_41619_()) continue;
                items.add(item);
            }
        }
        return items;
    }

    public boolean isDamageable(ItemStack stack) {
        return this.durabilitySupplier != null;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.durabilitySupplier != null ? this.durabilitySupplier.get() : 0;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag materials;
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128425_("Quality", 8)) {
            String quality = tag.m_128461_("Quality");
            ChatFormatting color = BlueprintQuality.getColor(quality);
            if (!quality.equals("NONE")) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.overgeared.tool_cast.quality").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("quality.overgeared." + quality.toLowerCase())).m_130940_(color)).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (tag.m_128425_("ToolType", 8)) {
            String toolType = tag.m_128461_("ToolType");
            tooltip.add((Component)Component.m_237115_((String)"tooltip.overgeared.tool_cast.type").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("tooltype.overgeared." + toolType.toLowerCase())).m_130940_(ChatFormatting.BLUE)).m_130940_(ChatFormatting.GRAY));
        }
        if (tag.m_128425_("Materials", 10) && !(materials = tag.m_128469_("Materials")).m_128456_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.overgeared.tool_cast.materials").m_130940_(ChatFormatting.GRAY));
            for (String key : materials.m_128431_()) {
                int amount = materials.m_128451_(key);
                MutableComponent display = Component.m_237115_((String)("material.overgeared." + key.toLowerCase()));
                if (display.getString().equals("material.overgeared." + key.toLowerCase())) {
                    display = Component.m_237113_((String)key);
                }
                tooltip.add((Component)Component.m_237113_((String)"  \u2022 ").m_7220_((Component)display).m_7220_((Component)Component.m_237113_((String)(": " + amount))).m_130940_(ChatFormatting.WHITE));
            }
        }
        if (tag.m_128441_("Amount")) {
            int raw = tag.m_128451_("Amount");
            double amt = (double)raw / 9.0;
            int maxRaw = tag.m_128441_("MaxAmount") ? tag.m_128451_("MaxAmount") : raw;
            double maxAmt = (double)maxRaw / 9.0;
            tooltip.add((Component)Component.m_237115_((String)"tooltip.overgeared.tool_cast.amount").m_130946_(" ").m_7220_((Component)Component.m_237113_((String)String.format("%.2f", amt)).m_130940_(ChatFormatting.YELLOW)).m_130946_(" / ").m_7220_((Component)Component.m_237113_((String)String.format("%.2f", maxAmt)).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.GRAY));
            if (amt / maxAmt != 1.0) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.overgeared.add_materials").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            }
        }
        if (tag.m_128425_("Materials", 10) && !tag.m_128469_("Materials").m_128456_() || tag.m_128425_("input", 9) && !tag.m_128437_("input", 10).isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.overgeared.cast_right_click").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }

    private static class ItemCount {
        final ItemStack itemStack;
        final String displayName;
        int count;

        ItemCount(ItemStack itemStack, String displayName, int count) {
            this.itemStack = itemStack;
            this.displayName = displayName;
            this.count = count;
        }
    }
}

