/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.item.custom;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.entity.ArrowTier;
import net.stirdrem.overgeared.entity.custom.UpgradeArrowEntity;

public class UpgradeArrowItem
extends ArrowItem {
    private final ArrowTier tier;

    public UpgradeArrowItem(Item.Properties properties, ArrowTier tier) {
        super(properties);
        this.tier = tier;
    }

    public AbstractArrow m_6394_(Level level, ItemStack stack, LivingEntity shooter) {
        UpgradeArrowEntity arrow = new UpgradeArrowEntity(this.tier, level, shooter, stack);
        return arrow;
    }

    public ArrowTier getTier() {
        return this.tier;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        CompoundTag tag = pStack.m_41783_();
        if (tag != null && (tag.m_128441_("Potion") || tag.m_128441_("CustomPotionEffects"))) {
            PotionUtils.m_43555_((ItemStack)pStack, pTooltip, (float)0.125f);
        }
        if (tag != null && tag.m_128425_("LingeringPotion", 8)) {
            PotionUtils.m_257410_(UpgradeArrowItem.getMobEffects(pStack), pTooltip, (float)0.125f);
        }
    }

    public static void addPotionTooltip(ItemStack pStack, List<Component> pTooltips, float pDurationFactor) {
        PotionUtils.m_257410_(UpgradeArrowItem.getMobEffects(pStack), pTooltips, (float)pDurationFactor);
    }

    public String m_5671_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            String tierName;
            List<MobEffectInstance> effects = UpgradeArrowItem.getMobEffects(stack);
            switch (this.tier) {
                case IRON: {
                    String string = "item.overgeared.iron_arrow";
                    break;
                }
                case STEEL: {
                    String string = "item.overgeared.steel_arrow";
                    break;
                }
                case DIAMOND: {
                    String string = "item.overgeared.diamond_arrow";
                    break;
                }
                default: {
                    String string = tierName = "item.overgeared.arrow";
                }
            }
            if (tag.m_128425_("LingeringPotion", 1) && tag.m_128471_("LingeringPotion")) {
                return tierName + ".lingering_named";
            }
            if (tag.m_128425_("LingeringPotion", 8)) {
                return tierName + ".lingering_named";
            }
            if (tag.m_128425_("Potion", 8) || tag.m_128425_("CustomPotionEffects", 9)) {
                return tierName + ".tipped_named";
            }
        }
        return super.m_5671_(stack);
    }

    public static List<MobEffectInstance> getMobEffects(ItemStack pStack) {
        return UpgradeArrowItem.getAllEffects(pStack.m_41783_());
    }

    public static Potion getPotion(@Nullable CompoundTag tag) {
        if (tag == null) {
            return Potions.f_43598_;
        }
        if (tag.m_128425_("LingeringPotion", 8)) {
            return Potion.m_43489_((String)tag.m_128461_("LingeringPotion"));
        }
        if (tag.m_128441_("LingeringPotion") && tag.m_128471_("LingeringPotion")) {
            return Potion.m_43489_((String)tag.m_128461_("Potion"));
        }
        if (tag.m_128425_("Potion", 8)) {
            return Potion.m_43489_((String)tag.m_128461_("Potion"));
        }
        return Potions.f_43598_;
    }

    public static List<MobEffectInstance> getAllEffects(@Nullable CompoundTag pCompoundTag) {
        ArrayList list = Lists.newArrayList();
        list.addAll(UpgradeArrowItem.getPotion(pCompoundTag).m_43488_());
        PotionUtils.m_43568_((CompoundTag)pCompoundTag, (List)list);
        return list;
    }

    public static void getCustomEffects(@Nullable CompoundTag pCompoundTag, List<MobEffectInstance> pEffectList) {
        if (pCompoundTag != null && pCompoundTag.m_128425_("CustomPotionEffects", 9)) {
            ListTag listtag = pCompoundTag.m_128437_("CustomPotionEffects", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                MobEffectInstance mobeffectinstance = MobEffectInstance.m_19560_((CompoundTag)compoundtag);
                if (mobeffectinstance == null) continue;
                pEffectList.add(mobeffectinstance);
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            Potion potion = UpgradeArrowItem.getPotion(tag);
            if (potion != Potions.f_43598_) {
                boolean isNoEffectPotion;
                String potionId = potion.m_43492_("").replace("effect.minecraft.", "");
                boolean bl = isNoEffectPotion = potionId.equals("mundane") || potionId.equals("awkward") || potionId.equals("thick");
                if (!isNoEffectPotion) {
                    String effectKey = "item.overgeared.arrow.effect." + potionId;
                    MutableComponent effectComponent = Component.m_237115_((String)effectKey);
                    return Component.m_237110_((String)this.m_5671_(stack), (Object[])new Object[]{effectComponent});
                }
            }
            return Component.m_237115_((String)(this.m_5671_(stack) + ".no_effect"));
        }
        return Component.m_237115_((String)this.m_5671_(stack));
    }
}

