package top.qwerty770.clientexport;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_6489;
import net.minecraft.class_6595;
import net.minecraft.class_7923;
import top.qwerty770.clientexport.mixin.StatsCounterAccessor;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.Objects;

import static top.qwerty770.clientexport.util.FileUtil.*;
import static top.qwerty770.clientexport.util.MappingResolverTool.*;

public class StatisticsCommand {
    public static void exportStatistics(CommandContext<FabricClientCommandSource> context) {
        assert class_310.method_1551().field_1724 != null;
        Object2IntMap<class_3445<?>> stats = ((StatsCounterAccessor) class_310.method_1551().field_1724.method_3143()).getStats();
        try {
            JsonObject jsonObject = toJson(stats);
            FileWriter fileWriter = createFile("statistics");
            writeJson(fileWriter, jsonObject);
            fileWriter.close();
            ClientExportHelper.LOGGER.info("Client Export Helper exported {} lines of statistics", stats.size());
            context.getSource().sendFeedback(class_2561.method_43469("commands.clientexport.statistics.success", stats.size()));
        }
        catch (IOException exception){
            sendFailure(exception, context, "commands.clientexport.statistics.fail");
        }
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    public static JsonObject toJson(Object2IntMap<class_3445<?>> stats) {
        Map<class_3448<?>, JsonObject> map = Maps.newHashMap();
        for (Object2IntMap.Entry<class_3445<?>> statEntry : stats.object2IntEntrySet()) {
            class_3445 stat = statEntry.getKey();
            var registry = stat.method_14949().method_14959();
            map.computeIfAbsent(stat.method_14949(), (statType) -> new JsonObject())
                    .addProperty(Objects.requireNonNull(registry.method_10221(stat.method_14951())).toString(), statEntry.getIntValue());
        }

        JsonObject jsonObject = new JsonObject();
        for(Map.Entry<class_3448<?>, JsonObject> entry2 : map.entrySet()) {
            class_2960 location = class_7923.field_41193.method_10221(entry2.getKey());
            if (location == null) {
                ClientExportHelper.LOGGER.warn("StatType {} is not registered in BuiltInRegistries.STAT_TYPE", entry2.getKey());
                continue;
            }
            jsonObject.add(location.toString(), entry2.getValue());
        }

        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("stats", jsonObject);
        jsonObject2.addProperty("DataVersion", getDataVersion());
        return jsonObject2;
    }

    public static int getDataVersion() {
        /// Returns the data version of Minecraft. Ensures the compatibility between Minecraft 1.21.5 and 1.21.6.
        try {
            // Implement this method via reflection
            class_6489 worldVersion = class_155.method_16673();
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            // WorldVersion.getDataVersion() was renamed to WorldVersion.dataVersion() in 1.21.6
            String name = mapIntermediaryMethodNames("net.minecraft.class_6489", "()Lnet/minecraft/class_6595;", "method_37912", "comp_4026");
            MethodHandle handle = lookup.findVirtual(class_6489.class, name, MethodType.methodType(class_6595.class));
            class_6595 dataVersion = (class_6595) handle.invokeExact(worldVersion);
            // DataVersion.getVersion() was renamed to DataVersion.version() in 1.21.6
            String name2 = mapIntermediaryMethodNames("net.minecraft.class_6595", "()I", "method_38494", "comp_4038");
            MethodHandle handle2 = lookup.findVirtual(class_6595.class, name2, MethodType.methodType(int.class));
            return (int) handle2.invokeExact(dataVersion);
        }
        catch (Throwable e) {
            try {
                // Fallback to SharedConstants.WORLD_VERSION if reflection fails
                String name = mapIntermediaryFieldName("net.minecraft.class_155", "field_29732", "I");
                return class_155.class.getField(name).getInt(null);
            } catch (Exception e2) {
                // This should never happen, but if it does, return a default value
                ClientExportHelper.LOGGER.error("Failed to get data version via reflection", e2);
                return 4438;
            }
        }
    }
}
