/*
 * Decompiled with CFR 0.152.
 */
package top.qwerty770.clientexport;

import com.google.gson.JsonObject;
import com.mojang.brigadier.context.CommandContext;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_163;
import net.minecraft.class_167;
import net.minecraft.class_2561;
import net.minecraft.class_8779;
import top.qwerty770.clientexport.AdvancementTool;
import top.qwerty770.clientexport.ClientExportHelper;
import top.qwerty770.clientexport.util.FileUtil;

@Environment(value=EnvType.CLIENT)
public class AdvancementCommand {
    protected static void exportAdvancements(String namespace, CommandContext<FabricClientCommandSource> context) {
        class_163 tree = AdvancementTool.getAdvancementTree();
        List<class_8779> advancements = AdvancementTool.getAdvancements();
        try {
            JsonObject json = new JsonObject();
            for (class_8779 adv : advancements) {
                if (!adv.comp_1919().method_12836().equals(namespace)) continue;
                json.add(adv.comp_1919().toString(), AdvancementTool.getJson(adv, tree));
            }
            FileWriter fileWriter = FileUtil.createFile(namespace, "advancements");
            FileUtil.writeJson(fileWriter, json);
            fileWriter.close();
            ClientExportHelper.LOGGER.info("Client Export Helper exported {} advancements of namespace {}", (Object)advancements.size(), (Object)namespace);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.clientexport.advancements.success", (Object[])new Object[]{advancements.size()}));
        }
        catch (IOException exception) {
            FileUtil.sendFailure(exception, context, "commands.clientexport.advancements.fail");
        }
    }

    protected static void exportAllAdvancements(CommandContext<FabricClientCommandSource> context) {
        class_163 tree = AdvancementTool.getAdvancementTree();
        List<class_8779> advancements = AdvancementTool.getAdvancements();
        HashMap<String, JsonObject> jsonMap = new HashMap<String, JsonObject>();
        HashMap<String, FileWriter> fileWriterMap = new HashMap<String, FileWriter>();
        try {
            for (class_8779 adv : advancements) {
                String ns = adv.comp_1919().method_12836();
                if (!fileWriterMap.containsKey(ns)) {
                    FileWriter writer = FileUtil.createFile(ns, "advancements");
                    fileWriterMap.put(ns, writer);
                }
                if (!jsonMap.containsKey(ns)) {
                    jsonMap.put(ns, new JsonObject());
                }
                ((JsonObject)jsonMap.get(ns)).add(adv.comp_1919().toString(), AdvancementTool.getJson(adv, tree));
            }
            for (String ns : jsonMap.keySet()) {
                FileUtil.writeJson((FileWriter)fileWriterMap.get(ns), (JsonObject)jsonMap.get(ns));
            }
            for (FileWriter writer : fileWriterMap.values()) {
                writer.close();
            }
            ClientExportHelper.LOGGER.info("Client Export Helper exported {} advancements", (Object)advancements.size());
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.clientexport.advancements.success", (Object[])new Object[]{advancements.size()}));
        }
        catch (IOException exception) {
            FileUtil.sendFailure(exception, context, "commands.clientexport.advancements.fail");
        }
    }

    protected static void exportProgress(String namespace, CommandContext<FabricClientCommandSource> context) {
        Map<class_8779, class_167> progress = AdvancementTool.getProgress();
        try {
            JsonObject json = new JsonObject();
            for (class_8779 adv : progress.keySet()) {
                if (!adv.comp_1919().method_12836().equals(namespace)) continue;
                json.add(adv.comp_1919().toString(), AdvancementTool.getJson(progress.get(adv)));
            }
            FileWriter fileWriter = FileUtil.createFile(namespace, "progress");
            FileUtil.writeJson(fileWriter, json);
            fileWriter.close();
            ClientExportHelper.LOGGER.info("Client Export Helper exported {} lines of advancement progress of namespace {}", (Object)progress.size(), (Object)namespace);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.clientexport.progress.success", (Object[])new Object[]{progress.size()}));
        }
        catch (IOException exception) {
            FileUtil.sendFailure(exception, context, "commands.clientexport.progress.fail");
        }
    }

    protected static void exportAllProgress(CommandContext<FabricClientCommandSource> context) {
        Map<class_8779, class_167> progress = AdvancementTool.getProgress();
        HashMap<String, JsonObject> jsonMap = new HashMap<String, JsonObject>();
        HashMap<String, FileWriter> fileWriterMap = new HashMap<String, FileWriter>();
        try {
            for (class_8779 adv : progress.keySet()) {
                String ns = adv.comp_1919().method_12836();
                if (!fileWriterMap.containsKey(ns)) {
                    FileWriter writer = FileUtil.createFile(ns, "progress");
                    fileWriterMap.put(ns, writer);
                }
                if (!jsonMap.containsKey(ns)) {
                    jsonMap.put(ns, new JsonObject());
                }
                ((JsonObject)jsonMap.get(ns)).add(adv.comp_1919().toString(), AdvancementTool.getJson(progress.get(adv)));
            }
            for (String ns : jsonMap.keySet()) {
                FileUtil.writeJson((FileWriter)fileWriterMap.get(ns), (JsonObject)jsonMap.get(ns));
            }
            for (FileWriter writer : fileWriterMap.values()) {
                writer.close();
            }
            ClientExportHelper.LOGGER.info("Client Export Helper exported {} lines of advancement progress", (Object)progress.size());
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.clientexport.progress.success", (Object[])new Object[]{progress.size()}));
        }
        catch (IOException exception) {
            FileUtil.sendFailure(exception, context, "commands.clientexport.progress.fail");
        }
    }
}

