/*
 * Decompiled with CFR 0.152.
 */
package top.qwerty770.clientexport;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_155;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_6489;
import net.minecraft.class_6595;
import net.minecraft.class_7923;
import top.qwerty770.clientexport.ClientExportHelper;
import top.qwerty770.clientexport.mixin.StatsCounterAccessor;
import top.qwerty770.clientexport.util.FileUtil;
import top.qwerty770.clientexport.util.MappingResolverTool;

@Environment(value=EnvType.CLIENT)
public class StatisticsCommand {
    public static void exportStatistics(CommandContext<FabricClientCommandSource> context) {
        assert (class_310.method_1551().field_1724 != null);
        Object2IntMap<class_3445<?>> stats = ((StatsCounterAccessor)class_310.method_1551().field_1724.method_3143()).getStats();
        try {
            JsonObject jsonObject = StatisticsCommand.toJson(stats);
            FileWriter fileWriter = FileUtil.createFile("statistics");
            FileUtil.writeJson(fileWriter, jsonObject);
            fileWriter.close();
            ClientExportHelper.LOGGER.info("Client Export Helper exported {} lines of statistics", (Object)stats.size());
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.clientexport.statistics.success", (Object[])new Object[]{stats.size()}));
        }
        catch (IOException exception) {
            FileUtil.sendFailure(exception, context, "commands.clientexport.statistics.fail");
        }
    }

    public static JsonObject toJson(Object2IntMap<class_3445<?>> stats) {
        HashMap map = Maps.newHashMap();
        for (Object statEntry : stats.object2IntEntrySet()) {
            class_3445 class_34452 = (class_3445)statEntry.getKey();
            class_2378 registry = class_34452.method_14949().method_14959();
            map.computeIfAbsent(class_34452.method_14949(), statType -> new JsonObject()).addProperty(Objects.requireNonNull(registry.method_10221(class_34452.method_14951())).toString(), (Number)statEntry.getIntValue());
        }
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry entry : map.entrySet()) {
            class_2960 location = class_7923.field_41193.method_10221((Object)((class_3448)entry.getKey()));
            if (location == null) {
                ClientExportHelper.LOGGER.warn("StatType {} is not registered in BuiltInRegistries.STAT_TYPE", entry.getKey());
                continue;
            }
            jsonObject.add(location.toString(), (JsonElement)entry.getValue());
        }
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("stats", (JsonElement)jsonObject);
        jsonObject2.addProperty("DataVersion", (Number)StatisticsCommand.getDataVersion());
        return jsonObject2;
    }

    public static int getDataVersion() {
        try {
            class_6489 worldVersion = class_155.method_16673();
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            String name = MappingResolverTool.mapIntermediaryMethodNames("net.minecraft.class_6489", "()Lnet/minecraft/class_6595;", "method_37912", "comp_4026");
            MethodHandle handle = lookup.findVirtual(class_6489.class, name, MethodType.methodType(class_6595.class));
            class_6595 dataVersion = handle.invokeExact(worldVersion);
            String name2 = MappingResolverTool.mapIntermediaryMethodNames("net.minecraft.class_6595", "()I", "method_38494", "comp_4038");
            MethodHandle handle2 = lookup.findVirtual(class_6595.class, name2, MethodType.methodType(Integer.TYPE));
            return handle2.invokeExact(dataVersion);
        }
        catch (Throwable e) {
            try {
                String name = MappingResolverTool.mapIntermediaryFieldName("net.minecraft.class_155", "field_29732", "I");
                return class_155.class.getField(name).getInt(null);
            }
            catch (Exception e2) {
                ClientExportHelper.LOGGER.error("Failed to get data version via reflection", (Throwable)e2);
                return 4438;
            }
        }
    }
}

