/*
 * Decompiled with CFR 0.152.
 */
package syzez.autofishingdeluxe;

import net.minecraft.class_1536;
import net.minecraft.class_3610;
import syzez.autofishingdeluxe.ClientBobberCheck;

public class AutoFishingDetectionMethod {
    private static Method currentMethod = Method.VELOCITY;

    public static Method getCurrentMethod() {
        return currentMethod;
    }

    public static void toggleMethod() {
        switch (currentMethod.ordinal()) {
            case 0: {
                currentMethod = Method.TITLE_MESSAGE;
                break;
            }
            case 2: {
                currentMethod = Method.SOUND;
                break;
            }
            case 1: {
                currentMethod = Method.VELOCITY;
            }
        }
    }

    public static void setMethod(Method method) {
        currentMethod = method;
    }

    public static boolean shouldReelIn(class_1536 ignoredParam) {
        return switch (currentMethod.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> AutoFishingDetectionMethod.isVelocityTriggeredAndMySplash();
            case 1 -> AutoFishingDetectionMethod.wasMyBobberSplash();
            case 2 -> false;
        };
    }

    private static boolean isVelocityTriggeredAndMySplash() {
        boolean inAnyLiquid;
        if (!ClientBobberCheck.exists()) {
            return false;
        }
        if (!AutoFishingDetectionMethod.wasMyBobberSplashWithin(600L)) {
            return false;
        }
        class_1536 bobber = ClientBobberCheck.get();
        class_3610 fluidState = bobber.method_37908().method_8316(bobber.method_24515());
        boolean bl = inAnyLiquid = bobber.method_5799() || bobber.method_5771() || !fluidState.method_15769();
        if (!inAnyLiquid) {
            return false;
        }
        double vy = bobber.method_18798().field_1351;
        boolean inLava = bobber.method_5771();
        double downwardNowThresh = inLava ? -0.03 : -0.12;
        boolean downwardNow = vy < downwardNowThresh;
        boolean downwardImpulse = BobberKinematics.updateAndCheckDownImpulse(bobber, vy);
        return downwardNow || downwardImpulse;
    }

    private static boolean wasMyBobberSplash() {
        return AutoFishingDetectionMethod.wasMyBobberSplashWithin(600L);
    }

    private static boolean wasMyBobberSplashWithin(long ms) {
        return System.currentTimeMillis() - SoundGate.lastMySplashTime <= ms;
    }

    public static enum Method {
        VELOCITY,
        SOUND,
        TITLE_MESSAGE;

    }

    private static final class BobberKinematics {
        private static int trackedId = Integer.MIN_VALUE;
        private static long lastWorldTime = Long.MIN_VALUE;
        private static double lastVy = 0.0;

        private BobberKinematics() {
        }

        static boolean updateAndCheckDownImpulse(class_1536 b, double currentVy) {
            boolean inLava = b.method_5771();
            double impulseDrop = inLava ? -0.04 : -0.1;
            double minSpeedMag = inLava ? 0.005 : 0.02;
            long nowTick = b.method_37908().method_8510();
            int id = b.method_5628();
            boolean sameBobberSameTick = id == trackedId && nowTick == lastWorldTime;
            boolean impulse = false;
            if (!sameBobberSameTick) {
                if (id == trackedId && lastWorldTime == nowTick - 1L) {
                    double deltaVy = currentVy - lastVy;
                    if (Math.abs(currentVy) > minSpeedMag && deltaVy < impulseDrop) {
                        impulse = true;
                    }
                }
                trackedId = id;
                lastWorldTime = nowTick;
                lastVy = currentVy;
            }
            return impulse;
        }
    }

    public static final class SoundGate {
        static final long SPLASH_TIMEOUT_MS = 1500L;
        static volatile long lastMySplashTime = 0L;

        public static void markMySplash() {
            lastMySplashTime = System.currentTimeMillis();
        }
    }
}

