/*
 * Decompiled with CFR 0.152.
 */
package syzez.autofishingdeluxe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import syzez.autofishingdeluxe.AutoFishingConfig;

public class ConfigManager {
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "autofishingdeluxe.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static AutoFishingConfig loadConfig() {
        if (CONFIG_FILE.exists()) {
            AutoFishingConfig autoFishingConfig;
            FileReader reader = new FileReader(CONFIG_FILE);
            try {
                autoFishingConfig = (AutoFishingConfig)GSON.fromJson((Reader)reader, AutoFishingConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader.close();
            return autoFishingConfig;
        }
        return new AutoFishingConfig();
    }

    public static void saveConfig(AutoFishingConfig config) {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

