/*
 * Decompiled with CFR 0.152.
 */
package syzez.autofishingdeluxe;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;

public final class ExternalSoundPlayer {
    private static volatile Process lastProcess = null;

    private ExternalSoundPlayer() {
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        return os.contains("win");
    }

    private static int freqFor(int id) {
        return switch (id) {
            case 1 -> 880;
            case 2 -> 220;
            case 3 -> 660;
            case 4 -> 1320;
            case 5 -> 990;
            default -> 880;
        };
    }

    private static Path ensureHelperExe() throws IOException, InterruptedException {
        Path baseDir = ExternalSoundPlayer.getBaseDir();
        Files.createDirectories(baseDir, new FileAttribute[0]);
        Path exe = baseDir.resolve("AutoFishingDeluxeSound.exe");
        if (Files.exists(exe, new LinkOption[0])) {
            return exe;
        }
        String cs = "using System;\nusing System.Media;\nclass Program {\n  static int Main(string[] args){\n    if(args.Length<1) return 1;\n    try{ using(var p=new SoundPlayer(args[0])){ p.PlaySync(); } return 0; }\n    catch(Exception){ return 2; }\n  }\n}";
        Path src = baseDir.resolve("AutoFishingDeluxeSound.cs");
        Files.writeString(src, (CharSequence)cs, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        String ps = "Add-Type -OutputAssembly '" + exe.toString().replace("'", "''") + "' -OutputType ConsoleApplication -Language CSharp -TypeDefinition @'\n" + cs.replace("'", "''") + "\n'@";
        Process p = new ProcessBuilder("powershell", "-NoProfile", "-ExecutionPolicy", "Bypass", "-Command", ps).inheritIO().start();
        int code = p.waitFor();
        if (code != 0 || !Files.exists(exe, new LinkOption[0])) {
            throw new IOException("Failed to build helper EXE, exit code=" + code);
        }
        return exe;
    }

    private static Path getBaseDir() {
        String userDir = System.getProperty("user.dir", System.getProperty("java.io.tmpdir"));
        return Path.of(userDir, "run", "config", "autofishingdeluxe", "sounds");
    }

    private static String fileNameFor(int id) {
        return switch (id) {
            case 1 -> "anvil.wav";
            case 2 -> "villager.wav";
            case 3 -> "bell.wav";
            case 4 -> "levelup.wav";
            case 5 -> "xporb.wav";
            default -> "anvil.wav";
        };
    }

    private static Path resolveCustomWav(int soundId) {
        Path base = ExternalSoundPlayer.getBaseDir();
        Path candidate = base.resolve(ExternalSoundPlayer.fileNameFor(soundId));
        if (Files.exists(candidate, new LinkOption[0])) {
            return candidate;
        }
        String lower = ExternalSoundPlayer.fileNameFor(soundId);
        String capitalized = Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
        Path extracted = ExternalSoundPlayer.tryExtractResourceWav("assets/autofishingdeluxe/sounds/" + lower, lower);
        if (extracted != null) {
            return extracted;
        }
        extracted = ExternalSoundPlayer.tryExtractResourceWav("assets/autofishingdeluxe/sounds/" + capitalized, lower);
        if (extracted != null) {
            return extracted;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Path tryExtractResourceWav(String resourcePath, String targetFileName) {
        try (InputStream in = ExternalSoundPlayer.class.getClassLoader().getResourceAsStream(resourcePath);){
            if (in == null) {
                Path path2 = null;
                return path2;
            }
            Path base = ExternalSoundPlayer.getBaseDir();
            Files.createDirectories(base, new FileAttribute[0]);
            Path out = base.resolve(targetFileName);
            try (OutputStream os = Files.newOutputStream(out, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                in.transferTo(os);
            }
            Path path = out;
            return path;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Path scaleWav16PCM(Path in, float volume01) throws IOException {
        volume01 = Math.max(0.0f, Math.min(1.0f, volume01));
        byte[] bytes = Files.readAllBytes(in);
        if (bytes.length < 44) {
            return in;
        }
        if (bytes[0] != 82 || bytes[1] != 73 || bytes[2] != 70 || bytes[3] != 70) {
            return in;
        }
        if (bytes[8] != 87 || bytes[9] != 65 || bytes[10] != 86 || bytes[11] != 69) {
            return in;
        }
        int pos = 12;
        int audioFormat = -1;
        int bitsPerSample = -1;
        int dataOff = -1;
        int dataLen = -1;
        while (pos + 8 <= bytes.length) {
            int id0 = bytes[pos] & 0xFF;
            int id1 = bytes[pos + 1] & 0xFF;
            int id2 = bytes[pos + 2] & 0xFF;
            int id3 = bytes[pos + 3] & 0xFF;
            int chunkStart = pos + 8;
            int size = bytes[pos + 4] & 0xFF | (bytes[pos + 5] & 0xFF) << 8 | (bytes[pos + 6] & 0xFF) << 16 | (bytes[pos + 7] & 0xFF) << 24;
            if (chunkStart + size > bytes.length) break;
            if (id0 == 102 && id1 == 109 && id2 == 116 && id3 == 32) {
                int fmt = bytes[chunkStart] & 0xFF | (bytes[chunkStart + 1] & 0xFF) << 8;
                int bps = bytes[chunkStart + 14] & 0xFF | (bytes[chunkStart + 15] & 0xFF) << 8;
                audioFormat = fmt;
                bitsPerSample = bps;
            } else if (id0 == 100 && id1 == 97 && id2 == 116 && id3 == 97) {
                dataOff = chunkStart;
                dataLen = size;
            }
            pos = chunkStart + size + (size & 1);
        }
        if (audioFormat != 1 || bitsPerSample != 16 || dataOff < 0 || dataLen <= 0) {
            return in;
        }
        byte[] out = (byte[])bytes.clone();
        int end = Math.min(dataOff + dataLen, out.length);
        int i = dataOff;
        while (i + 1 < end) {
            int hi = out[i + 1] & 0xFF;
            int lo = out[i] & 0xFF;
            short s = (short)(hi << 8 | lo);
            int scaled = Math.round((float)s * volume01);
            if (scaled < Short.MIN_VALUE) {
                scaled = Short.MIN_VALUE;
            }
            if (scaled > Short.MAX_VALUE) {
                scaled = Short.MAX_VALUE;
            }
            short ns = (short)scaled;
            out[i] = (byte)(ns & 0xFF);
            out[i + 1] = (byte)(ns >> 8 & 0xFF);
            i += 2;
        }
        Path outDir = ExternalSoundPlayer.getBaseDir();
        Files.createDirectories(outDir, new FileAttribute[0]);
        String baseName = in.getFileName().toString().replace('.', '_');
        Path outPath = outDir.resolve("scaled_" + baseName + "_v" + Math.round(volume01 * 100.0f) + ".wav");
        Files.write(outPath, out, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return outPath;
    }

    private static Path generateWav(int soundId, float volume01) throws IOException {
        int sampleRate = 44100;
        double durationSec = 0.35;
        int samples = (int)((double)sampleRate * durationSec);
        double freq = ExternalSoundPlayer.freqFor(soundId);
        float amplitude = Math.max(0.0f, Math.min(1.0f, volume01));
        byte[] data = new byte[samples * 2];
        for (int i = 0; i < samples; ++i) {
            double t = (double)i / (double)sampleRate;
            double s = Math.sin(Math.PI * 2 * freq * t);
            double env = 1.0;
            double attack = 0.02;
            double release = 0.05;
            if (t < attack) {
                env = t / attack;
            } else if (t > durationSec - release) {
                env = Math.max(0.0, (durationSec - t) / release);
            }
            int val = (int)Math.round((double)(32767.0f * amplitude) * s * env);
            data[2 * i] = (byte)(val & 0xFF);
            data[2 * i + 1] = (byte)(val >> 8 & 0xFF);
        }
        byte[] wav = ExternalSoundPlayer.buildWav(data, sampleRate, 1, 16);
        Path outDir = ExternalSoundPlayer.getBaseDir();
        Files.createDirectories(outDir, new FileAttribute[0]);
        Path out = outDir.resolve("tone_" + soundId + "_" + Math.round(amplitude * 100.0f) + ".wav");
        Files.write(out, wav, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        return out;
    }

    private static byte[] buildWav(byte[] pcm, int sampleRate, int channels, int bitsPerSample) throws IOException {
        int byteRate = sampleRate * channels * bitsPerSample / 8;
        int blockAlign = channels * bitsPerSample / 8;
        int dataSize = pcm.length;
        int chunkSize = 36 + dataSize;
        ByteArrayOutputStream out = new ByteArrayOutputStream(44 + dataSize);
        DataOutputStream d = new DataOutputStream(out);
        d.writeBytes("RIFF");
        d.writeInt(Integer.reverseBytes(chunkSize));
        d.writeBytes("WAVE");
        d.writeBytes("fmt ");
        d.writeInt(Integer.reverseBytes(16));
        d.writeShort(Short.reverseBytes((short)1));
        d.writeShort(Short.reverseBytes((short)channels));
        d.writeInt(Integer.reverseBytes(sampleRate));
        d.writeInt(Integer.reverseBytes(byteRate));
        d.writeShort(Short.reverseBytes((short)blockAlign));
        d.writeShort(Short.reverseBytes((short)bitsPerSample));
        d.writeBytes("data");
        d.writeInt(Integer.reverseBytes(dataSize));
        d.write(pcm);
        d.flush();
        return out.toByteArray();
    }

    public static boolean playOneShot(int soundId, float volume01) {
        if (!ExternalSoundPlayer.isWindows()) {
            return false;
        }
        try {
            Process p;
            Path wav;
            Path exe = ExternalSoundPlayer.ensureHelperExe();
            Path custom = ExternalSoundPlayer.resolveCustomWav(soundId);
            if (custom != null) {
                Path maybeScaled;
                try {
                    maybeScaled = ExternalSoundPlayer.scaleWav16PCM(custom, volume01);
                }
                catch (Throwable t) {
                    maybeScaled = custom;
                }
                wav = maybeScaled;
            } else {
                wav = ExternalSoundPlayer.generateWav(soundId, volume01);
            }
            ExternalSoundPlayer.stop();
            lastProcess = p = new ProcessBuilder(exe.toString(), wav.toString()).redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD).start();
            Thread cleaner = new Thread(() -> {
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (lastProcess == p) {
                    lastProcess = null;
                }
            }, "AFD-Sound-Cleaner");
            cleaner.setDaemon(true);
            cleaner.start();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void stop() {
        block7: {
            try {
                Process lp = lastProcess;
                if (lp == null) break block7;
                lp.destroy();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (lp.isAlive()) {
                    lp.destroyForcibly();
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                lastProcess = null;
            }
        }
    }
}

