/*
 * Decompiled with CFR 0.152.
 */
package syzez.autofishingdeluxe.Failsafes;

import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import syzez.autofishingdeluxe.AutoFishingConfig;
import syzez.autofishingdeluxe.AutoFishingHandler;
import syzez.autofishingdeluxe.PushNotifications;

public class FailsafeMacro {
    private static boolean enabled = false;
    private static String command = "";
    private static Behavior behavior = Behavior.STOP;
    private static int reactivateDelaySeconds = 3;
    private static final Random RNG = new Random();
    private static boolean running = false;
    private static Phase phase = Phase.IDLE;
    private static int timer = 0;

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean v) {
        enabled = v;
    }

    public static String getCommand() {
        return command;
    }

    public static void setCommand(String s) {
        command = s == null ? "" : s;
    }

    public static Behavior getBehavior() {
        return behavior;
    }

    public static void setBehavior(Behavior b) {
        behavior = b == null ? Behavior.STOP : b;
    }

    public static void toggleBehavior() {
        behavior = behavior == Behavior.STOP ? Behavior.REACTIVATE : Behavior.STOP;
    }

    public static int getReactivateDelaySeconds() {
        return reactivateDelaySeconds;
    }

    public static void setReactivateDelaySeconds(int sec) {
        reactivateDelaySeconds = Math.max(3, Math.min(60, sec));
    }

    public static boolean onInventoryFullTriggered(AutoFishingHandler handler) {
        if (!enabled) {
            return false;
        }
        if (running) {
            return true;
        }
        running = true;
        phase = Phase.WAIT_RANDOM;
        timer = 40 + RNG.nextInt(41);
        handler.pauseForMacro();
        handler.sendChatMessage((class_2561)class_2561.method_43470((String)"Inventory Full Macro active\u2026").method_27692(class_124.field_1080));
        return true;
    }

    public static boolean tick(AutoFishingHandler handler) {
        if (!running) {
            return false;
        }
        if (timer > 0) {
            --timer;
            return true;
        }
        switch (phase.ordinal()) {
            case 1: {
                phase = Phase.SEND_CMD;
                break;
            }
            case 2: {
                String s = command == null ? "" : command.trim();
                class_310 mc = class_310.method_1551();
                if (!s.isEmpty() && mc != null && mc.method_1562() != null) {
                    if (s.startsWith("/")) {
                        mc.method_1562().method_45730(s.substring(1));
                    } else {
                        mc.method_1562().method_45729(s);
                    }
                }
                phase = Phase.VERIFY_AFTER_CMD;
                timer = 40;
                break;
            }
            case 3: {
                if (FailsafeMacro.isInventoryFull()) {
                    handler.resumeFromMacro();
                    handler.triggerFailsafe("Inventory Full");
                    FailsafeMacro.reset();
                    return true;
                }
                if (behavior == Behavior.STOP) {
                    handler.sendChatMessage((class_2561)class_2561.method_43470((String)"Command executed, stopped."));
                    PushNotifications.addNotification((class_2561)class_2561.method_43470((String)"AutoFishingDeluxe"), (class_2561)class_2561.method_43470((String)"Command executed, stopped."));
                    handler.resumeFromMacro();
                    handler.stopAutoFishing();
                    FailsafeMacro.reset();
                    return true;
                }
                phase = Phase.REACT_DELAY;
                timer = reactivateDelaySeconds * 20;
                break;
            }
            case 4: {
                phase = Phase.CAST_ONCE;
                break;
            }
            case 5: {
                handler.simulateOneCast();
                phase = Phase.WAIT_ONE_SEC;
                timer = 20;
                break;
            }
            case 6: {
                handler.prepareAfterMacroReactivate();
                handler.resumeFromMacro();
                FailsafeMacro.reset();
                break;
            }
            case 0: 
            case 7: {
                FailsafeMacro.reset();
            }
        }
        return true;
    }

    public static boolean isRunning() {
        return running;
    }

    private static boolean isInventoryFull() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            return false;
        }
        for (int i = 0; i < 36; ++i) {
            class_1799 stack = mc.field_1724.method_31548().method_5438(i);
            if (!stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    private static void reset() {
        running = false;
        phase = Phase.IDLE;
        timer = 0;
    }

    public static void initFromConfig(AutoFishingConfig cfg) {
        if (cfg == null) {
            return;
        }
        FailsafeMacro.setEnabled(cfg.inventoryFullMacroEnabled);
        FailsafeMacro.setCommand(cfg.inventoryFullMacroCommand == null ? "" : cfg.inventoryFullMacroCommand);
        FailsafeMacro.setBehavior("REACTIVATE".equalsIgnoreCase(cfg.inventoryFullMacroBehavior) ? Behavior.REACTIVATE : Behavior.STOP);
        FailsafeMacro.setReactivateDelaySeconds(cfg.inventoryFullMacroReactivateDelaySeconds);
    }

    public static void writeToConfig(AutoFishingConfig cfg) {
        if (cfg == null) {
            return;
        }
        cfg.inventoryFullMacroEnabled = FailsafeMacro.isEnabled();
        cfg.inventoryFullMacroCommand = FailsafeMacro.getCommand();
        cfg.inventoryFullMacroBehavior = FailsafeMacro.getBehavior().name();
        cfg.inventoryFullMacroReactivateDelaySeconds = FailsafeMacro.getReactivateDelaySeconds();
    }

    public static enum Behavior {
        STOP,
        REACTIVATE;

    }

    private static enum Phase {
        IDLE,
        WAIT_RANDOM,
        SEND_CMD,
        VERIFY_AFTER_CMD,
        REACT_DELAY,
        CAST_ONCE,
        WAIT_ONE_SEC,
        DONE;

    }
}

