/*
 * Decompiled with CFR 0.152.
 */
package syzez.autofishingdeluxe.Failsafes;

import java.util.Random;
import syzez.autofishingdeluxe.AutoFishingConfig;
import syzez.autofishingdeluxe.AutoFishingHandler;

public final class Failsafe_BobberClear {
    private static final Random RNG = new Random();
    private static boolean initialized = false;
    private static boolean lastHasBobber = false;
    private static int pendingDelayTicks = -1;

    private Failsafe_BobberClear() {
    }

    public static void onStart(AutoFishingHandler handler) {
        Failsafe_BobberClear.reset();
        if (handler != null) {
            initialized = true;
            lastHasBobber = Failsafe_BobberClear.safeHasBobber(handler);
        }
    }

    public static void reset() {
        initialized = false;
        lastHasBobber = false;
        pendingDelayTicks = -1;
    }

    private static boolean safeHasBobber(AutoFishingHandler handler) {
        try {
            return handler != null && handler.hasBobberOut();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void tick(AutoFishingHandler handler) {
        if (handler == null || !handler.isFishingActive()) {
            return;
        }
        AutoFishingConfig cfg = handler.getConfig();
        if (cfg == null || !cfg.bobberClearFailsafeEnabled) {
            return;
        }
        boolean hasBobber = Failsafe_BobberClear.safeHasBobber(handler);
        if (!initialized) {
            initialized = true;
            lastHasBobber = hasBobber;
        } else {
            if (lastHasBobber && !hasBobber && !handler.isWaitingToReelIn()) {
                pendingDelayTicks = 20 + RNG.nextInt(21);
            }
            lastHasBobber = hasBobber;
        }
        if (hasBobber) {
            pendingDelayTicks = -1;
            return;
        }
        if (pendingDelayTicks > 0) {
            --pendingDelayTicks;
        } else if (pendingDelayTicks == 0) {
            handler.requestCastIfNoBobber();
            pendingDelayTicks = -1;
        }
    }
}

