/*
 * Decompiled with CFR 0.152.
 */
package syzez.autofishingdeluxe.Failsafes;

import java.util.Random;
import syzez.autofishingdeluxe.AutoFishingHandler;

public class Failsafe_Recast {
    private static final Random RAND = new Random();
    private static Phase phase = Phase.IDLE;
    private static int phaseTicks = 0;
    private static int waterTicks = 0;
    private static int reelWaitTarget = 0;
    private static int castWaitTarget = 0;
    private static int waterRetryTarget = 0;

    public static void reset() {
        phase = Phase.IDLE;
        phaseTicks = 0;
        waterTicks = 0;
        waterRetryTarget = 0;
        castWaitTarget = 0;
        reelWaitTarget = 0;
    }

    public static void tick(AutoFishingHandler handler) {
        if (!handler.isFishingActive() || !handler.getConfig().recastFailsafeEnabled) {
            Failsafe_Recast.reset();
            return;
        }
        int timeoutTicks = handler.getConfig().recastTimeoutSeconds * 20;
        int reelDelay = handler.getConfig().reelInDelayTicks;
        int recastDelay = handler.getConfig().recastDelayTicks;
        switch (phase.ordinal()) {
            case 0: {
                if (!handler.isBobberInLiquid()) break;
                waterTicks = 0;
                phase = Phase.COUNTING;
                phaseTicks = 0;
                break;
            }
            case 1: {
                if (handler.isBobberInLiquid()) {
                    if (++waterTicks < timeoutTicks) break;
                    reelWaitTarget = reelDelay + RAND.nextInt(11);
                    phase = Phase.WAIT_REEL;
                    phaseTicks = 0;
                    break;
                }
                waterTicks = 0;
                break;
            }
            case 2: {
                handler.requestReelThenRecast();
                waterRetryTarget = recastDelay + RAND.nextInt(11);
                phase = Phase.WAIT_WATER;
                phaseTicks = 0;
                break;
            }
            case 3: {
                waterRetryTarget = recastDelay + RAND.nextInt(11);
                phase = Phase.WAIT_WATER;
                phaseTicks = 0;
                break;
            }
            case 4: {
                if (handler.isBobberInLiquid()) {
                    waterTicks = 0;
                    phase = Phase.COUNTING;
                    phaseTicks = 0;
                    break;
                }
                if (++phaseTicks < waterRetryTarget) break;
                if (handler.hasBobberOut()) {
                    handler.requestReelThenRecast();
                } else {
                    handler.requestRecast();
                }
                waterRetryTarget = recastDelay + RAND.nextInt(11);
                phaseTicks = 0;
            }
        }
    }

    private static enum Phase {
        IDLE,
        COUNTING,
        WAIT_REEL,
        WAIT_CAST,
        WAIT_WATER;

    }
}

