/*
 * Decompiled with CFR 0.152.
 */
package syzez.autofishingdeluxe.Failsafes;

import syzez.autofishingdeluxe.AutoFishingConfig;
import syzez.autofishingdeluxe.AutoFishingHandler;
import syzez.autofishingdeluxe.TurboFishingManager;

public final class Failsafe_Spam {
    private static final int WINDOW_TICKS = 20;
    private static final int THRESHOLD = 5;
    private static final int[] perTickActions = new int[20];
    private static int index = 0;
    private static int actionsThisTick = 0;
    private static int windowSum = 0;
    private static boolean stateInitialized = false;
    private static boolean lastHasBobber = false;

    private Failsafe_Spam() {
    }

    public static void onStart(AutoFishingHandler handler) {
        Failsafe_Spam.reset();
        if (handler != null) {
            stateInitialized = true;
            lastHasBobber = Failsafe_Spam.safeHasBobber(handler);
        }
    }

    public static void reset() {
        for (int i = 0; i < perTickActions.length; ++i) {
            Failsafe_Spam.perTickActions[i] = 0;
        }
        index = 0;
        actionsThisTick = 0;
        windowSum = 0;
        stateInitialized = false;
        lastHasBobber = false;
    }

    private static boolean isPausedForTurbo(AutoFishingHandler handler) {
        if (handler == null) {
            return false;
        }
        AutoFishingConfig cfg = handler.getConfig();
        if (cfg == null) {
            return false;
        }
        return cfg.enchantBehaviourEnabled && TurboFishingManager.isActive();
    }

    private static boolean safeHasBobber(AutoFishingHandler handler) {
        try {
            return handler != null && handler.hasBobberOut();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void onReelAction(AutoFishingHandler handler) {
    }

    public static void tick(AutoFishingHandler handler) {
        if (handler == null || !handler.isFishingActive()) {
            return;
        }
        AutoFishingConfig cfg = handler.getConfig();
        if (cfg == null || !cfg.spamFailsafeEnabled) {
            return;
        }
        if (Failsafe_Spam.isPausedForTurbo(handler)) {
            Failsafe_Spam.reset();
            return;
        }
        boolean hasBobber = Failsafe_Spam.safeHasBobber(handler);
        if (!stateInitialized) {
            stateInitialized = true;
            lastHasBobber = hasBobber;
        } else if (hasBobber != lastHasBobber) {
            lastHasBobber = hasBobber;
        }
        int old = perTickActions[index];
        windowSum -= old;
        Failsafe_Spam.perTickActions[Failsafe_Spam.index] = ++actionsThisTick;
        windowSum += actionsThisTick;
        index = (index + 1) % 20;
        actionsThisTick = 0;
        if (windowSum > 5) {
            handler.triggerFailsafe("spam reeling detected");
        }
    }
}

