/*
 * Decompiled with CFR 0.152.
 */
package syzez.autofishingdeluxe;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import syzez.autofishingdeluxe.AutoFishingConfig;
import syzez.autofishingdeluxe.AutoFishingDeluxe;
import syzez.autofishingdeluxe.AutoFishingDetectionMethod;
import syzez.autofishingdeluxe.AutoFishingHandler;
import syzez.autofishingdeluxe.EditMiniHud;
import syzez.autofishingdeluxe.Failsafes.FailsafeMacro;
import syzez.autofishingdeluxe.MiniInventoryHud;
import syzez.autofishingdeluxe.ToggleCategoryButton;

public class SettingsScreen
extends class_437 {
    private final class_437 previousScreen;
    private final Deque<MenuState> menuHistory = new ArrayDeque<MenuState>();
    private MenuState current = MenuState.MAIN;
    private static final int BTN_W = 140;
    private static final int BTN_H = 20;
    private static final int GAP = 8;
    private static final int STEPPER_W = 36;
    private static final int STEPPER_H = 16;
    private static final int STEPPER_GAP = 6;
    private static final int COL_GAP = 24;
    private class_327 tr;
    private ToggleCategoryButton detectionToggleButton;
    private ToggleCategoryButton velocityLabelBtn;
    private ToggleCategoryButton soundLabelBtn;
    private ToggleCategoryButton titleLabelBtn;
    private float toggleProgress = 0.0f;
    private float animTarget = 0.0f;
    private boolean animating = false;
    private float pressPulse = 0.0f;
    private class_342 macroInput;
    private class_342 reactivateDelayField;
    private class_342 titleMsgField;
    private static final int[] HUD_BORDER_COLORS = new int[]{0xFFFFFF, 65535, 65280, 0xFFFF00, 16753920, 0xFF0000, 0xFF00FF, 0x800080, 33023, 10133670};

    public SettingsScreen(class_437 previousScreen) {
        super((class_2561)class_2561.method_43470((String)""));
        this.previousScreen = previousScreen;
    }

    private void clearPage() {
        this.method_37067();
        this.method_25395(null);
        this.detectionToggleButton = null;
        this.titleMsgField = null;
        switch (AutoFishingDetectionMethod.getCurrentMethod()) {
            case VELOCITY: {
                this.toggleProgress = 0.0f;
                break;
            }
            case TITLE_MESSAGE: {
                this.toggleProgress = 0.5f;
                break;
            }
            case SOUND: {
                this.toggleProgress = 1.0f;
            }
        }
    }

    protected void method_25426() {
        this.tr = this.field_22793;
        super.method_25426();
        this.clearPage();
        switch (this.current.ordinal()) {
            case 0: {
                this.buildMain();
                break;
            }
            case 1: {
                this.buildFishing();
                break;
            }
            case 8: {
                this.buildFishingMethod();
                break;
            }
            case 9: {
                this.buildTitleMessageEdit();
                break;
            }
            case 2: {
                this.buildFailsafes();
                break;
            }
            case 3: {
                this.buildFailsafeMacro();
                break;
            }
            case 4: {
                this.buildGUI();
                break;
            }
            case 5: {
                this.buildSound();
                break;
            }
            case 6: {
                this.buildMisc();
                break;
            }
            case 7: {
                this.buildAdvanced();
            }
        }
        this.addBackButton();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, 0x66000000);
        super.method_25394(context, mouseX, mouseY, delta);
        int titleX = (this.field_22789 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
        try {
            context.method_27535(this.field_22793, this.field_22785, titleX, 20, -2039584);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (this.detectionToggleButton != null) {
            if (this.animating) {
                float step = 0.18f;
                this.toggleProgress += (this.animTarget - this.toggleProgress) * step;
                if (Math.abs(this.animTarget - this.toggleProgress) < 0.003f) {
                    this.toggleProgress = this.animTarget;
                    this.animating = false;
                }
            }
            float p = this.toggleProgress;
            float t = p * p * (3.0f - 2.0f * p);
            int x = this.detectionToggleButton.method_46426();
            int y = this.detectionToggleButton.method_46427();
            int w = this.detectionToggleButton.method_25368();
            int h = this.detectionToggleButton.method_25364();
            if (this.velocityLabelBtn != null && this.soundLabelBtn != null && this.titleLabelBtn != null) {
                int colorRgb;
                int sbw;
                int sby;
                int sbx;
                float snap;
                int vx = this.velocityLabelBtn.method_46426();
                int vy = this.velocityLabelBtn.method_46427();
                int vw = this.velocityLabelBtn.method_25368();
                int vh = this.velocityLabelBtn.method_25364();
                int sx = this.soundLabelBtn.method_46426();
                int sy = this.soundLabelBtn.method_46427();
                int sw = this.soundLabelBtn.method_25368();
                int sh = this.soundLabelBtn.method_25364();
                int ux = this.titleLabelBtn.method_46426();
                int uy = this.titleLabelBtn.method_46427();
                int uw = this.titleLabelBtn.method_25368();
                int uh = this.titleLabelBtn.method_25364();
                float lx = (float)vx + (float)vw / 2.0f;
                float ly = (float)vy + (float)vh / 2.0f;
                float mx = (float)ux + (float)uw / 2.0f;
                float my = (float)uy + (float)uh / 2.0f;
                float rx = (float)sx + (float)sw / 2.0f;
                float ry = (float)sy + (float)sh / 2.0f;
                if (t <= 0.5f) {
                    tt = t / 0.5f;
                    float ix = lx + (mx - lx) * tt;
                    float iy = ly + (my - ly) * tt;
                } else {
                    tt = (t - 0.5f) / 0.5f;
                    float ix = mx + (rx - mx) * tt;
                    float iy = my + (ry - my) * tt;
                }
                float f = Math.abs(this.animTarget - 0.0f) <= Math.abs(this.animTarget - 0.5f) && Math.abs(this.animTarget - 0.0f) <= Math.abs(this.animTarget - 1.0f) ? 0.0f : (snap = Math.abs(this.animTarget - 1.0f) < Math.abs(this.animTarget - 0.5f) ? 1.0f : 0.5f);
                if (snap == 0.5f) {
                    sbx = ux;
                    sby = uy;
                    sbw = uw;
                    int sbh = uh;
                    colorRgb = 0x22AA22;
                } else if (snap == 1.0f) {
                    sbx = sx;
                    sby = sy;
                    sbw = sw;
                    int sbh = sh;
                    colorRgb = 5577355;
                } else {
                    sbx = vx;
                    sby = vy;
                    sbw = vw;
                    int sbh = vh;
                    colorRgb = 0x1A1AFF;
                }
                int sq = 4;
                int cx = sbx + sbw / 2;
                int top = sby - 3 - sq;
                int left = cx - sq / 2;
                int right = left + sq;
                int bottom = top + sq;
                int cubeColor = 0xFF000000 | colorRgb & 0xFFFFFF;
                context.method_25294(left, top, right, bottom, cubeColor);
                context.method_49601(left - 1, top - 1, sq + 2, sq + 2, -14671840);
                float leftW = Math.max(0.0f, 1.0f - t / 0.5f);
                float rightW = Math.max(0.0f, 1.0f - (1.0f - t) / 0.5f);
                float upW = 1.0f - Math.abs(t - 0.5f) / 0.5f;
                int velA = (int)(leftW * leftW * 255.0f);
                int upA = (int)(upW * upW * 255.0f);
                int sndA = (int)(rightW * rightW * 255.0f);
                if (velA > 0) {
                    this.drawRoundedOutline(context, vx - 1, vy - 1, vw + 2, vh + 2, velA << 24 | 0x1A1AFF);
                }
                if (upA > 0) {
                    this.drawRoundedOutline(context, ux - 1, uy - 1, uw + 2, uh + 2, upA << 24 | 0x22AA22);
                }
                if (sndA > 0) {
                    this.drawRoundedOutline(context, sx - 1, sy - 1, sw + 2, sh + 2, sndA << 24 | 0x551A8B);
                }
                if (this.pressPulse > 0.0f) {
                    int baseGlowPulse;
                    int bh;
                    int bw;
                    int by;
                    int bx;
                    this.pressPulse = Math.max(0.0f, this.pressPulse - 0.08f);
                    float pulseTarget = this.animTarget;
                    float dL = Math.abs(pulseTarget - 0.0f);
                    float dU = Math.abs(pulseTarget - 0.5f);
                    float dR = Math.abs(pulseTarget - 1.0f);
                    if (dU <= dL && dU <= dR) {
                        bx = ux;
                        by = uy;
                        bw = uw;
                        bh = uh;
                        baseGlowPulse = 43520;
                    } else if (dR < dL) {
                        bx = sx;
                        by = sy;
                        bw = sw;
                        bh = sh;
                        baseGlowPulse = 5577355;
                    } else {
                        bx = vx;
                        by = vy;
                        bw = vw;
                        bh = vh;
                        baseGlowPulse = 0x1A1AFF;
                    }
                    int expand = (int)Math.ceil(3.0f * this.pressPulse);
                    int a1 = (int)(120.0f * this.pressPulse);
                    int a2 = (int)(70.0f * this.pressPulse);
                    int a3 = (int)(30.0f * this.pressPulse);
                    int c1 = a1 << 24 | baseGlowPulse;
                    int c2 = a2 << 24 | baseGlowPulse;
                    int c3 = a3 << 24 | baseGlowPulse;
                    this.drawRoundedOutline(context, bx - 1, by - 1, bw + 2, bh + 2, c1);
                    this.drawRoundedOutline(context, bx - 1 - expand, by - 1 - expand, bw + 2 + 2 * expand, bh + 2 + 2 * expand, c2);
                    this.drawRoundedOutline(context, bx - 2 - expand, by - 2 - expand, bw + 4 + 2 * expand, bh + 4 + 2 * expand, c3);
                }
            }
        }
    }

    private void drawRoundedOutline(class_332 ctx, int x, int y, int width, int height, int color) {
        int r = height / 2;
        ctx.method_25294(x + r, y, x + width - r, y + 1, color);
        ctx.method_25294(x + r, y + height - 1, x + width - r, y + height, color);
        for (int i = 0; i < r; ++i) {
            int dy = r - i;
            ctx.method_25294(x + i, y + dy - 1, x + i + 1, y + dy, color);
            ctx.method_25294(x + width - i - 1, y + dy - 1, x + width - i, y + dy, color);
            ctx.method_25294(x + i, y + height - dy, x + i + 1, y + height - dy + 1, color);
            ctx.method_25294(x + width - i - 1, y + height - dy, x + width - i, y + height - dy + 1, color);
        }
        ctx.method_25294(x, y + r - 1, x + 1, y + height - r + 1, color);
        ctx.method_25294(x + width - 1, y + r - 1, x + width, y + height - r + 1, color);
    }

    private void drawCircle(class_332 ctx, int cx, int cy, int radius, int argb) {
        int r2 = radius * radius;
        for (int dy = -radius; dy <= radius; ++dy) {
            int yy = cy + dy;
            int dx = (int)Math.floor(Math.sqrt(Math.max(0, r2 - dy * dy)));
            int x1 = cx - dx;
            int x2 = cx + dx + 1;
            ctx.method_25294(x1, yy, x2, yy + 1, argb);
        }
    }

    private int centerX(int w) {
        return (this.field_22789 - w) / 2;
    }

    private int columnTop() {
        return this.field_22790 / 4;
    }

    private int addUIButton(class_2561 label, Runnable onClick, int y) {
        ToggleCategoryButton b = new ToggleCategoryButton(this.centerX(140), y, 140, 20, label, this.tr, btn -> onClick.run(), false);
        this.method_37063((class_364)b);
        return y + 20 + 8;
    }

    private int addUIToggle(class_2561 label, boolean isOn, Runnable onClick, int y) {
        ToggleCategoryButton b = new ToggleCategoryButton(this.centerX(140), y, 140, 20, label, this.tr, btn -> onClick.run(), isOn);
        this.method_37063((class_364)b);
        return y + 20 + 8;
    }

    private void addStepperButton(String label, int x, int y, Runnable onClick) {
        ToggleCategoryButton b = new ToggleCategoryButton(x, y, 36, 16, (class_2561)class_2561.method_43470((String)label), this.tr, btn -> onClick.run(), false);
        this.method_37063((class_364)b);
    }

    private int addStepperUnder(String prefix, String unit, IntSupplier getter, IntConsumer setter, int min, int max, int y) {
        return this.addStepperUnder(prefix, unit, getter, setter, min, max, 1, y);
    }

    private int addStepperUnder(String prefix, String unit, IntSupplier getter, IntConsumer setter, int min, int max, int step, int y) {
        ToggleCategoryButton label = new ToggleCategoryButton(this.centerX(140), y, 140, 20, (class_2561)class_2561.method_43470((String)(prefix + ": " + getter.getAsInt() + unit)), this.tr, btn -> {}, false);
        label.field_22763 = false;
        this.method_37063((class_364)label);
        int rowWidth = 78;
        int rowX = this.centerX(140) + (140 - rowWidth) / 2;
        int stepY = y + 20 + 2;
        this.addStepperButton("\u2013", rowX, stepY, () -> {
            int v = Math.max(min, getter.getAsInt() - step);
            setter.accept(v);
            label.method_25355((class_2561)class_2561.method_43470((String)(prefix + ": " + v + unit)));
        });
        this.addStepperButton("+", rowX + 36 + 6, stepY, () -> {
            int v = Math.min(max, getter.getAsInt() + step);
            setter.accept(v);
            label.method_25355((class_2561)class_2561.method_43470((String)(prefix + ": " + v + unit)));
        });
        return stepY + 16 + 8;
    }

    private int addStepperUnderAt(int baseX, String prefix, String unit, IntSupplier getter, IntConsumer setter, int max, int y) {
        ToggleCategoryButton label = new ToggleCategoryButton(baseX, y, 140, 20, (class_2561)class_2561.method_43470((String)(prefix + ": " + getter.getAsInt() + unit)), this.tr, btn -> {}, false);
        label.field_22763 = false;
        this.method_37063((class_364)label);
        int rowWidth = 78;
        int rowX = baseX + (140 - rowWidth) / 2;
        int stepY = y + 20 + 2;
        this.addStepperButton("\u2013", rowX, stepY, () -> {
            int v = Math.max(0, getter.getAsInt() - 1);
            setter.accept(v);
            label.method_25355((class_2561)class_2561.method_43470((String)(prefix + ": " + v + unit)));
        });
        this.addStepperButton("+", rowX + 36 + 6, stepY, () -> {
            int v = Math.min(max, getter.getAsInt() + 1);
            setter.accept(v);
            label.method_25355((class_2561)class_2561.method_43470((String)(prefix + ": " + v + unit)));
        });
        return stepY + 16 + 8;
    }

    private void push(MenuState next) {
        this.menuHistory.push(this.current);
        this.current = next;
        this.clearPage();
        this.method_25426();
    }

    private void popOrExit() {
        if (!this.menuHistory.isEmpty()) {
            this.current = this.menuHistory.pop();
            this.clearPage();
            this.method_25426();
        } else if (this.field_22787 != null) {
            this.field_22787.method_1507(this.previousScreen);
        }
    }

    private void addBackButton() {
        ToggleCategoryButton back = new ToggleCategoryButton(12, this.field_22790 - 28, 90, 20, (class_2561)class_2561.method_43470((String)"Back"), this.tr, btn -> this.popOrExit(), false);
        this.method_37063((class_364)back);
        int w = 90;
        int h = 20;
        int margin = 12;
        int x = this.field_22789 - margin - w;
        int y = this.field_22790 - 28;
        ToggleCategoryButton discord = new ToggleCategoryButton(x, y, w, h, (class_2561)class_2561.method_43470((String)"Discord"), this.tr, btn -> {
            String url = "https://discord.gg/6HA4vSDz6q";
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new class_407(confirmed -> {
                    if (confirmed) {
                        class_156.method_668().method_670(url);
                    }
                    this.field_22787.method_1507((class_437)this);
                }, url, true));
            }
        }, false);
        this.method_37063((class_364)discord);
    }

    private void buildMain() {
        int y = this.columnTop();
        y = this.addUIButton((class_2561)class_2561.method_43470((String)"Fishing"), () -> this.push(MenuState.FISHING), y);
        y = this.addUIButton((class_2561)class_2561.method_43470((String)"GUI"), () -> this.push(MenuState.GUI), y);
        y = this.addUIButton((class_2561)class_2561.method_43470((String)"Sound"), () -> this.push(MenuState.SOUND), y);
        y = this.addUIButton((class_2561)class_2561.method_43470((String)"Misc"), () -> this.push(MenuState.MISC), y);
        ToggleCategoryButton advBtn = new ToggleCategoryButton(this.centerX(140), y, 140, 20, (class_2561)class_2561.method_43470((String)"Advanced"), this.tr, btn -> this.push(MenuState.ADVANCED), false);
        advBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Check Discord for proper instructions and details")));
        this.method_37063((class_364)advBtn);
        y += 28;
    }

    private void buildFishing() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        int y = this.columnTop();
        ToggleCategoryButton fishingMethodBtn = new ToggleCategoryButton(this.centerX(140), y, 140, 20, (class_2561)class_2561.method_43470((String)"Fishing Method"), this.tr, btn -> this.push(MenuState.FISHING_METHOD), false);
        fishingMethodBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Changes the way AutoFishing detects fishes/hooks")));
        this.method_37063((class_364)fishingMethodBtn);
        y += 28;
        y = this.addUIButton((class_2561)class_2561.method_43470((String)"Failsafes"), () -> this.push(MenuState.FAILSAFES), y);
        ToggleCategoryButton macroBtn = new ToggleCategoryButton(this.centerX(140), y, 140, 20, (class_2561)class_2561.method_43470((String)"Failsafe Macro"), this.tr, btn -> this.push(MenuState.FAILSAFESMACRO), false);
        macroBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Change actions after certain Failsafe triggers")));
        this.method_37063((class_364)macroBtn);
        y += 28;
        int blockW = 304;
        int leftX = (this.field_22789 - blockW) / 2;
        int rightX = leftX + 140 + 24;
        int yL = this.addStepperUnderAt(leftX, "Reel-in Delay", " ticks", () -> handler.reelInDelayTicks, v -> {
            handler.reelInDelayTicks = v;
            handler.saveSettings();
        }, 80, y += 12);
        int yR = this.addStepperUnderAt(rightX, "Recast Delay", " ticks", () -> handler.recastDelayTicks, v -> {
            handler.recastDelayTicks = v;
            handler.saveSettings();
        }, 80, y);
        y = Math.max(yL, yR);
    }

    private void buildFishingMethod() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        switch (AutoFishingDetectionMethod.getCurrentMethod()) {
            case VELOCITY: {
                this.toggleProgress = 0.0f;
                break;
            }
            case TITLE_MESSAGE: {
                this.toggleProgress = 0.5f;
                break;
            }
            case SOUND: {
                this.toggleProgress = 1.0f;
            }
        }
        this.animTarget = this.toggleProgress;
        this.animating = false;
        this.pressPulse = 0.0f;
        int buttonHeight = 20;
        int labelWidth = 55;
        int toggleWidth = 50;
        int gap = 15;
        int totalWidth = 190;
        int startX = (this.field_22789 - 190) / 2;
        int y = this.field_22790 / 4;
        int toggleX = startX + 55 + 15;
        int soundX = toggleX + 50 + 15;
        int upX = toggleX + -2;
        int upY = y - 20 - 10;
        this.velocityLabelBtn = new ToggleCategoryButton(startX, y, 55, 20, (class_2561)class_2561.method_43470((String)"Velocity"), this.field_22793, btn -> {}, false);
        this.velocityLabelBtn.field_22763 = false;
        this.method_37063((class_364)this.velocityLabelBtn);
        this.titleLabelBtn = new ToggleCategoryButton(upX, upY, 55, 20, (class_2561)class_2561.method_43470((String)"TitleMsg"), this.field_22793, btn -> {}, false);
        this.titleLabelBtn.field_22763 = false;
        this.method_37063((class_364)this.titleLabelBtn);
        this.detectionToggleButton = new ToggleCategoryButton(toggleX, y, 50, 20, (class_2561)class_2561.method_43470((String)"\u27f3"), this.field_22793, btn -> {
            AutoFishingDetectionMethod.toggleMethod();
            handler.getConfig().detectionMethod = AutoFishingDetectionMethod.getCurrentMethod().name();
            handler.saveSettings();
            switch (AutoFishingDetectionMethod.getCurrentMethod()) {
                case VELOCITY: {
                    this.animTarget = 0.0f;
                    break;
                }
                case TITLE_MESSAGE: {
                    this.animTarget = 0.5f;
                    break;
                }
                case SOUND: {
                    this.animTarget = 1.0f;
                }
            }
            this.animating = true;
            this.pressPulse = 1.0f;
            this.method_25426();
        }, false);
        this.detectionToggleButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Click to cycle detection: Velocity \u2194 Title Message \u2194 Sound")));
        this.method_37063((class_364)this.detectionToggleButton);
        this.soundLabelBtn = new ToggleCategoryButton(soundX, y, 55, 20, (class_2561)class_2561.method_43470((String)"Sound"), this.field_22793, btn -> {}, false);
        this.soundLabelBtn.field_22763 = false;
        this.method_37063((class_364)this.soundLabelBtn);
        int yBelowToggle = y + 20 + 10;
        int bump = 0;
        if (AutoFishingDetectionMethod.getCurrentMethod() == AutoFishingDetectionMethod.Method.TITLE_MESSAGE) {
            ToggleCategoryButton editMsgBtn = new ToggleCategoryButton(this.centerX(140), yBelowToggle, 140, 20, (class_2561)class_2561.method_43470((String)"Edit Message"), this.field_22793, btn -> this.push(MenuState.FISHING_METHOD_MSG_EDIT), false);
            this.method_37063((class_364)editMsgBtn);
            bump = 28;
        }
        int y2 = y + 20 + 40 + bump;
        ToggleCategoryButton instantBtn = new ToggleCategoryButton(this.centerX(140), y2, 140, 20, (class_2561)class_2561.method_43470((String)"Instant Detection"), this.field_22793, btn -> {
            handler.getConfig().instantFishingEnabled = !handler.getConfig().instantFishingEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().instantFishingEnabled);
        instantBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Fastest detection, still works with reel in/out delays")));
        this.method_37063((class_364)instantBtn);
        int y3 = y2 + 20 + 8;
        ToggleCategoryButton randomDelayBtn = new ToggleCategoryButton(this.centerX(140), y3, 140, 20, (class_2561)class_2561.method_43470((String)"Random 1\u201310 tick delay"), this.field_22793, btn -> {
            handler.getConfig().randomDelayEnabled = !handler.getConfig().randomDelayEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().randomDelayEnabled);
        randomDelayBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Adds a random 1\u201310 tick delay to reel and recast")));
        this.method_37063((class_364)randomDelayBtn);
    }

    private int addUIButtonDynamicWidth(class_2561 label, Runnable onClick, int y) {
        int padding = 12;
        int textWidth = this.tr.method_27525((class_5348)label);
        int buttonWidth = textWidth + padding * 2;
        ToggleCategoryButton b = new ToggleCategoryButton(this.centerX(buttonWidth), y, buttonWidth, 20, label, this.tr, btn -> onClick.run(), false);
        this.method_37063((class_364)b);
        return y + 20 + 8;
    }

    private void buildTitleMessageEdit() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        if (AutoFishingDetectionMethod.getCurrentMethod() != AutoFishingDetectionMethod.Method.TITLE_MESSAGE) {
            this.popOrExit();
            return;
        }
        int y = this.columnTop();
        ToggleCategoryButton heading = new ToggleCategoryButton(this.centerX(140), y, 140, 20, (class_2561)class_2561.method_43470((String)"Edit Title Message"), this.tr, b -> {}, false);
        heading.field_22763 = false;
        this.method_37063((class_364)heading);
        y += 28;
        int groupW = 140;
        int chipW = 36;
        int chipGap = 6;
        int inputW = groupW - chipW - chipGap;
        int inputX = this.centerX(groupW);
        int chipX = inputX + inputW + chipGap;
        int chipY = y + 2;
        this.titleMsgField = new class_342(this.tr, inputX, y, inputW, 20, (class_2561)class_2561.method_43470((String)"Overlay text to detect"));
        String existing = handler != null && handler.getConfig() != null && handler.getConfig().titleMessageTarget != null ? handler.getConfig().titleMessageTarget : "";
        this.titleMsgField.method_1852(existing);
        this.titleMsgField.method_1880(160);
        this.titleMsgField.method_1863(s -> {});
        this.method_25429((class_364)this.titleMsgField);
        this.method_37063((class_364)this.titleMsgField);
        this.addStepperButton("\u2713", chipX, chipY, () -> {
            String txt = this.titleMsgField.method_1882().trim();
            if (txt.isEmpty()) {
                txt = "FISH";
            }
            handler.getConfig().titleMessageTarget = txt;
            handler.saveSettings();
            this.popOrExit();
        });
        int y2 = y + 20 + 8;
        ToggleCategoryButton resetBtn = new ToggleCategoryButton(this.centerX(140), y2, 140, 20, (class_2561)class_2561.method_43470((String)"Reset to default"), this.tr, b -> {
            handler.getConfig().titleMessageTarget = "FISH";
            handler.saveSettings();
            if (this.titleMsgField != null) {
                this.titleMsgField.method_1852(handler.getConfig().titleMessageTarget);
            }
        }, false);
        this.method_37063((class_364)resetBtn);
        y2 = y2 + 20 + 8;
        y2 = this.addUIToggle(this.getButtonText("Case sensitive", handler.getConfig().titleMessageCaseSensitive), handler.getConfig().titleMessageCaseSensitive, () -> {
            handler.getConfig().titleMessageCaseSensitive = !handler.getConfig().titleMessageCaseSensitive;
            handler.saveSettings();
            this.method_25426();
        }, y2);
        ToggleCategoryButton lessStrictBtn = new ToggleCategoryButton(this.centerX(140), y2, 140, 20, this.getButtonText("Less Strict", handler.getConfig().titleMessageLessStrict), this.tr, btn -> {
            handler.getConfig().titleMessageLessStrict = !handler.getConfig().titleMessageLessStrict;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().titleMessageLessStrict);
        lessStrictBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Makes it detect anything that matches the input, instead of an exact search")));
        this.method_37063((class_364)lessStrictBtn);
        y2 += 28;
    }

    private void buildFailsafes() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        int blockW = 304;
        int leftX = (this.field_22789 - blockW) / 2;
        int rightX = leftX + 140 + 24;
        int yL = this.columnTop();
        int yR = this.columnTop();
        ToggleCategoryButton b = new ToggleCategoryButton(leftX, yL, 140, 20, (class_2561)class_2561.method_43470((String)"GUI Open Failsafe"), this.tr, btn -> {
            handler.forceStopOnGuiOpen = !handler.forceStopOnGuiOpen;
            handler.saveSettings();
            this.method_25426();
        }, handler.forceStopOnGuiOpen);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stop when any GUI opens (chat, inventory, menus).")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(leftX, yL += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Break Protection"), this.tr, btn -> {
            if (handler.getConfig().fishingRodAutoSwapEnabled && handler.getConfig().breakProtectionFailsafeEnabled) {
                handler.sendChatMessage((class_2561)class_2561.method_43470((String)"Cannot disable Break Protection while Fishing Rod Swap is enabled!").method_27692(class_124.field_1079));
            } else {
                handler.getConfig().breakProtectionFailsafeEnabled = !handler.getConfig().breakProtectionFailsafeEnabled;
                handler.saveSettings();
                this.method_25426();
            }
        }, handler.getConfig().breakProtectionFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stop (or auto-swap if enabled) when rod is near breaking.")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(leftX, yL += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Teleport Failsafe"), this.tr, btn -> {
            handler.getConfig().teleportFailsafeEnabled = !handler.getConfig().teleportFailsafeEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().teleportFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stop if your position suddenly changes (teleport/lag spike).")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(leftX, yL += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Inventory Full Failsafe"), this.tr, btn -> {
            handler.getConfig().inventoryFullFailsafeEnabled = !handler.getConfig().inventoryFullFailsafeEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().inventoryFullFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stop when main inventory and actionbar is full.")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(leftX, yL += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Bobber Clear Failsafe"), this.tr, btn -> {
            handler.getConfig().bobberClearFailsafeEnabled = !handler.getConfig().bobberClearFailsafeEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().bobberClearFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Recast after 1\u20132s if your bobber gets cleared by plugins/lag.")));
        this.method_37063((class_364)b);
        yL += 28;
        b = new ToggleCategoryButton(rightX, yR, 140, 20, (class_2561)class_2561.method_43470((String)"Item Swap"), this.tr, btn -> {
            if (AutoFishingConfig.offhandRodSwapper) {
                handler.sendChatMessage((class_2561)class_2561.method_43470((String)"You cannot enable Item Swap Failsafe while Offhand Rod Swapper is active.").method_27692(class_124.field_1061));
                return;
            }
            handler.getConfig().itemSwapFailsafeEnabled = !handler.getConfig().itemSwapFailsafeEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().itemSwapFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stop if the held item unexpectedly changes during fishing.")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(rightX, yR += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Fishing Rod Swap"), this.tr, btn -> {
            if (AutoFishingConfig.offhandRodSwapper) {
                handler.sendChatMessage((class_2561)class_2561.method_43470((String)"You cannot enable Fishing Rod Swap while Offhand Rod Swapper is active.").method_27692(class_124.field_1061));
                return;
            }
            boolean bl = handler.getConfig().fishingRodAutoSwapEnabled = !handler.getConfig().fishingRodAutoSwapEnabled;
            if (handler.getConfig().fishingRodAutoSwapEnabled && !handler.getConfig().breakProtectionFailsafeEnabled) {
                handler.getConfig().breakProtectionFailsafeEnabled = true;
            }
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().fishingRodAutoSwapEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Auto-swap to a spare rod when durability is low.")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(rightX, yR += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Mouse Movement"), this.tr, btn -> {
            handler.mouseMovementEnabled = !handler.mouseMovementEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.mouseMovementEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Add subtle idle camera movement every 40 sec for 5 seconds.")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(rightX, yR += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Head Rotate Failsafe"), this.tr, btn -> {
            handler.getConfig().headRotateFailsafeEnabled = !handler.getConfig().headRotateFailsafeEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().headRotateFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stop if your view (yaw/pitch) is moved significantly.")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(rightX, yR += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Spam Failsafe"), this.tr, btn -> {
            handler.getConfig().spamFailsafeEnabled = !handler.getConfig().spamFailsafeEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().spamFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"If reels toggle >5 times in 1s, stop AutoFishing")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(rightX, yR += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Recast Failsafe"), this.tr, btn -> {
            handler.getConfig().recastFailsafeEnabled = !handler.getConfig().recastFailsafeEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().recastFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Recast if no bite within the timeout")));
        this.method_37063((class_364)b);
        yR += 28;
        if (handler.getConfig().recastFailsafeEnabled) {
            yR = this.addStepperUnderAt(rightX, "Recast Delay", "s", () -> handler.getConfig().recastTimeoutSeconds, v -> {
                handler.getConfig().recastTimeoutSeconds = v;
                handler.saveSettings();
            }, 300, yR);
        }
    }

    private void buildFailsafeMacro() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        AutoFishingConfig cfg = handler.getConfig();
        int y = this.columnTop();
        y = this.addUIToggle((class_2561)class_2561.method_43470((String)"Inventory Full Macro"), FailsafeMacro.isEnabled(), () -> {
            boolean newVal = !FailsafeMacro.isEnabled();
            FailsafeMacro.setEnabled(newVal);
            cfg.inventoryFullMacroEnabled = newVal;
            handler.saveSettings();
            this.method_25426();
        }, y);
        if (FailsafeMacro.isEnabled()) {
            int groupW = 140;
            int chipW = 36;
            int chipGap = 6;
            int inputW = groupW - chipW - chipGap;
            int inputX = this.centerX(groupW);
            int chipX = inputX + inputW + chipGap;
            int chipY = y + 2;
            this.macroInput = new class_342(this.tr, inputX, y, inputW, 20, (class_2561)class_2561.method_43470((String)"Macro command/message"));
            this.macroInput.method_1852(FailsafeMacro.getCommand());
            this.macroInput.method_1880(256);
            this.macroInput.method_1863(s -> {});
            this.method_25429((class_364)this.macroInput);
            this.method_37063((class_364)this.macroInput);
            this.addStepperButton("\u2713", chipX, chipY, () -> {
                String txt = this.macroInput.method_1882();
                FailsafeMacro.setCommand(txt);
                cfg.inventoryFullMacroCommand = txt;
                handler.saveSettings();
            });
            y += 28;
            y = this.addUIButton((class_2561)class_2561.method_43470((String)("Behavior: " + (FailsafeMacro.getBehavior() == FailsafeMacro.Behavior.STOP ? "Stop" : "Reactivate"))), () -> {
                FailsafeMacro.toggleBehavior();
                cfg.inventoryFullMacroBehavior = FailsafeMacro.getBehavior().name();
                handler.saveSettings();
                this.method_25426();
            }, y);
            if (FailsafeMacro.getBehavior() == FailsafeMacro.Behavior.REACTIVATE) {
                ToggleCategoryButton delayLabel = new ToggleCategoryButton(this.centerX(140), y, 140, 20, (class_2561)class_2561.method_43470((String)"Reactivate Delay (sec)"), this.tr, b -> {}, false);
                delayLabel.field_22763 = false;
                this.method_37063((class_364)delayLabel);
                int fieldW = 50;
                int extraPad = 6;
                int fieldY = y + 20 + extraPad;
                int chipX2 = chipX;
                int chipY2 = fieldY;
                int fieldX = chipX2 - 6 - fieldW;
                this.reactivateDelayField = new class_342(this.tr, fieldX, fieldY, fieldW, 16, (class_2561)class_2561.method_43470((String)"sec"));
                this.reactivateDelayField.method_1880(6);
                this.reactivateDelayField.method_1852(Integer.toString(FailsafeMacro.getReactivateDelaySeconds()));
                this.reactivateDelayField.method_1863(s -> {});
                this.method_25429((class_364)this.reactivateDelayField);
                this.method_37063((class_364)this.reactivateDelayField);
                this.addStepperButton("\u2713", chipX2, chipY2, () -> {
                    int v;
                    String raw = this.reactivateDelayField.method_1882();
                    String digits = raw.replaceAll("\\D+", "");
                    if (digits.isEmpty()) {
                        v = 3;
                    } else {
                        try {
                            v = Integer.parseInt(digits);
                        }
                        catch (NumberFormatException e) {
                            v = 60;
                        }
                    }
                    v = Math.max(3, Math.min(60, v));
                    FailsafeMacro.setReactivateDelaySeconds(v);
                    cfg.inventoryFullMacroReactivateDelaySeconds = v;
                    handler.saveSettings();
                    this.reactivateDelayField.method_1852(Integer.toString(v));
                });
                y += 44 + extraPad;
            }
        }
    }

    private void buildGUI() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        int y = this.columnTop();
        y = this.addUIToggle(this.getButtonText("Inventory HUD", handler.getConfig().inventoryHUDSetting), handler.getConfig().inventoryHUDSetting, () -> {
            MiniInventoryHud.toggle(handler.getConfig());
            handler.saveSettings();
            this.method_25426();
        }, y);
        y = this.addUIButton((class_2561)class_2561.method_43470((String)"Edit HUD Placement"), () -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new EditMiniHud());
            }
        }, y);
        y = this.addUIButton(this.getBorderColorText(handler.getConfig().hudBorderColor), () -> {
            handler.getConfig().hudBorderColor = this.getNextBorderColor(handler.getConfig().hudBorderColor);
            handler.saveSettings();
            this.method_25426();
        }, y);
        y = this.addStepperUnder("Transparency", "%", () -> SettingsScreen.getAlphaPercent(handler.getConfig().hudBorderColor), v -> {
            handler.getConfig().hudBorderColor = SettingsScreen.setAlphaPercent(handler.getConfig().hudBorderColor, v);
            handler.saveSettings();
        }, 0, 100, 5, y);
    }

    private void buildSound() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        int y = this.columnTop();
        boolean externalOn = handler.getConfig().useExternalSoundPlayerWindows;
        y = this.addUIToggle(this.getButtonText("Enable Failsafe Sound", externalOn), externalOn, () -> {
            handler.getConfig().useExternalSoundPlayerWindows = !handler.getConfig().useExternalSoundPlayerWindows;
            handler.saveSettings();
            this.method_25426();
        }, y);
        if (handler.getConfig().useExternalSoundPlayerWindows) {
            y = this.addStepperUnder("External Sound Volume", "%", () -> Math.max(0, Math.min(100, Math.round(handler.getConfig().externalAlertVolume * 100.0f))), v -> {
                v = Math.max(0, Math.min(100, v));
                handler.getConfig().externalAlertVolume = (float)v / 100.0f;
                handler.saveSettings();
            }, 0, 100, 5, y);
        }
        y = this.addUIButton((class_2561)class_2561.method_43470((String)("Sound: " + this.getSoundName(handler.getConfig().stopAlertSound))), () -> {
            int cur = handler.getConfig().stopAlertSound;
            handler.getConfig().stopAlertSound = cur = cur % 5 + 1;
            handler.saveSettings();
            this.method_25426();
        }, y);
        String mode = handler.getConfig().alertRepeatMode == null ? "ONCE" : handler.getConfig().alertRepeatMode;
        String modeLabel = switch (mode.toUpperCase()) {
            case "COUNT" -> "Specified Amount";
            case "UNTIL_ACTION" -> "Until User Action";
            default -> "Once";
        };
        y = this.addUIButton((class_2561)class_2561.method_43470((String)("Repeat: " + modeLabel)), () -> {
            String cur;
            String string = cur = handler.getConfig().alertRepeatMode == null ? "ONCE" : handler.getConfig().alertRepeatMode.toUpperCase();
            cur = cur.equals("ONCE") ? "COUNT" : (cur.equals("COUNT") ? "UNTIL_ACTION" : "ONCE");
            handler.getConfig().alertRepeatMode = cur;
            handler.saveSettings();
            this.method_25426();
        }, y);
        if ("COUNT".equalsIgnoreCase(handler.getConfig().alertRepeatMode)) {
            int groupW = 140;
            int chipW = 36;
            int chipGap = 6;
            int inputW = groupW - chipW - chipGap;
            int inputX = this.centerX(groupW);
            int chipX = inputX + inputW + chipGap;
            int chipY = y + 2;
            class_342 amountField = new class_342(this.tr, inputX, y, inputW, 20, (class_2561)class_2561.method_43470((String)"Times"));
            amountField.method_1880(6);
            amountField.method_1852(Integer.toString(Math.max(1, handler.getConfig().alertRepeatCount)));
            amountField.method_1863(s -> {});
            this.method_25429((class_364)amountField);
            this.method_37063((class_364)amountField);
            this.addStepperButton("\u2713", chipX, chipY, () -> {
                int v;
                String raw = amountField.method_1882();
                String digits = raw.replaceAll("\\D+", "");
                if (digits.isEmpty()) {
                    v = 1;
                } else {
                    try {
                        v = Integer.parseInt(digits);
                    }
                    catch (NumberFormatException e) {
                        v = 1;
                    }
                }
                handler.getConfig().alertRepeatCount = v = Math.max(1, Math.min(20, v));
                handler.saveSettings();
            });
            y += 28;
        }
        y = this.addUIButtonDynamicWidth((class_2561)class_2561.method_43470((String)"Test"), () -> AutoFishingHandler.getInstance().triggerFailsafe("Test"), y);
    }

    private void buildMisc() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        int y = this.columnTop();
        y = this.addUIToggle(this.getButtonText("Mouse Ungrab", handler.mouseUngrabEnabled), handler.mouseUngrabEnabled, () -> {
            handler.mouseUngrabEnabled = !handler.mouseUngrabEnabled;
            handler.saveSettings();
            this.method_25426();
        }, y);
        y = this.addUIToggle(this.getButtonText("Enable Chat-log", handler.getConfig().textNotificationsEnabled), handler.getConfig().textNotificationsEnabled, () -> {
            handler.getConfig().textNotificationsEnabled = !handler.getConfig().textNotificationsEnabled;
            handler.saveSettings();
            this.method_25426();
        }, y);
        y = this.addUIToggle(this.getButtonText("Enable Push-Notifications", handler.getConfig().pushNotificationsEnabled), handler.getConfig().pushNotificationsEnabled, () -> {
            handler.getConfig().pushNotificationsEnabled = !handler.getConfig().pushNotificationsEnabled;
            handler.saveSettings();
            this.method_25426();
        }, y);
    }

    private void buildAdvanced() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        int y = this.columnTop();
        y = this.addUIToggle(this.getButtonText("Offhand Rod Swapper", AutoFishingConfig.offhandRodSwapper), AutoFishingConfig.offhandRodSwapper, () -> {
            boolean bl = AutoFishingConfig.offhandRodSwapper = !AutoFishingConfig.offhandRodSwapper;
            if (AutoFishingConfig.offhandRodSwapper) {
                handler.getConfig().fishingRodAutoSwapEnabled = false;
                handler.getConfig().itemSwapFailsafeEnabled = false;
                handler.sendChatMessage((class_2561)class_2561.method_43470((String)"Disabled AutoSwap and ItemSwap Failsafe, due to confliction with Offhand Swapper.").method_27692(class_124.field_1061));
            }
            handler.saveSettings();
            this.method_25426();
        }, y);
        y = this.addUIToggle((class_2561)class_2561.method_43470((String)"Enchant Behaviour"), handler.getConfig().enchantBehaviourEnabled, () -> {
            handler.getConfig().enchantBehaviourEnabled = !handler.getConfig().enchantBehaviourEnabled;
            handler.saveSettings();
            this.method_25426();
        }, y);
        y = this.addUIToggle((class_2561)class_2561.method_43470((String)"Debug Logging"), handler.getConfig().debugLoggingEnabled, () -> {
            handler.getConfig().debugLoggingEnabled = !handler.getConfig().debugLoggingEnabled;
            handler.saveSettings();
            this.method_25426();
        }, y);
    }

    private String getSoundName(int id) {
        return switch (id) {
            case 1 -> "Anvil";
            case 2 -> "Villager";
            case 3 -> "Bell";
            case 4 -> "Level Up";
            case 5 -> "Xp Orb";
            default -> "Anvil";
        };
    }

    private class_2561 getButtonText(String label, boolean enabled) {
        return class_2561.method_43470((String)label);
    }

    private static int fullAlpha(int c) {
        return c & 0xFFFFFF | 0xFF000000;
    }

    private int getNextBorderColor(int current) {
        int alpha = current >>> 24 & 0xFF;
        int rgb = current & 0xFFFFFF;
        for (int i = 0; i < HUD_BORDER_COLORS.length; ++i) {
            if (HUD_BORDER_COLORS[i] != rgb) continue;
            int nextRgb = HUD_BORDER_COLORS[(i + 1) % HUD_BORDER_COLORS.length] & 0xFFFFFF;
            return alpha << 24 | nextRgb;
        }
        int firstRgb = HUD_BORDER_COLORS[0] & 0xFFFFFF;
        return alpha << 24 | firstRgb;
    }

    private String colorNameFor(int rgb) {
        return switch (rgb &= 0xFFFFFF) {
            case 0xFFFFFF -> "White";
            case 65535 -> "Cyan";
            case 65280 -> "Lime";
            case 0xFFFF00 -> "Yellow";
            case 16753920 -> "Orange";
            case 0xFF0000 -> "Red";
            case 0xFF00FF -> "Magenta";
            case 0x800080 -> "Purple";
            case 33023 -> "Blue";
            case 10133670 -> "Gray";
            default -> String.format("#%06X", rgb);
        };
    }

    private class_2561 getBorderColorText(int colorMaybeWithAlpha) {
        int rgb = colorMaybeWithAlpha & 0xFFFFFF;
        int sample = SettingsScreen.fullAlpha(rgb);
        return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)("HUD Border: " + this.colorNameFor(rgb) + " "))).method_10852((class_2561)class_2561.method_43470((String)"\u25cf").method_27694(s -> s.method_36139(sample)));
    }

    private static int clamp(int v, int lo, int hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static int setAlphaPercent(int argb, int percent) {
        int p = SettingsScreen.clamp(percent, 0, 100);
        int a = Math.round((float)p * 255.0f / 100.0f) & 0xFF;
        return a << 24 | argb & 0xFFFFFF;
    }

    private static int getAlphaPercent(int argb) {
        int a = argb >>> 24 & 0xFF;
        return Math.round((float)a * 100.0f / 255.0f);
    }

    public static enum MenuState {
        MAIN,
        FISHING,
        FAILSAFES,
        FAILSAFESMACRO,
        GUI,
        SOUND,
        MISC,
        ADVANCED,
        FISHING_METHOD,
        FISHING_METHOD_MSG_EDIT;

    }
}

