/*
 * Decompiled with CFR 0.152.
 */
package syzez.autofishingdeluxe;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import syzez.autofishingdeluxe.AutoFishingConfig;
import syzez.autofishingdeluxe.AutoFishingHandler;
import syzez.autofishingdeluxe.PushNotifications;

public final class TurboFishingManager {
    private static boolean active = false;
    private static boolean wasActiveLastTick = false;
    private static boolean triggeredByEnchant = false;
    private static int cooldown = 0;
    private static int timeoutTicks = 0;
    private static boolean ensureCastPending = false;
    private static int ensureDelay = 0;
    private static final String PROC_CHAT = "TOOLS \u00bb Your Turbo Fishing enchant has procced";
    private static final String END_CHAT = "The effects of your Turbo Fishing enchant have ended!";
    private static final String END_TITLE = "Enchant Finished";
    private static final String END_SUBTEXT = "The effects of your Turbo Fishing enchant have ended!";

    private TurboFishingManager() {
    }

    public static void register() {
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            String s = message.getString();
            if (TurboFishingManager.ciContains(s, PROC_CHAT)) {
                AutoFishingConfig cfg = AutoFishingHandler.getInstance().getConfig();
                if (cfg.enchantBehaviourEnabled) {
                    TurboFishingManager.start(true);
                }
            }
            if (TurboFishingManager.ciContains(s, "The effects of your Turbo Fishing enchant have ended!")) {
                TurboFishingManager.stopFromEnchant();
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            AutoFishingHandler handler;
            if (active) {
                handler = AutoFishingHandler.getInstance();
                if (handler == null || !handler.isFishingActive()) {
                    TurboFishingManager.stop(false);
                } else if (timeoutTicks > 0 && --timeoutTicks <= 0) {
                    TurboFishingManager.stop(false);
                }
            }
            if (wasActiveLastTick && !active && triggeredByEnchant) {
                handler = AutoFishingHandler.getInstance();
                if (handler != null && handler.isFishingActive() && !ensureCastPending) {
                    ensureCastPending = true;
                    ensureDelay = 40;
                }
                triggeredByEnchant = false;
            }
            if (ensureCastPending) {
                if (ensureDelay > 0) {
                    --ensureDelay;
                    TurboFishingManager.finishTick();
                    return;
                }
                handler = AutoFishingHandler.getInstance();
                if (handler == null || !handler.isFishingActive()) {
                    ensureCastPending = false;
                    TurboFishingManager.finishTick();
                    return;
                }
                if (!TurboFishingManager.isRodCasted(client)) {
                    handler.requestCastIfNoBobber();
                }
                ensureCastPending = false;
            }
            TurboFishingManager.finishTick();
        });
    }

    private static void finishTick() {
        wasActiveLastTick = active;
    }

    public static void start(boolean fromEnchant) {
        active = true;
        triggeredByEnchant = fromEnchant;
        PushNotifications.addNotification((class_2561)class_2561.method_43470((String)"AutoFishingDeluxe"), (class_2561)class_2561.method_43470((String)"Turbo Enchant Activated!"));
        cooldown = 0;
        timeoutTicks = 200;
        ensureCastPending = false;
        ensureDelay = 0;
    }

    public static void stop(boolean fromEnchant) {
        active = false;
        cooldown = 0;
        timeoutTicks = 0;
        ensureCastPending = false;
        ensureDelay = 0;
        if (!fromEnchant) {
            triggeredByEnchant = false;
        }
    }

    private static void stopFromEnchant() {
        boolean wasActive = active;
        active = false;
        cooldown = 0;
        timeoutTicks = 0;
        if (wasActive) {
            PushNotifications.addNotification((class_2561)class_2561.method_43470((String)"AutoFishingDeluxe"), (class_2561)class_2561.method_43470((String)"Turbo Enchant Stopped!"));
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static void tickTurbo(AutoFishingHandler handler) {
        if (!active) {
            return;
        }
        if (handler == null || !handler.isFishingActive()) {
            return;
        }
        if (handler.hasBobberOut()) {
            handler.requestReelThenRecast();
        } else {
            handler.requestRecast();
        }
    }

    public static void onSetTitle(String title) {
        if (title == null) {
            return;
        }
        String t = TurboFishingManager.normalize(title);
        if (TurboFishingManager.ciContains(t, END_TITLE)) {
            TurboFishingManager.stopFromEnchant();
            return;
        }
        String tl = t.toLowerCase();
        if (tl.contains("enchant") && tl.matches(".*\\b(end(?:ed)?|finish(?:ed)?)\\b.*")) {
            TurboFishingManager.stopFromEnchant();
        }
    }

    public static void onSetSubtitle(String subtitle) {
        if (subtitle == null) {
            return;
        }
        String s = TurboFishingManager.normalize(subtitle);
        if (TurboFishingManager.ciContains(s, "The effects of your Turbo Fishing enchant have ended!")) {
            TurboFishingManager.stopFromEnchant();
            return;
        }
        String sl = s.toLowerCase();
        if (sl.contains("turbo fishing") && sl.matches(".*\\b(end(?:ed)?|finish(?:ed)?)\\b.*")) {
            TurboFishingManager.stopFromEnchant();
        }
    }

    private static boolean isRodCasted(class_310 client) {
        return client != null && client.field_1724 != null && client.field_1724.field_7513 != null;
    }

    private static String normalize(String s) {
        if (s == null) {
            return "";
        }
        String stripped = s.replaceAll("\u00a7[0-9A-FK-ORa-fk-or]", "");
        return stripped.replace('\u00a0', ' ').replaceAll("\\s+", " ").trim();
    }

    private static boolean ciContains(String haystack, String needle) {
        return TurboFishingManager.normalize(haystack).toLowerCase().contains(TurboFishingManager.normalize(needle).toLowerCase());
    }
}

