/*
 * Decompiled with CFR 0.152.
 */
package syzez.autofishingdeluxe;

import java.util.Random;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_124;
import net.minecraft.class_1536;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import syzez.autofishingdeluxe.AutoFishingConfig;
import syzez.autofishingdeluxe.AutoFishingDeluxe;
import syzez.autofishingdeluxe.AutoFishingDetectionMethod;
import syzez.autofishingdeluxe.ConfigManager;
import syzez.autofishingdeluxe.Failsafes.FailsafeMacro;
import syzez.autofishingdeluxe.Failsafes.FailsafeSoundTrigger;
import syzez.autofishingdeluxe.Failsafes.Failsafe_Recast;
import syzez.autofishingdeluxe.Failsafes.Failsafe_Teleport;
import syzez.autofishingdeluxe.Failsafes.HeadRotateFailsafe;
import syzez.autofishingdeluxe.Failsafes.ItemSwapFailsafe;
import syzez.autofishingdeluxe.FishingRodChanger;
import syzez.autofishingdeluxe.MiniInventoryHud;
import syzez.autofishingdeluxe.OffhandRodSwapper;
import syzez.autofishingdeluxe.PushNotifications;
import syzez.autofishingdeluxe.SettingsScreen;
import syzez.autofishingdeluxe.TurboFishingManager;

public class AutoFishingHandler {
    private final class_310 client;
    private final Random random = new Random();
    private boolean isFishing = false;
    private boolean shouldRecast = false;
    private boolean isWaitingToReelIn = false;
    private int fishingTicks = 0;
    private int startFishingDelay = 15;
    private final AutoFishingConfig config;
    public boolean forceStopOnGuiOpen;
    public boolean mouseMovementEnabled;
    public boolean mouseUngrabEnabled;
    public int reelInDelayTicks;
    public int recastDelayTicks;
    public boolean pushNotificationsEnabled;
    public boolean textNotificationsEnabled;
    private int idleTicks = 0;
    private float initialYaw;
    private float initialPitch;
    private float smoothYawOffset = 0.0f;
    private float smoothPitchOffset = 0.0f;
    private float oscillationTime = 0.0f;
    private int ticksSinceLastCast = 0;
    private final int idleThresholdTicks = 800;
    private int movementTicks = 0;
    private boolean isPlayerIdle = false;
    private boolean isCrosshairMoving = false;
    private final class_304 toggleKeybind;
    private final class_304 openSettingsKeybind;
    private final FishingRodChanger fishingRodChanger;
    private boolean pausedByMacro = false;
    private int simulateUseKeyTicks = 0;
    private static AutoFishingHandler instance;

    public AutoFishingHandler() {
        this.client = class_310.method_1551();
        this.config = ConfigManager.loadConfig();
        this.fishingRodChanger = new FishingRodChanger();
        FailsafeMacro.initFromConfig(this.config);
        instance = this;
        MiniInventoryHud.loadFromConfig(this.config);
        this.forceStopOnGuiOpen = this.config.forceStopOnGuiOpen;
        this.mouseMovementEnabled = this.config.mouseMovementEnabled;
        this.mouseUngrabEnabled = this.config.mouseUngrabEnabled;
        this.reelInDelayTicks = this.config.reelInDelayTicks;
        this.recastDelayTicks = this.config.recastDelayTicks;
        this.pushNotificationsEnabled = this.config.pushNotificationsEnabled;
        this.textNotificationsEnabled = this.config.textNotificationsEnabled;
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        this.toggleKeybind = new class_304("Toggle AutoFishing", class_3675.class_307.field_1668, 75, "AutoFishingDeluxe");
        KeyBindingHelper.registerKeyBinding((class_304)this.toggleKeybind);
        this.openSettingsKeybind = new class_304("Open Settings", class_3675.class_307.field_1668, 79, "AutoFishingDeluxe");
        KeyBindingHelper.registerKeyBinding((class_304)this.openSettingsKeybind);
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (this.forceStopOnGuiOpen && this.isFishing && screen != null) {
                this.stopAutoFishingForGui();
            }
        });
    }

    public boolean isFishing() {
        return this.isFishing;
    }

    public boolean isWaitingToReelIn() {
        return this.isWaitingToReelIn;
    }

    public void setWaitingToReelIn(boolean isWaitingToReelIn) {
        this.isWaitingToReelIn = isWaitingToReelIn;
    }

    public void setFishingTicks(int fishingTicks) {
        this.fishingTicks = fishingTicks;
    }

    public AutoFishingConfig getConfig() {
        return this.config;
    }

    public void saveSettings() {
        this.config.forceStopOnGuiOpen = this.forceStopOnGuiOpen;
        this.config.mouseMovementEnabled = this.mouseMovementEnabled;
        this.config.mouseUngrabEnabled = this.mouseUngrabEnabled;
        this.config.reelInDelayTicks = this.reelInDelayTicks;
        this.config.recastDelayTicks = this.recastDelayTicks;
        FailsafeMacro.writeToConfig(this.config);
        ConfigManager.saveConfig(this.config);
    }

    private void onClientTick(class_310 client) {
        if (this.toggleKeybind.method_1436()) {
            this.toggleAutoFishing();
        }
        if (this.openSettingsKeybind.method_1436()) {
            client.method_1507((class_437)new SettingsScreen(client.field_1755));
        }
        if (this.forceStopOnGuiOpen && client.field_1755 != null) {
            this.stopAutoFishingForGui();
            return;
        }
        if (this.isFishing) {
            if (this.simulateUseKeyTicks > 0) {
                client.field_1690.field_1904.method_23481(true);
                --this.simulateUseKeyTicks;
            } else {
                client.field_1690.field_1904.method_23481(false);
            }
        }
        if (this.isFishing && client.field_1724 != null) {
            this.checkFishingRodDurability();
            if (this.config.itemSwapFailsafeEnabled) {
                ItemSwapFailsafe.checkFailsafe();
            }
            if (this.getConfig().enchantBehaviourEnabled && TurboFishingManager.isActive()) {
                TurboFishingManager.tickTurbo(this);
                return;
            }
            if (OffhandRodSwapper.isEnabled()) {
                ++OffhandRodSwapper.tickDelay;
                ++this.fishingTicks;
                switch (OffhandRodSwapper.currentState) {
                    case READY: {
                        if (client.field_1724.method_6047().method_7909() != class_1802.field_8378 || this.fishingTicks < this.recastDelayTicks + this.random.nextInt(11)) break;
                        this.reelInFishingRod();
                        OffhandRodSwapper.currentState = OffhandRodSwapper.State.WAIT_BEFORE_SWAP;
                        OffhandRodSwapper.tickDelay = 0;
                        this.fishingTicks = 0;
                        break;
                    }
                    case WAIT_BEFORE_SWAP: {
                        if (OffhandRodSwapper.tickDelay < 40) break;
                        OffhandRodSwapper.swapHands(client);
                        OffhandRodSwapper.currentState = OffhandRodSwapper.State.WAITING_FOR_BITE;
                        OffhandRodSwapper.tickDelay = 0;
                        break;
                    }
                    case WAITING_FOR_BITE: {
                        if (!this.isFishOnLine(client.field_1724.field_7513)) break;
                        OffhandRodSwapper.currentState = OffhandRodSwapper.State.REELING;
                        OffhandRodSwapper.tickDelay = 0;
                        this.fishingTicks = 0;
                        this.isWaitingToReelIn = true;
                        break;
                    }
                    case REELING: {
                        if (!this.isWaitingToReelIn || this.fishingTicks < this.reelInDelayTicks + this.random.nextInt(11)) break;
                        this.reelInFishingRod();
                        OffhandRodSwapper.currentState = OffhandRodSwapper.State.WAIT_BEFORE_SWAP_BACK;
                        OffhandRodSwapper.tickDelay = 0;
                        this.fishingTicks = 0;
                        this.isWaitingToReelIn = false;
                        break;
                    }
                    case WAIT_BEFORE_SWAP_BACK: {
                        if (OffhandRodSwapper.tickDelay < 10) break;
                        OffhandRodSwapper.swapHands(client);
                        OffhandRodSwapper.currentState = OffhandRodSwapper.State.WAIT_BEFORE_RECAST;
                        OffhandRodSwapper.tickDelay = 0;
                        break;
                    }
                    case WAIT_BEFORE_RECAST: {
                        if (OffhandRodSwapper.tickDelay < 10) break;
                        OffhandRodSwapper.currentState = OffhandRodSwapper.State.READY;
                        OffhandRodSwapper.tickDelay = 0;
                        this.ticksSinceLastCast = 0;
                        this.fishingTicks = 0;
                    }
                }
                return;
            }
            if (FailsafeMacro.tick(this)) {
                return;
            }
            if (this.pausedByMacro) {
                return;
            }
            if (this.startFishingDelay > 0) {
                --this.startFishingDelay;
                return;
            }
            if (this.mouseMovementEnabled) {
                this.checkPlayerIdle();
                if (this.isCrosshairMoving) {
                    int maxMovementDurationTicks = 100;
                    if (this.movementTicks < maxMovementDurationTicks) {
                        this.smoothCrosshairMovement();
                        ++this.movementTicks;
                    } else {
                        this.stopCrosshairMovement();
                        this.idleTicks = 0;
                    }
                } else if (this.isPlayerIdle && this.idleTicks >= 800) {
                    this.startCrosshairMovement();
                }
            }
            class_1536 bobber = client.field_1724.field_7513;
            ++this.fishingTicks;
            ++this.ticksSinceLastCast;
            if (bobber != null && bobber.field_6012 <= 2) {
                this.ticksSinceLastCast = 0;
            }
            if (this.shouldRecast) {
                if (this.fishingTicks >= this.recastDelayTicks + this.random.nextInt(11)) {
                    this.reelInFishingRod();
                    this.shouldRecast = false;
                    this.fishingTicks = 0;
                    this.ticksSinceLastCast = 0;
                }
                return;
            }
            if (this.isWaitingToReelIn) {
                if (this.fishingTicks >= this.reelInDelayTicks + this.random.nextInt(11)) {
                    this.reelInFishingRod();
                    this.isWaitingToReelIn = false;
                    this.shouldRecast = true;
                    this.fishingTicks = 0;
                }
                return;
            }
            if (this.fishingTicks > 40 && this.isFishOnLine(bobber)) {
                this.isWaitingToReelIn = true;
                this.fishingTicks = 0;
                this.ticksSinceLastCast = 0;
            }
            if (this.config.teleportFailsafeEnabled) {
                Failsafe_Teleport.tick();
            }
            if (this.config.recastFailsafeEnabled) {
                Failsafe_Recast.tick(this);
            }
            if (this.config.headRotateFailsafeEnabled) {
                HeadRotateFailsafe.tick(this);
            }
        }
    }

    public void playStopAlertSound() {
        FailsafeSoundTrigger.playFromConfig(this.config);
    }

    private void checkPlayerIdle() {
        if (this.client.field_1724 != null) {
            if (this.client.field_1724.field_6250 == 0.0f && this.client.field_1724.field_6212 == 0.0f && !this.client.field_1724.method_6115()) {
                ++this.idleTicks;
            } else {
                this.idleTicks = 0;
                this.stopCrosshairMovement();
            }
            this.isPlayerIdle = this.idleTicks >= 800;
        }
    }

    private void startCrosshairMovement() {
        this.isCrosshairMoving = true;
        this.movementTicks = 0;
        this.oscillationTime = 0.0f;
        HeadRotateFailsafe.suppressForTicks(100);
    }

    private void stopCrosshairMovement() {
        this.isCrosshairMoving = false;
        this.movementTicks = 0;
        this.smoothYawOffset = 0.0f;
        this.smoothPitchOffset = 0.0f;
        if (this.client.field_1724 != null) {
            this.client.field_1724.method_36456(this.initialYaw);
            this.client.field_1724.method_36457(this.initialPitch);
        }
    }

    private void toggleAutoFishing() {
        if (this.isFishing) {
            this.stopAutoFishing();
            this.sendChatMessage((class_2561)class_2561.method_43470((String)"Stopped!").method_27692(class_124.field_1061));
            PushNotifications.addNotification((class_2561)class_2561.method_43470((String)"AutoFishingDeluxe"), (class_2561)class_2561.method_43470((String)"Stopped!"));
            if (this.mouseUngrabEnabled && this.client.field_1755 == null) {
                this.client.field_1729.method_1612();
            }
        } else {
            this.startAutoFishing();
            this.sendChatMessage((class_2561)class_2561.method_43470((String)"Started!").method_27692(class_124.field_1060));
            PushNotifications.addNotification((class_2561)class_2561.method_43470((String)"AutoFishingDeluxe"), (class_2561)class_2561.method_43470((String)"Started!"));
            if (this.mouseUngrabEnabled) {
                this.client.field_1729.method_1610();
            }
        }
    }

    public void startAutoFishing() {
        if (!this.isFishing) {
            this.isFishing = true;
            this.startFishingDelay = 10;
            this.fishingTicks = 0;
            assert (this.client.field_1724 != null);
            this.initialYaw = this.client.field_1724.method_36454();
            this.initialPitch = this.client.field_1724.method_36455();
            this.oscillationTime = 0.0f;
            ItemSwapFailsafe.startTracking();
            Failsafe_Teleport.reset();
            HeadRotateFailsafe.onStart(this);
        }
    }

    public void stopAutoFishing() {
        if (this.isFishing) {
            this.isFishing = false;
            this.shouldRecast = false;
            this.isWaitingToReelIn = false;
            this.fishingTicks = 0;
            this.simulateUseKeyTicks = 0;
            this.client.field_1690.field_1904.method_23481(false);
            this.pausedByMacro = false;
            ItemSwapFailsafe.stopTracking();
            OffhandRodSwapper.reset();
            Failsafe_Teleport.reset();
            Failsafe_Recast.reset();
            HeadRotateFailsafe.reset();
        }
    }

    private void stopAutoFishingForGui() {
        if (this.isFishing) {
            this.isFishing = false;
            this.shouldRecast = false;
            this.isWaitingToReelIn = false;
            this.fishingTicks = 0;
            this.simulateUseKeyTicks = 0;
            this.client.field_1690.field_1904.method_23481(false);
            this.pausedByMacro = false;
            ItemSwapFailsafe.stopTracking();
            OffhandRodSwapper.reset();
            Failsafe_Teleport.reset();
            Failsafe_Recast.reset();
            HeadRotateFailsafe.reset();
            this.playStopAlertSound();
            this.sendChatMessage((class_2561)class_2561.method_43470((String)"Stopped due to GUI open!").method_27692(class_124.field_1061));
            PushNotifications.addNotification((class_2561)class_2561.method_43470((String)"AutoFishingDeluxe"), (class_2561)class_2561.method_43470((String)"Stopped due to GUI open!"));
        }
    }

    public void triggerFailsafe(String reason) {
        this.stopAutoFishing();
        this.playStopAlertSound();
        this.simulateUseKeyTicks = 0;
        this.client.field_1690.field_1904.method_23481(false);
        this.pausedByMacro = false;
        ItemSwapFailsafe.stopTracking();
        OffhandRodSwapper.reset();
        Failsafe_Teleport.reset();
        Failsafe_Recast.reset();
        this.sendChatMessage((class_2561)class_2561.method_43470((String)("Stopped due to " + reason + "!")).method_27692(class_124.field_1061));
        PushNotifications.addNotification((class_2561)class_2561.method_43470((String)"AutoFishingDeluxe"), (class_2561)class_2561.method_43470((String)("Stopped due to " + reason + "!")));
    }

    private boolean isPlayerHoldingFishingRod() {
        assert (this.client.field_1724 != null);
        return this.client.field_1724.method_6047().method_7909() == class_1802.field_8378;
    }

    public boolean isFishOnLine(class_1536 bobber) {
        return AutoFishingDetectionMethod.shouldReelIn(bobber);
    }

    public void setShouldRecast(boolean value) {
        this.shouldRecast = value;
    }

    public int getTicksSinceLastCast() {
        return this.ticksSinceLastCast;
    }

    public boolean isFishingActive() {
        return this.isFishing;
    }

    public void reelInFishingRod() {
        if (this.client.field_1724 != null && this.isPlayerHoldingFishingRod()) {
            float playerYaw = this.client.field_1724.method_36454();
            float playerPitch = this.client.field_1724.method_36455();
            this.simulateUseKeyTicks = 2;
            Failsafe_Recast.reset();
        }
    }

    public void sendChatMessage(class_2561 message) {
        if (!this.config.textNotificationsEnabled) {
            return;
        }
        if (this.client.field_1724 != null) {
            class_5250 prefix = class_2561.method_43470((String)"AFD: ").method_27695(new class_124[]{class_124.field_1067, class_124.field_1058});
            class_5250 formattedMessage = message.method_27661().method_27692(class_124.field_1056);
            class_5250 completeMessage = class_2561.method_43473().method_10852((class_2561)prefix).method_10852((class_2561)formattedMessage);
            this.client.field_1724.method_7353((class_2561)completeMessage, false);
        }
    }

    private void smoothCrosshairMovement() {
        if (this.client.field_1724 != null) {
            this.oscillationTime += 1.0f;
            float yawOscillationSpeed = 0.02f;
            float maxYawAmplitude = 0.8f;
            this.smoothYawOffset = (float)Math.sin(this.oscillationTime * yawOscillationSpeed) * maxYawAmplitude;
            float pitchOscillationSpeed = 0.015f;
            float maxPitchAmplitude = 0.5f;
            this.smoothPitchOffset = (float)Math.cos(this.oscillationTime * pitchOscillationSpeed) * maxPitchAmplitude;
            this.client.field_1724.method_36456(this.initialYaw + this.smoothYawOffset);
            this.client.field_1724.method_36457(this.initialPitch + this.smoothPitchOffset);
        }
    }

    private void checkFishingRodDurability() {
        if (this.client.field_1724 != null && this.client.field_1724.method_6047().method_7909() == class_1802.field_8378) {
            int maxDamage = this.client.field_1724.method_6047().method_7936();
            int currentDamage = this.client.field_1724.method_6047().method_7919();
            if (this.config.breakProtectionFailsafeEnabled && (double)currentDamage >= (double)maxDamage * 0.95) {
                if (this.config.fishingRodAutoSwapEnabled) {
                    AutoFishingDeluxe.LOGGER.info("[AutoFishingHandler] Fishing rod durability low, attempting swap...");
                    boolean swapped = this.fishingRodChanger.swapToAnotherRod();
                    if (swapped) {
                        String message = "Swapped fishing rod!";
                        this.sendChatMessage((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1054));
                        PushNotifications.addNotification((class_2561)class_2561.method_43470((String)"AutoFishingDeluxe"), (class_2561)class_2561.method_43470((String)message));
                        return;
                    }
                }
                this.stopAutoFishing();
                this.playStopAlertSound();
                String message = "Stopped! No spare fishing rod found!";
                this.sendChatMessage((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1061));
                PushNotifications.addNotification((class_2561)class_2561.method_43470((String)"AutoFishingDeluxe"), (class_2561)class_2561.method_43470((String)message));
            }
        }
    }

    public static AutoFishingHandler getInstance() {
        return instance;
    }

    public void onMyBobberSplash() {
        AutoFishingDetectionMethod.SoundGate.markMySplash();
        if (!this.isFishing) {
            return;
        }
        if (OffhandRodSwapper.isEnabled() && this.ticksSinceLastCast >= 15 && OffhandRodSwapper.currentState == OffhandRodSwapper.State.WAITING_FOR_BITE) {
            OffhandRodSwapper.currentState = OffhandRodSwapper.State.REELING;
            OffhandRodSwapper.tickDelay = 0;
            this.fishingTicks = 0;
            this.isWaitingToReelIn = true;
        }
    }

    public void pauseForMacro() {
        this.pausedByMacro = true;
        this.simulateUseKeyTicks = 0;
        this.client.field_1690.field_1904.method_23481(false);
        this.shouldRecast = false;
        this.isWaitingToReelIn = false;
        this.fishingTicks = 0;
        this.ticksSinceLastCast = 0;
        OffhandRodSwapper.reset();
        ItemSwapFailsafe.stopTracking();
        Failsafe_Teleport.reset();
    }

    public void prepareAfterMacroReactivate() {
        this.startFishingDelay = 10;
        this.fishingTicks = 0;
        this.ticksSinceLastCast = 0;
        this.shouldRecast = false;
        this.isWaitingToReelIn = false;
        ItemSwapFailsafe.startTracking();
        Failsafe_Teleport.reset();
        OffhandRodSwapper.reset();
    }

    public void resumeFromMacro() {
        this.pausedByMacro = false;
    }

    public void simulateOneCast() {
        if (this.client.field_1724 != null && this.isPlayerHoldingFishingRod()) {
            this.simulateUseKeyTicks = 2;
        }
    }

    public boolean hasBobberOut() {
        return this.client.field_1724 != null && this.client.field_1724.field_7513 != null;
    }

    public boolean isBobberInLiquid() {
        if (this.client.field_1724 == null || this.client.field_1724.field_7513 == null) {
            return false;
        }
        class_1536 b = this.client.field_1724.field_7513;
        return b.method_5721() || !b.method_37908().method_8316(b.method_24515()).method_15769();
    }
}

