/*
 * Decompiled with CFR 0.152.
 */
package syzez.autofishingdeluxe;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import syzez.autofishingdeluxe.AutoFishingHandler;

public class PushNotifications {
    private static final List<Notification> notifications = new ArrayList<Notification>();
    private static final int DISPLAY_TIME = 250;
    private static final int SLIDE_DURATION = 25;
    private static AutoFishingHandler handler;

    public static void initialize(AutoFishingHandler handlerInstance) {
        handler = handlerInstance;
    }

    public static void addNotification(class_2561 title, class_2561 description) {
        if (handler == null || !PushNotifications.handler.getConfig().pushNotificationsEnabled) {
            return;
        }
        notifications.add(new Notification(title, description, 275));
    }

    public static void render(class_332 drawContext, int windowWidth, int windowHeight) {
        if (handler == null || !PushNotifications.handler.getConfig().pushNotificationsEnabled) {
            return;
        }
        int baseX = windowWidth - 140;
        int baseY = 20;
        for (int i = 0; i < notifications.size(); ++i) {
            Notification notification = notifications.get(i);
            if (notification.timeLeft <= 0) {
                notifications.remove(i--);
                continue;
            }
            int boxWidth = 108;
            int boxHeight = 24;
            int offsetX = PushNotifications.calculateSlideOffset(notification.timeLeft, 25, boxWidth);
            PushNotifications.drawFadingBackground(drawContext, baseX + offsetX, baseY + i * (boxHeight + 8), boxWidth, boxHeight);
            int descriptionColor = PushNotifications.getDescriptionColor(notification.description.getString());
            int titleColor = -1;
            class_327 textRenderer = class_310.method_1551().field_1772;
            int titleWidth = textRenderer.method_27525((class_5348)notification.title.method_27661().method_27692(class_124.field_1067));
            int centeredTitleX = baseX + offsetX + (boxWidth - titleWidth) / 2;
            int descriptionWidth = textRenderer.method_27525((class_5348)notification.description.method_27661().method_27692(class_124.field_1067));
            int centeredDescriptionX = baseX + offsetX + (boxWidth - descriptionWidth) / 2;
            drawContext.method_51439(textRenderer, (class_2561)notification.title.method_27661().method_27692(class_124.field_1067), centeredTitleX, baseY + i * (boxHeight + 8) + 3, titleColor, false);
            drawContext.method_51439(textRenderer, (class_2561)notification.description.method_27661().method_27692(class_124.field_1067), centeredDescriptionX, baseY + i * (boxHeight + 8) + 15, descriptionColor, false);
            int lineStartX = centeredTitleX;
            int lineEndX = centeredTitleX + titleWidth;
            int lineY = baseY + i * (boxHeight + 8) + 12;
            drawContext.method_25294(lineStartX, lineY, lineEndX, lineY + 1, 0x26CCCCCC);
            --notification.timeLeft;
        }
    }

    private static void drawFadingBackground(class_332 drawContext, int x, int y, int width, int height) {
        int startColor = 0x66000000;
        int endColor = 0;
        drawContext.method_25296(x, y, x + width, y + height, startColor, endColor);
    }

    private static int getDescriptionColor(String description) {
        String desc = description.toLowerCase();
        if (desc.contains("failsafe") || desc.contains("stopped") || desc.contains("error") || desc.contains("missing") || desc.contains("low durability") || desc.contains("durability low")) {
            return -5636096;
        }
        if (desc.contains("swap") || desc.contains("alert") || desc.contains("warning")) {
            return -256;
        }
        if (desc.contains("started") || desc.contains("resumed") || desc.contains("activated")) {
            return -16733696;
        }
        return 0xFFFFFF;
    }

    private static int calculateSlideOffset(int timeLeft, int slideDuration, int boxWidth) {
        if (timeLeft > 250 - slideDuration) {
            float progress = (float)(250 - timeLeft) / (float)slideDuration;
            return (int)((1.0f - progress) * (float)boxWidth);
        }
        if (timeLeft <= slideDuration) {
            float progress = (float)(slideDuration - timeLeft) / (float)slideDuration;
            return (int)(progress * (float)boxWidth);
        }
        return 0;
    }

    private static class Notification {
        final class_2561 title;
        final class_2561 description;
        int timeLeft;

        Notification(class_2561 title, class_2561 description, int timeLeft) {
            this.title = title;
            this.description = description;
            this.timeLeft = timeLeft;
        }
    }
}

