/*
 * Decompiled with CFR 0.152.
 */
package syzez.autofishingdeluxe;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import syzez.autofishingdeluxe.AutoFishingConfig;
import syzez.autofishingdeluxe.AutoFishingDeluxe;
import syzez.autofishingdeluxe.AutoFishingDetectionMethod;
import syzez.autofishingdeluxe.AutoFishingHandler;
import syzez.autofishingdeluxe.EditMiniHud;
import syzez.autofishingdeluxe.Failsafes.FailsafeMacro;
import syzez.autofishingdeluxe.MiniInventoryHud;
import syzez.autofishingdeluxe.ToggleCategoryButton;

public class SettingsScreen
extends class_437 {
    private final class_437 previousScreen;
    private final Deque<MenuState> menuHistory = new ArrayDeque<MenuState>();
    private MenuState current = MenuState.MAIN;
    private static final int BTN_W = 140;
    private static final int BTN_H = 20;
    private static final int GAP = 8;
    private static final int STEPPER_W = 36;
    private static final int STEPPER_H = 16;
    private static final int STEPPER_GAP = 6;
    private static final int COL_GAP = 24;
    private class_327 tr;
    private ToggleCategoryButton detectionToggleButton;
    private ToggleCategoryButton velocityLabelBtn;
    private ToggleCategoryButton soundLabelBtn;
    private float toggleProgress = 0.0f;
    private float animTarget = 0.0f;
    private boolean animating = false;
    private float pressPulse = 0.0f;
    private class_342 macroInput;
    private class_342 reactivateDelayField;
    private static final int[] HUD_BORDER_COLORS = new int[]{0xFFFFFF, 65535, 65280, 0xFFFF00, 16753920, 0xFF0000, 0xFF00FF, 0x800080, 33023, 10133670};

    public SettingsScreen(class_437 previousScreen) {
        super((class_2561)class_2561.method_43470((String)""));
        this.previousScreen = previousScreen;
    }

    private void clearPage() {
        this.method_37067();
        this.method_25395(null);
        this.detectionToggleButton = null;
        this.toggleProgress = AutoFishingDetectionMethod.getCurrentMethod() == AutoFishingDetectionMethod.Method.SOUND ? 1.0f : 0.0f;
    }

    protected void method_25426() {
        this.tr = this.field_22793;
        super.method_25426();
        this.clearPage();
        switch (this.current.ordinal()) {
            case 0: {
                this.buildMain();
                break;
            }
            case 1: {
                this.buildFishing();
                break;
            }
            case 8: {
                this.buildFishingMethod();
                break;
            }
            case 2: {
                this.buildFailsafes();
                break;
            }
            case 3: {
                this.buildFailsafeMacro();
                break;
            }
            case 4: {
                this.buildGUI();
                break;
            }
            case 5: {
                this.buildSound();
                break;
            }
            case 6: {
                this.buildMisc();
                break;
            }
            case 7: {
                this.buildAdvanced();
            }
        }
        this.addBackButton();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, 0x66000000);
        super.method_25394(context, mouseX, mouseY, delta);
        int titleX = (this.field_22789 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
        context.method_51439(this.field_22793, this.field_22785, titleX, 20, -2039584, false);
        if (this.detectionToggleButton != null) {
            if (this.animating) {
                float step = 0.18f;
                this.toggleProgress += (this.animTarget - this.toggleProgress) * step;
                if (Math.abs(this.animTarget - this.toggleProgress) < 0.003f) {
                    this.toggleProgress = this.animTarget;
                    this.animating = false;
                }
            }
            float p = this.toggleProgress;
            float t = p * p * (3.0f - 2.0f * p);
            int x = this.detectionToggleButton.method_46426();
            int y = this.detectionToggleButton.method_46427();
            int w = this.detectionToggleButton.method_25368();
            int h = this.detectionToggleButton.method_25364();
            context.method_25294(x, y, x + w, y + h, -16777216);
            int sliderW = w / 2;
            int sliderX = x + Math.round(t * (float)sliderW);
            int sliderColor = t < 0.5f ? -16777077 : -13625036;
            int glowColor = t < 0.5f ? -15066369 : -11199861;
            context.method_25294(sliderX - 1, y - 1, sliderX + sliderW + 1, y + h + 1, glowColor);
            context.method_25294(sliderX, y, sliderX + sliderW, y + h, sliderColor);
            context.method_49601(x, y, w, h, -11184811);
            if (this.velocityLabelBtn != null && this.soundLabelBtn != null) {
                int vx = this.velocityLabelBtn.method_46426();
                int vy = this.velocityLabelBtn.method_46427();
                int vw = this.velocityLabelBtn.method_25368();
                int vh = this.velocityLabelBtn.method_25364();
                int sx = this.soundLabelBtn.method_46426();
                int sy = this.soundLabelBtn.method_46427();
                int sw = this.soundLabelBtn.method_25368();
                int sh = this.soundLabelBtn.method_25364();
                int velA = (int)((1.0f - t) * (1.0f - t) * 255.0f);
                int sndA = (int)(t * t * 255.0f);
                if (velA > 0) {
                    this.drawRoundedOutline(context, vx - 1, vy - 1, vw + 2, vh + 2, velA << 24 | 0x1A1AFF);
                }
                if (sndA > 0) {
                    this.drawRoundedOutline(context, sx - 1, sy - 1, sw + 2, sh + 2, sndA << 24 | 0x551A8B);
                }
                int glowW = Math.max(vw, sw) + 6;
                int glowH = vh + 6;
                float fromX = (float)(vx - 3) + (float)vw / 2.0f - (float)glowW / 2.0f;
                float toX = (float)(sx - 3) + (float)sw / 2.0f - (float)glowW / 2.0f;
                int gx = Math.round(fromX + (toX - fromX) * t);
                int gy = vy - 3;
                int travelingGlow = (int)(80.0 * Math.sin(Math.PI * (double)t)) << 24 | 0x551A8B;
                context.method_25294(gx, gy, gx + glowW, gy + glowH, travelingGlow);
                if (this.pressPulse > 0.0f && this.velocityLabelBtn != null && this.soundLabelBtn != null) {
                    int baseGlow;
                    int bh;
                    int bw;
                    int by;
                    int bx;
                    boolean pulseRight;
                    this.pressPulse = Math.max(0.0f, this.pressPulse - 0.08f);
                    boolean bl = pulseRight = this.animTarget >= 0.5f;
                    if (pulseRight) {
                        bx = this.soundLabelBtn.method_46426();
                        by = this.soundLabelBtn.method_46427();
                        bw = this.soundLabelBtn.method_25368();
                        bh = this.soundLabelBtn.method_25364();
                        baseGlow = 5577355;
                    } else {
                        bx = this.velocityLabelBtn.method_46426();
                        by = this.velocityLabelBtn.method_46427();
                        bw = this.velocityLabelBtn.method_25368();
                        bh = this.velocityLabelBtn.method_25364();
                        baseGlow = 0x1A1AFF;
                    }
                    int expand = (int)Math.ceil(3.0f * this.pressPulse);
                    int a1 = (int)(120.0f * this.pressPulse);
                    int a2 = (int)(70.0f * this.pressPulse);
                    int a3 = (int)(30.0f * this.pressPulse);
                    int c1 = a1 << 24 | baseGlow;
                    int c2 = a2 << 24 | baseGlow;
                    int c3 = a3 << 24 | baseGlow;
                    this.drawRoundedOutline(context, bx - 1, by - 1, bw + 2, bh + 2, c1);
                    this.drawRoundedOutline(context, bx - 1 - expand, by - 1 - expand, bw + 2 + 2 * expand, bh + 2 + 2 * expand, c2);
                    this.drawRoundedOutline(context, bx - 2 - expand, by - 2 - expand, bw + 4 + 2 * expand, bh + 4 + 2 * expand, c3);
                }
            }
        }
    }

    private void drawRoundedOutline(class_332 ctx, int x, int y, int width, int height, int color) {
        int r = height / 2;
        ctx.method_25294(x + r, y, x + width - r, y + 1, color);
        ctx.method_25294(x + r, y + height - 1, x + width - r, y + height, color);
        for (int i = 0; i < r; ++i) {
            int dy = r - i;
            ctx.method_25294(x + i, y + dy - 1, x + i + 1, y + dy, color);
            ctx.method_25294(x + width - i - 1, y + dy - 1, x + width - i, y + dy, color);
            ctx.method_25294(x + i, y + height - dy, x + i + 1, y + height - dy + 1, color);
            ctx.method_25294(x + width - i - 1, y + height - dy, x + width - i, y + height - dy + 1, color);
        }
        ctx.method_25294(x, y + r - 1, x + 1, y + height - r + 1, color);
        ctx.method_25294(x + width - 1, y + r - 1, x + width, y + height - r + 1, color);
    }

    private int centerX(int w) {
        return (this.field_22789 - w) / 2;
    }

    private int columnTop() {
        return this.field_22790 / 4;
    }

    private int addUIButton(class_2561 label, Runnable onClick, int y) {
        ToggleCategoryButton b = new ToggleCategoryButton(this.centerX(140), y, 140, 20, label, this.tr, btn -> onClick.run(), false);
        this.method_37063((class_364)b);
        return y + 20 + 8;
    }

    private int addUIToggle(class_2561 label, boolean isOn, Runnable onClick, int y) {
        ToggleCategoryButton b = new ToggleCategoryButton(this.centerX(140), y, 140, 20, label, this.tr, btn -> onClick.run(), isOn);
        this.method_37063((class_364)b);
        return y + 20 + 8;
    }

    private void addStepperButton(String label, int x, int y, Runnable onClick) {
        ToggleCategoryButton b = new ToggleCategoryButton(x, y, 36, 16, (class_2561)class_2561.method_43470((String)label), this.tr, btn -> onClick.run(), false);
        this.method_37063((class_364)b);
    }

    private int addStepperUnder(String prefix, String unit, IntSupplier getter, IntConsumer setter, int min, int max, int y) {
        return this.addStepperUnder(prefix, unit, getter, setter, min, max, 1, y);
    }

    private int addStepperUnder(String prefix, String unit, IntSupplier getter, IntConsumer setter, int min, int max, int step, int y) {
        ToggleCategoryButton label = new ToggleCategoryButton(this.centerX(140), y, 140, 20, (class_2561)class_2561.method_43470((String)(prefix + ": " + getter.getAsInt() + unit)), this.tr, btn -> {}, false);
        label.field_22763 = false;
        this.method_37063((class_364)label);
        int rowWidth = 78;
        int rowX = this.centerX(140) + (140 - rowWidth) / 2;
        int stepY = y + 20 + 2;
        this.addStepperButton("\u2013", rowX, stepY, () -> {
            int v = Math.max(min, getter.getAsInt() - step);
            setter.accept(v);
            label.method_25355((class_2561)class_2561.method_43470((String)(prefix + ": " + v + unit)));
        });
        this.addStepperButton("+", rowX + 36 + 6, stepY, () -> {
            int v = Math.min(max, getter.getAsInt() + step);
            setter.accept(v);
            label.method_25355((class_2561)class_2561.method_43470((String)(prefix + ": " + v + unit)));
        });
        return stepY + 16 + 8;
    }

    private int addStepperUnderAt(int baseX, String prefix, String unit, IntSupplier getter, IntConsumer setter, int max, int y) {
        ToggleCategoryButton label = new ToggleCategoryButton(baseX, y, 140, 20, (class_2561)class_2561.method_43470((String)(prefix + ": " + getter.getAsInt() + unit)), this.tr, btn -> {}, false);
        label.field_22763 = false;
        this.method_37063((class_364)label);
        int rowWidth = 78;
        int rowX = baseX + (140 - rowWidth) / 2;
        int stepY = y + 20 + 2;
        this.addStepperButton("\u2013", rowX, stepY, () -> {
            int v = Math.max(0, getter.getAsInt() - 1);
            setter.accept(v);
            label.method_25355((class_2561)class_2561.method_43470((String)(prefix + ": " + v + unit)));
        });
        this.addStepperButton("+", rowX + 36 + 6, stepY, () -> {
            int v = Math.min(max, getter.getAsInt() + 1);
            setter.accept(v);
            label.method_25355((class_2561)class_2561.method_43470((String)(prefix + ": " + v + unit)));
        });
        return stepY + 16 + 8;
    }

    private void push(MenuState next) {
        this.menuHistory.push(this.current);
        this.current = next;
        this.clearPage();
        this.method_25426();
    }

    private void popOrExit() {
        if (!this.menuHistory.isEmpty()) {
            this.current = this.menuHistory.pop();
            this.clearPage();
            this.method_25426();
        } else if (this.field_22787 != null) {
            this.field_22787.method_1507(this.previousScreen);
        }
    }

    private void addBackButton() {
        ToggleCategoryButton back = new ToggleCategoryButton(12, this.field_22790 - 28, 90, 20, (class_2561)class_2561.method_43470((String)"Back"), this.tr, btn -> this.popOrExit(), false);
        this.method_37063((class_364)back);
        int w = 90;
        int h = 20;
        int margin = 12;
        int x = this.field_22789 - margin - w;
        int y = this.field_22790 - 28;
        ToggleCategoryButton discord = new ToggleCategoryButton(x, y, w, h, (class_2561)class_2561.method_43470((String)"Discord"), this.tr, btn -> {
            String url = "https://discord.gg/6HA4vSDz6q";
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new class_407(confirmed -> {
                    if (confirmed) {
                        class_156.method_668().method_670(url);
                    }
                    this.field_22787.method_1507((class_437)this);
                }, url, true));
            }
        }, false);
        this.method_37063((class_364)discord);
    }

    private void buildMain() {
        int y = this.columnTop();
        y = this.addUIButton((class_2561)class_2561.method_43470((String)"Fishing"), () -> this.push(MenuState.FISHING), y);
        y = this.addUIButton((class_2561)class_2561.method_43470((String)"GUI"), () -> this.push(MenuState.GUI), y);
        y = this.addUIButton((class_2561)class_2561.method_43470((String)"Sound"), () -> this.push(MenuState.SOUND), y);
        y = this.addUIButton((class_2561)class_2561.method_43470((String)"Misc"), () -> this.push(MenuState.MISC), y);
        ToggleCategoryButton advBtn = new ToggleCategoryButton(this.centerX(140), y, 140, 20, (class_2561)class_2561.method_43470((String)"Advanced"), this.tr, btn -> this.push(MenuState.ADVANCED), false);
        advBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Check Discord for proper instructions and details")));
        this.method_37063((class_364)advBtn);
        y += 28;
    }

    private void buildFishing() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        int y = this.columnTop();
        ToggleCategoryButton fishingMethodBtn = new ToggleCategoryButton(this.centerX(140), y, 140, 20, (class_2561)class_2561.method_43470((String)"Fishing Method"), this.tr, btn -> this.push(MenuState.FISHING_METHOD), false);
        fishingMethodBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Changes the way AutoFishing detects fishes/hooks")));
        this.method_37063((class_364)fishingMethodBtn);
        y += 28;
        y = this.addUIButton((class_2561)class_2561.method_43470((String)"Failsafes"), () -> this.push(MenuState.FAILSAFES), y);
        ToggleCategoryButton macroBtn = new ToggleCategoryButton(this.centerX(140), y, 140, 20, (class_2561)class_2561.method_43470((String)"Failsafe Macro"), this.tr, btn -> this.push(MenuState.FAILSAFESMACRO), false);
        macroBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Change actions after certain Failsafe triggers")));
        this.method_37063((class_364)macroBtn);
        y += 28;
        int blockW = 304;
        int leftX = (this.field_22789 - blockW) / 2;
        int rightX = leftX + 140 + 24;
        int yL = this.addStepperUnderAt(leftX, "Reel-in Delay", " ticks", () -> handler.reelInDelayTicks, v -> {
            handler.reelInDelayTicks = v;
            handler.saveSettings();
        }, 80, y += 12);
        int yR = this.addStepperUnderAt(rightX, "Recast Delay", " ticks", () -> handler.recastDelayTicks, v -> {
            handler.recastDelayTicks = v;
            handler.saveSettings();
        }, 80, y);
        y = Math.max(yL, yR);
    }

    private void buildFishingMethod() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        this.animTarget = this.toggleProgress = AutoFishingDetectionMethod.getCurrentMethod() == AutoFishingDetectionMethod.Method.SOUND ? 1.0f : 0.0f;
        this.animating = false;
        this.pressPulse = 0.0f;
        int buttonHeight = 20;
        int labelWidth = 55;
        int toggleWidth = 50;
        int gap = 15;
        int totalWidth = 190;
        int startX = (this.field_22789 - 190) / 2;
        int y = this.field_22790 / 4;
        int toggleX = startX + 55 + 15;
        int soundX = toggleX + 50 + 15;
        this.velocityLabelBtn = new ToggleCategoryButton(startX, y, 55, 20, (class_2561)class_2561.method_43470((String)"Velocity"), this.field_22793, btn -> {}, false);
        this.velocityLabelBtn.field_22763 = false;
        this.method_37063((class_364)this.velocityLabelBtn);
        this.detectionToggleButton = new ToggleCategoryButton(toggleX, y, 50, 20, (class_2561)class_2561.method_43470((String)""), this.field_22793, btn -> {
            AutoFishingDetectionMethod.toggleMethod();
            handler.getConfig().detectionMethod = AutoFishingDetectionMethod.getCurrentMethod().name();
            handler.saveSettings();
            this.animTarget = AutoFishingDetectionMethod.getCurrentMethod() == AutoFishingDetectionMethod.Method.SOUND ? 1.0f : 0.0f;
            this.animating = true;
            this.pressPulse = 1.0f;
        }, false);
        this.method_37063((class_364)this.detectionToggleButton);
        this.soundLabelBtn = new ToggleCategoryButton(soundX, y, 55, 20, (class_2561)class_2561.method_43470((String)"Sound"), this.field_22793, btn -> {}, false);
        this.soundLabelBtn.field_22763 = false;
        this.method_37063((class_364)this.soundLabelBtn);
    }

    private int addUIButtonDynamicWidth(class_2561 label, Runnable onClick, int y) {
        int padding = 12;
        int textWidth = this.tr.method_27525((class_5348)label);
        int buttonWidth = textWidth + padding * 2;
        ToggleCategoryButton b = new ToggleCategoryButton(this.centerX(buttonWidth), y, buttonWidth, 20, label, this.tr, btn -> onClick.run(), false);
        this.method_37063((class_364)b);
        return y + 20 + 8;
    }

    private void buildFailsafes() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        int blockW = 304;
        int leftX = (this.field_22789 - blockW) / 2;
        int rightX = leftX + 140 + 24;
        int yL = this.columnTop();
        int yR = this.columnTop();
        ToggleCategoryButton b = new ToggleCategoryButton(leftX, yL, 140, 20, (class_2561)class_2561.method_43470((String)"GUI Open Failsafe"), this.tr, btn -> {
            handler.forceStopOnGuiOpen = !handler.forceStopOnGuiOpen;
            handler.saveSettings();
            this.method_25426();
        }, handler.forceStopOnGuiOpen);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stop when any GUI opens (chat, inventory, menus).")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(leftX, yL += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Break Protection"), this.tr, btn -> {
            if (handler.getConfig().fishingRodAutoSwapEnabled && handler.getConfig().breakProtectionFailsafeEnabled) {
                handler.sendChatMessage((class_2561)class_2561.method_43470((String)"Cannot disable Break Protection while Fishing Rod Swap is enabled!").method_27692(class_124.field_1079));
            } else {
                handler.getConfig().breakProtectionFailsafeEnabled = !handler.getConfig().breakProtectionFailsafeEnabled;
                handler.saveSettings();
                this.method_25426();
            }
        }, handler.getConfig().breakProtectionFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stop (or auto-swap if enabled) when rod is near breaking.")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(leftX, yL += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Teleport Failsafe"), this.tr, btn -> {
            handler.getConfig().teleportFailsafeEnabled = !handler.getConfig().teleportFailsafeEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().teleportFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stop if your position suddenly changes (teleport/lag spike).")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(leftX, yL += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Inventory Full Failsafe"), this.tr, btn -> {
            handler.getConfig().inventoryFullFailsafeEnabled = !handler.getConfig().inventoryFullFailsafeEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().inventoryFullFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stop when main inventory and actionbar is full.")));
        this.method_37063((class_364)b);
        yL += 28;
        b = new ToggleCategoryButton(rightX, yR, 140, 20, (class_2561)class_2561.method_43470((String)"Item Swap"), this.tr, btn -> {
            if (AutoFishingConfig.offhandRodSwapper) {
                handler.sendChatMessage((class_2561)class_2561.method_43470((String)"You cannot enable Item Swap Failsafe while Offhand Rod Swapper is active.").method_27692(class_124.field_1061));
                return;
            }
            handler.getConfig().itemSwapFailsafeEnabled = !handler.getConfig().itemSwapFailsafeEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().itemSwapFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stop if the held item unexpectedly changes during fishing.")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(rightX, yR += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Fishing Rod Swap"), this.tr, btn -> {
            if (AutoFishingConfig.offhandRodSwapper) {
                handler.sendChatMessage((class_2561)class_2561.method_43470((String)"You cannot enable Fishing Rod Swap while Offhand Rod Swapper is active.").method_27692(class_124.field_1061));
                return;
            }
            boolean bl = handler.getConfig().fishingRodAutoSwapEnabled = !handler.getConfig().fishingRodAutoSwapEnabled;
            if (handler.getConfig().fishingRodAutoSwapEnabled && !handler.getConfig().breakProtectionFailsafeEnabled) {
                handler.getConfig().breakProtectionFailsafeEnabled = true;
            }
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().fishingRodAutoSwapEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Auto-swap to a spare rod when durability is low.")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(rightX, yR += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Mouse Movement"), this.tr, btn -> {
            handler.mouseMovementEnabled = !handler.mouseMovementEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.mouseMovementEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Add subtle idle camera movement every 40 sec for 5 seconds.")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(rightX, yR += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Head Rotate Failsafe"), this.tr, btn -> {
            handler.getConfig().headRotateFailsafeEnabled = !handler.getConfig().headRotateFailsafeEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().headRotateFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stop if your view (yaw/pitch) is moved significantly.")));
        this.method_37063((class_364)b);
        b = new ToggleCategoryButton(rightX, yR += 28, 140, 20, (class_2561)class_2561.method_43470((String)"Recast Failsafe"), this.tr, btn -> {
            handler.getConfig().recastFailsafeEnabled = !handler.getConfig().recastFailsafeEnabled;
            handler.saveSettings();
            this.method_25426();
        }, handler.getConfig().recastFailsafeEnabled);
        b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Recast if no bite within the timeout")));
        this.method_37063((class_364)b);
        yR += 28;
        if (handler.getConfig().recastFailsafeEnabled) {
            yR = this.addStepperUnderAt(rightX, "Recast Delay", "s", () -> handler.getConfig().recastTimeoutSeconds, v -> {
                handler.getConfig().recastTimeoutSeconds = v;
                handler.saveSettings();
            }, 300, yR);
        }
    }

    private void buildFailsafeMacro() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        AutoFishingConfig cfg = handler.getConfig();
        int y = this.columnTop();
        y = this.addUIToggle((class_2561)class_2561.method_43470((String)"Inventory Full Macro"), FailsafeMacro.isEnabled(), () -> {
            boolean newVal = !FailsafeMacro.isEnabled();
            FailsafeMacro.setEnabled(newVal);
            cfg.inventoryFullMacroEnabled = newVal;
            handler.saveSettings();
            this.method_25426();
        }, y);
        if (FailsafeMacro.isEnabled()) {
            int groupW = 140;
            int chipW = 36;
            int chipGap = 6;
            int inputW = groupW - chipW - chipGap;
            int inputX = this.centerX(groupW);
            int chipX = inputX + inputW + chipGap;
            int chipY = y + 2;
            this.macroInput = new class_342(this.tr, inputX, y, inputW, 20, (class_2561)class_2561.method_43470((String)"Macro command/message"));
            this.macroInput.method_1852(FailsafeMacro.getCommand());
            this.macroInput.method_1880(256);
            this.macroInput.method_1863(s -> {});
            this.method_25429((class_364)this.macroInput);
            this.method_37063((class_364)this.macroInput);
            this.addStepperButton("\u2713", chipX, chipY, () -> {
                String txt = this.macroInput.method_1882();
                FailsafeMacro.setCommand(txt);
                cfg.inventoryFullMacroCommand = txt;
                handler.saveSettings();
            });
            y += 28;
            y = this.addUIButton((class_2561)class_2561.method_43470((String)("Behavior: " + (FailsafeMacro.getBehavior() == FailsafeMacro.Behavior.STOP ? "Stop" : "Reactivate"))), () -> {
                FailsafeMacro.toggleBehavior();
                cfg.inventoryFullMacroBehavior = FailsafeMacro.getBehavior().name();
                handler.saveSettings();
                this.method_25426();
            }, y);
            if (FailsafeMacro.getBehavior() == FailsafeMacro.Behavior.REACTIVATE) {
                ToggleCategoryButton delayLabel = new ToggleCategoryButton(this.centerX(140), y, 140, 20, (class_2561)class_2561.method_43470((String)"Reactivate Delay (sec)"), this.tr, b -> {}, false);
                delayLabel.field_22763 = false;
                this.method_37063((class_364)delayLabel);
                int fieldW = 50;
                int extraPad = 6;
                int fieldY = y + 20 + extraPad;
                int chipX2 = chipX;
                int chipY2 = fieldY;
                int fieldX = chipX2 - 6 - fieldW;
                this.reactivateDelayField = new class_342(this.tr, fieldX, fieldY, fieldW, 16, (class_2561)class_2561.method_43470((String)"sec"));
                this.reactivateDelayField.method_1880(6);
                this.reactivateDelayField.method_1852(Integer.toString(FailsafeMacro.getReactivateDelaySeconds()));
                this.reactivateDelayField.method_1863(s -> {});
                this.method_25429((class_364)this.reactivateDelayField);
                this.method_37063((class_364)this.reactivateDelayField);
                this.addStepperButton("\u2713", chipX2, chipY2, () -> {
                    int v;
                    String raw = this.reactivateDelayField.method_1882();
                    String digits = raw.replaceAll("\\D+", "");
                    if (digits.isEmpty()) {
                        v = 3;
                    } else {
                        try {
                            v = Integer.parseInt(digits);
                        }
                        catch (NumberFormatException e) {
                            v = 60;
                        }
                    }
                    v = Math.max(3, Math.min(60, v));
                    FailsafeMacro.setReactivateDelaySeconds(v);
                    cfg.inventoryFullMacroReactivateDelaySeconds = v;
                    handler.saveSettings();
                    this.reactivateDelayField.method_1852(Integer.toString(v));
                });
                y += 44 + extraPad;
            }
        }
    }

    private void buildGUI() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        int y = this.columnTop();
        y = this.addUIToggle(this.getButtonText("Inventory HUD", handler.getConfig().inventoryHUDSetting), handler.getConfig().inventoryHUDSetting, () -> {
            MiniInventoryHud.toggle(handler.getConfig());
            handler.saveSettings();
            this.method_25426();
        }, y);
        y = this.addUIButton((class_2561)class_2561.method_43470((String)"Edit HUD Placement"), () -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new EditMiniHud());
            }
        }, y);
        y = this.addUIButton(this.getBorderColorText(handler.getConfig().hudBorderColor), () -> {
            handler.getConfig().hudBorderColor = this.getNextBorderColor(handler.getConfig().hudBorderColor);
            handler.saveSettings();
            this.method_25426();
        }, y);
        y = this.addStepperUnder("Transparency", "%", () -> SettingsScreen.getAlphaPercent(handler.getConfig().hudBorderColor), v -> {
            handler.getConfig().hudBorderColor = SettingsScreen.setAlphaPercent(handler.getConfig().hudBorderColor, v);
            handler.saveSettings();
        }, 0, 100, 5, y);
    }

    private void buildSound() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        int y = this.columnTop();
        y = this.addUIButton((class_2561)class_2561.method_43470((String)("Sound: " + this.getSoundName(handler.getConfig().stopAlertSound))), () -> {
            int cur = handler.getConfig().stopAlertSound;
            handler.getConfig().stopAlertSound = cur = cur % 5 + 1;
            handler.saveSettings();
            this.method_25426();
        }, y);
        y = this.addStepperUnder("Sound Volume", "%", () -> Math.max(0, Math.min(100, Math.round(handler.getConfig().alertSoundVolume * 100.0f))), v -> {
            v = Math.max(0, Math.min(100, v));
            handler.getConfig().alertSoundVolume = (float)v / 100.0f;
            handler.saveSettings();
        }, 0, 100, 5, y);
        String mode = handler.getConfig().alertRepeatMode == null ? "ONCE" : handler.getConfig().alertRepeatMode;
        String modeLabel = switch (mode.toUpperCase()) {
            case "COUNT" -> "Specified Amount";
            case "UNTIL_ACTION" -> "Until User Action";
            default -> "Once";
        };
        y = this.addUIButton((class_2561)class_2561.method_43470((String)("Repeat: " + modeLabel)), () -> {
            String cur;
            String string = cur = handler.getConfig().alertRepeatMode == null ? "ONCE" : handler.getConfig().alertRepeatMode.toUpperCase();
            cur = cur.equals("ONCE") ? "COUNT" : (cur.equals("COUNT") ? "UNTIL_ACTION" : "ONCE");
            handler.getConfig().alertRepeatMode = cur;
            handler.saveSettings();
            this.method_25426();
        }, y);
        if ("COUNT".equalsIgnoreCase(handler.getConfig().alertRepeatMode)) {
            int groupW = 140;
            int chipW = 36;
            int chipGap = 6;
            int inputW = groupW - chipW - chipGap;
            int inputX = this.centerX(groupW);
            int chipX = inputX + inputW + chipGap;
            int chipY = y + 2;
            class_342 amountField = new class_342(this.tr, inputX, y, inputW, 20, (class_2561)class_2561.method_43470((String)"Times"));
            amountField.method_1880(6);
            amountField.method_1852(Integer.toString(Math.max(1, handler.getConfig().alertRepeatCount)));
            amountField.method_1863(s -> {});
            this.method_25429((class_364)amountField);
            this.method_37063((class_364)amountField);
            this.addStepperButton("\u2713", chipX, chipY, () -> {
                int v;
                String raw = amountField.method_1882();
                String digits = raw.replaceAll("\\D+", "");
                if (digits.isEmpty()) {
                    v = 1;
                } else {
                    try {
                        v = Integer.parseInt(digits);
                    }
                    catch (NumberFormatException e) {
                        v = 1;
                    }
                }
                handler.getConfig().alertRepeatCount = v = Math.max(1, Math.min(20, v));
                handler.saveSettings();
            });
            y += 28;
        }
        y = this.addUIButtonDynamicWidth((class_2561)class_2561.method_43470((String)"Test"), () -> AutoFishingHandler.getInstance().triggerFailsafe("Test"), y);
    }

    private void buildMisc() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        int y = this.columnTop();
        this.addUIToggle(this.getButtonText("Mouse Ungrab", handler.mouseUngrabEnabled), handler.mouseUngrabEnabled, () -> {
            handler.mouseUngrabEnabled = !handler.mouseUngrabEnabled;
            handler.saveSettings();
            this.method_25426();
        }, y);
    }

    private void buildAdvanced() {
        AutoFishingHandler handler = AutoFishingDeluxe.getHandler();
        int y = this.columnTop();
        y = this.addUIToggle(this.getButtonText("Offhand Rod Swapper", AutoFishingConfig.offhandRodSwapper), AutoFishingConfig.offhandRodSwapper, () -> {
            boolean bl = AutoFishingConfig.offhandRodSwapper = !AutoFishingConfig.offhandRodSwapper;
            if (AutoFishingConfig.offhandRodSwapper) {
                handler.getConfig().fishingRodAutoSwapEnabled = false;
                handler.getConfig().itemSwapFailsafeEnabled = false;
                handler.sendChatMessage((class_2561)class_2561.method_43470((String)"Disabled AutoSwap and ItemSwap Failsafe, due to confliction with Offhand Swapper.").method_27692(class_124.field_1061));
            }
            handler.saveSettings();
            this.method_25426();
        }, y);
        this.addUIToggle((class_2561)class_2561.method_43470((String)"Enchant Behaviour"), handler.getConfig().enchantBehaviourEnabled, () -> {
            handler.getConfig().enchantBehaviourEnabled = !handler.getConfig().enchantBehaviourEnabled;
            handler.saveSettings();
            this.method_25426();
        }, y + 20 + 8);
    }

    private String getSoundName(int id) {
        return switch (id) {
            case 1 -> "Anvil";
            case 2 -> "Villager";
            case 3 -> "Bell";
            case 4 -> "Level Up";
            case 5 -> "Xp Orb";
            default -> "Anvil";
        };
    }

    private class_2561 getButtonText(String label, boolean enabled) {
        return class_2561.method_43470((String)label);
    }

    private static int fullAlpha(int c) {
        return c & 0xFFFFFF | 0xFF000000;
    }

    private int getNextBorderColor(int current) {
        int alpha = current >>> 24 & 0xFF;
        int rgb = current & 0xFFFFFF;
        for (int i = 0; i < HUD_BORDER_COLORS.length; ++i) {
            if (HUD_BORDER_COLORS[i] != rgb) continue;
            int nextRgb = HUD_BORDER_COLORS[(i + 1) % HUD_BORDER_COLORS.length] & 0xFFFFFF;
            return alpha << 24 | nextRgb;
        }
        int firstRgb = HUD_BORDER_COLORS[0] & 0xFFFFFF;
        return alpha << 24 | firstRgb;
    }

    private String colorNameFor(int rgb) {
        return switch (rgb &= 0xFFFFFF) {
            case 0xFFFFFF -> "White";
            case 65535 -> "Cyan";
            case 65280 -> "Lime";
            case 0xFFFF00 -> "Yellow";
            case 16753920 -> "Orange";
            case 0xFF0000 -> "Red";
            case 0xFF00FF -> "Magenta";
            case 0x800080 -> "Purple";
            case 33023 -> "Blue";
            case 10133670 -> "Gray";
            default -> String.format("#%06X", rgb);
        };
    }

    private class_2561 getBorderColorText(int colorMaybeWithAlpha) {
        int rgb = colorMaybeWithAlpha & 0xFFFFFF;
        int sample = SettingsScreen.fullAlpha(rgb);
        return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)("HUD Border: " + this.colorNameFor(rgb) + " "))).method_10852((class_2561)class_2561.method_43470((String)"\u25cf").method_27694(s -> s.method_36139(sample)));
    }

    private static int clamp(int v, int lo, int hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static int setAlphaPercent(int argb, int percent) {
        int p = SettingsScreen.clamp(percent, 0, 100);
        int a = Math.round((float)p * 255.0f / 100.0f) & 0xFF;
        return a << 24 | argb & 0xFFFFFF;
    }

    private static int getAlphaPercent(int argb) {
        int a = argb >>> 24 & 0xFF;
        return Math.round((float)a * 100.0f / 255.0f);
    }

    public static enum MenuState {
        MAIN,
        FISHING,
        FAILSAFES,
        FAILSAFESMACRO,
        GUI,
        SOUND,
        MISC,
        ADVANCED,
        FISHING_METHOD;

    }
}

