/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.audioloader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.maxhenkel.audioplayer.AudioPlayerMod;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1657;

public class Metadata {
    private final UUID audioId;
    @Nullable
    private String fileName;
    @Nullable
    private Float volume;
    @Nullable
    private Long created;
    @Nullable
    private Owner owner;

    public Metadata(UUID audioId) {
        this.audioId = audioId;
    }

    public UUID getAudioId() {
        return this.audioId;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(@Nullable String fileName) {
        this.fileName = fileName;
    }

    @Nullable
    public Float getVolume() {
        return this.volume;
    }

    public void setVolume(@Nullable Float volume) {
        this.volume = volume;
    }

    @Nullable
    public Long getCreated() {
        return this.created;
    }

    public void setCreated(@Nullable Long created) {
        this.created = created;
    }

    @Nullable
    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable Owner owner) {
        this.owner = owner;
    }

    public static Metadata fromJson(UUID audioId, JsonObject json) {
        Metadata metadata = new Metadata(audioId);
        JsonElement filenameElement = json.get("fileName");
        metadata.fileName = filenameElement == null ? null : filenameElement.getAsString();
        JsonElement volumeElement = json.get("volume");
        metadata.volume = volumeElement == null ? null : Float.valueOf(Math.max(Math.min(volumeElement.getAsFloat(), 1.0f), 0.0f));
        JsonElement createdElement = json.get("created");
        metadata.created = createdElement == null ? null : Long.valueOf(createdElement.getAsLong());
        JsonObject ownerJson = json.getAsJsonObject("owner");
        if (ownerJson != null) {
            try {
                String name;
                JsonElement uuidElement = ownerJson.get("uuid");
                String uuidString = uuidElement == null ? null : uuidElement.getAsString();
                JsonElement nameElement = ownerJson.get("name");
                String string = name = nameElement == null ? null : nameElement.getAsString();
                if (uuidString != null && name != null) {
                    UUID uuid = UUID.fromString(uuidString);
                    metadata.owner = new Owner(uuid, name);
                }
            }
            catch (IllegalArgumentException e) {
                AudioPlayerMod.LOGGER.warn("Invalid owner UUID in metadata", (Throwable)e);
            }
        }
        return metadata;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.fileName != null && !this.fileName.isBlank()) {
            json.addProperty("fileName", this.fileName);
        }
        if (this.volume != null) {
            json.addProperty("volume", (Number)this.volume);
        }
        if (this.created != null) {
            json.addProperty("created", (Number)this.created);
        }
        if (this.owner != null) {
            JsonObject ownerJson = new JsonObject();
            ownerJson.addProperty("uuid", this.owner.uuid().toString());
            ownerJson.addProperty("name", this.owner.name());
            json.add("owner", (JsonElement)ownerJson);
        }
        return json;
    }

    public record Owner(@Nonnull UUID uuid, @Nonnull String name) {
        public static Owner of(class_1657 player) {
            return new Owner(player.method_7334().id(), player.method_7334().name());
        }
    }
}

