/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.audioplayer.api.importer.AudioImporter;
import de.maxhenkel.audioplayer.apiimpl.AudioPlayerApiImpl;
import de.maxhenkel.audioplayer.audioloader.AudioStorageManager;
import de.maxhenkel.audioplayer.audioloader.importer.FilebinImporter;
import de.maxhenkel.audioplayer.audioloader.importer.ServerfileImporter;
import de.maxhenkel.audioplayer.audioloader.importer.UrlImporter;
import de.maxhenkel.audioplayer.command.ServerFileArgument;
import de.maxhenkel.audioplayer.lang.Lang;
import de.maxhenkel.audioplayer.webserver.WebServer;
import de.maxhenkel.audioplayer.webserver.WebServerEvents;
import java.net.URI;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;

@Command(value={"audioplayer"})
@RequiresPermission(value="audioplayer.upload")
public class UploadCommands {
    @Command
    public void audioPlayer(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.upload_filebin", new Object[0]).method_27693(" ").method_10852((class_2561)Lang.translatable("audioplayer.here", new Object[0]).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/audioplayer filebin")).method_10949((class_2568)new class_2568.class_10613((class_2561)Lang.translatable("audioplayer.click_show_more", new Object[0])))).method_27692(class_124.field_1060)).method_27693("."), false);
        ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.upload_serverfile", new Object[0]).method_27693(" ").method_10852((class_2561)Lang.translatable("audioplayer.here", new Object[0]).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/audioplayer serverfile")).method_10949((class_2568)new class_2568.class_10613((class_2561)Lang.translatable("audioplayer.click_show_more", new Object[0])))).method_27692(class_124.field_1060)).method_27693("."), false);
        ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.upload_url", new Object[0]).method_27693(" ").method_10852((class_2561)Lang.translatable("audioplayer.here", new Object[0]).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/audioplayer url")).method_10949((class_2568)new class_2568.class_10613((class_2561)Lang.translatable("audioplayer.click_show_more", new Object[0])))).method_27692(class_124.field_1060)).method_27693("."), false);
    }

    @Command(value={"filebin"})
    public void filebin(CommandContext<class_2168> context) {
        FilebinImporter.sendFilebinUploadMessage((class_2168)context.getSource());
    }

    @Command(value={"filebin"})
    public void filebinUpload(CommandContext<class_2168> context, @Name(value="id") UUID sound) {
        ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.downloading_sound", new Object[0]), false);
        AudioPlayerApiImpl.INSTANCE.importAudio((AudioImporter)new FilebinImporter(sound), (class_2168)context.getSource());
    }

    @Command(value={"url"})
    public void url(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.url_command", class_2561.method_43470((String)".mp3").method_27692(class_124.field_1080), class_2561.method_43470((String)".wav").method_27692(class_124.field_1080), class_2561.method_43470((String)"/audioplayer url <link-to-your-file>").method_27692(class_124.field_1080).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610("/audioplayer url ")).method_10949((class_2568)new class_2568.class_10613((class_2561)Lang.translatable("audioplayer.click_fill_command", new Object[0]))))), false);
    }

    @Command(value={"url"})
    public void urlUpload(CommandContext<class_2168> context, @Name(value="url") String url) {
        ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.downloading_sound", new Object[0]), false);
        AudioPlayerApiImpl.INSTANCE.importAudio((AudioImporter)new UrlImporter(url), (class_2168)context.getSource());
    }

    @Command(value={"web"})
    public void web(CommandContext<class_2168> context) throws CommandSyntaxException {
        WebServer webServer = WebServerEvents.getWebServer();
        if (webServer == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)Lang.translatable("audioplayer.webserver_not_running", new Object[0]));
            return;
        }
        UUID token = webServer.getTokenManager().generateToken(((class_2168)context.getSource()).method_9207().method_5667());
        URI uploadUrl = WebServer.generateUploadUrl(token);
        if (uploadUrl != null) {
            ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.click_upload", Lang.translatable("audioplayer.here", new Object[0]).method_27695(new class_124[]{class_124.field_1060, class_124.field_1073}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(uploadUrl)).method_10949((class_2568)new class_2568.class_10613((class_2561)Lang.translatable("audioplayer.click_open", new Object[0]))))), false);
            return;
        }
        ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.visit_website", Lang.translatable("audioplayer.this_token", new Object[0]).method_27692(class_124.field_1060).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10606(token.toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)Lang.translatable("audioplayer.click_copy", new Object[0]))))), false);
    }

    @Command(value={"serverfile"})
    public void serverFile(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.upload_serverfile_instructions", class_2561.method_43470((String)".mp3").method_27692(class_124.field_1080), class_2561.method_43470((String)".wav").method_27692(class_124.field_1080), class_2561.method_43470((String)AudioStorageManager.getUploadFolder().toAbsolutePath().toString()).method_27692(class_124.field_1080), class_2561.method_43470((String)"/audioplayer serverfile \"yourfile.mp3\"").method_27692(class_124.field_1080).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610("/audioplayer serverfile ")).method_10949((class_2568)new class_2568.class_10613((class_2561)Lang.translatable("audioplayer.click_fill_command", new Object[0]))))), false);
    }

    @Command(value={"serverfile"})
    public void serverFileUpload(CommandContext<class_2168> context, @Name(value="filename") ServerFileArgument serverFile) {
        AudioPlayerApiImpl.INSTANCE.importAudio((AudioImporter)new ServerfileImporter(serverFile.getFileName()), (class_2168)context.getSource());
    }
}

