/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.utils.upgrade;

import com.mojang.serialization.Codec;
import de.maxhenkel.audioplayer.audioloader.AudioData;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_11368;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_4844;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class ItemUpgrader {
    public static final String CUSTOM_SOUND = "CustomSound";
    public static final String CUSTOM_SOUND_RANGE = "CustomSoundRange";
    public static final String CUSTOM_SOUND_RANDOM = "CustomSoundRandomized";
    public static final String CUSTOM_SOUND_STATIC = "IsStaticCustomSound";

    public static boolean upgradeItem(class_1799 item) {
        class_9279 customData = (class_9279)item.method_58694(class_9334.field_49628);
        if (customData == null) {
            return false;
        }
        class_2487 tag = customData.method_57461();
        AudioData data = ItemUpgrader.of(tag);
        if (data == null) {
            return false;
        }
        tag.method_10551(CUSTOM_SOUND);
        tag.method_10551(CUSTOM_SOUND_RANGE);
        tag.method_10551(CUSTOM_SOUND_STATIC);
        tag.method_10551(CUSTOM_SOUND_RANDOM);
        item.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        data.saveToItem(item);
        return true;
    }

    public static AudioData upgradeBlockEntity(class_11368 valueInput) {
        return ItemUpgrader.of(valueInput);
    }

    @Nullable
    private static AudioData of(class_2487 tag) {
        UUID soundId = tag.method_67491(CUSTOM_SOUND, class_4844.field_25122).orElse(null);
        if (soundId == null) {
            return null;
        }
        Float range = tag.method_10583(CUSTOM_SOUND_RANGE).orElse(null);
        AudioData audioData = AudioData.withSoundAndRange(soundId, range);
        ItemUpgrader.upgradeRoleplayData(tag, audioData);
        return audioData;
    }

    private static void upgradeRoleplayData(class_2487 compoundTag, AudioData audioData) {
    }

    @Nullable
    private static AudioData of(class_11368 valueInput) {
        UUID soundId = valueInput.method_71426(CUSTOM_SOUND, class_4844.field_25122).orElse(null);
        if (soundId == null) {
            return null;
        }
        Float range = valueInput.method_71426(CUSTOM_SOUND_RANGE, (Codec)Codec.FLOAT).orElse(null);
        AudioData audioData = AudioData.withSoundAndRange(soundId, range);
        ItemUpgrader.upgradeRoleplayData(valueInput, audioData);
        return audioData;
    }

    private static void upgradeRoleplayData(class_11368 valueInput, AudioData audioData) {
    }
}

