/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.maxhenkel.admiral.argumenttype.ArgumentTypeConverter;
import de.maxhenkel.admiral.argumenttype.ArgumentTypeSupplier;
import de.maxhenkel.audioplayer.AudioPlayerMod;
import de.maxhenkel.audioplayer.audioloader.AudioStorageManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import org.jetbrains.annotations.Nullable;

public class ServerFileArgument {
    private final String fileName;

    public ServerFileArgument(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static final class ServerFileSuggestionProvider
    implements SuggestionProvider<class_2168> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            Path uploadFolder = AudioStorageManager.getUploadFolder();
            try (Stream<Path> uploadFiles = Files.list(uploadFolder);){
                uploadFiles.forEach(path -> builder.suggest(StringArgumentType.escapeIfRequired((String)path.getFileName().toString())));
            }
            catch (IOException e) {
                AudioPlayerMod.LOGGER.error("Failed to list upload folder", (Throwable)e);
                return builder.buildFuture();
            }
            return builder.buildFuture();
        }
    }

    public static class ServerFileArgumentTypeConverter
    implements ArgumentTypeConverter<class_2168, String, ServerFileArgument> {
        @Nullable
        public ServerFileArgument convert(CommandContext<class_2168> commandContext, String s) throws CommandSyntaxException {
            return new ServerFileArgument(s);
        }
    }

    public static class ServerFileArgumentSupplier
    implements ArgumentTypeSupplier<class_2168, ServerFileArgument, String> {
        public ArgumentType<String> get() {
            return StringArgumentType.string();
        }

        public SuggestionProvider<class_2168> getSuggestionProvider() {
            return new ServerFileSuggestionProvider();
        }
    }
}

