/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.audioplayback;

import de.maxhenkel.audioplayer.AudioPlayerMod;
import de.maxhenkel.audioplayer.api.ChannelReference;
import de.maxhenkel.audioplayer.api.events.AudioEvents;
import de.maxhenkel.audioplayer.api.events.PlayEvent;
import de.maxhenkel.audioplayer.api.events.PostPlayEvent;
import de.maxhenkel.audioplayer.apiimpl.ChannelReferenceImpl;
import de.maxhenkel.audioplayer.apiimpl.events.GetDistanceEventImpl;
import de.maxhenkel.audioplayer.apiimpl.events.PlayEventImpl;
import de.maxhenkel.audioplayer.apiimpl.events.PostPlayEventImpl;
import de.maxhenkel.audioplayer.audioloader.AudioData;
import de.maxhenkel.audioplayer.audioloader.AudioStorageManager;
import de.maxhenkel.audioplayer.audioloader.cache.CachedAudio;
import de.maxhenkel.audioplayer.audioplayback.PlayerThread;
import de.maxhenkel.audioplayer.audioplayback.PlayerType;
import de.maxhenkel.audioplayer.lang.Lang;
import de.maxhenkel.audioplayer.utils.ChatUtils;
import de.maxhenkel.audioplayer.voicechat.VoicechatAudioPlayerPlugin;
import de.maxhenkel.voicechat.api.Player;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PlayerManager {
    private final Map<UUID, PlayerThread<?>> players = new ConcurrentHashMap();
    private final ExecutorService executor;
    private static PlayerManager instance;

    public PlayerManager() {
        this.executor = Executors.newFixedThreadPool(AudioPlayerMod.SERVER_CONFIG.audioLoaderThreads.get(), r -> {
            Thread thread = new Thread(r, "AudioLoaderThread");
            thread.setDaemon(true);
            return thread;
        });
    }

    @Nullable
    public ChannelReference<?> playType(class_3218 serverLevel, @Nullable class_3222 player, AudioData data, PlayerType type, Event<Consumer<PlayEvent>> playEvent, Event<Consumer<PostPlayEvent>> postPlayEvent, class_243 pos) {
        UUID soundIdToPlay = data.getSoundIdToPlay();
        if (soundIdToPlay == null) {
            return null;
        }
        Float maxDuration = type.getMaxDuration().get();
        if (maxDuration == null || maxDuration.floatValue() < 0.0f) {
            maxDuration = null;
        }
        GetDistanceEventImpl distanceEvent = new GetDistanceEventImpl(data, type.getDefaultRange().get().floatValue(), data.getRange(type), pos);
        ((Consumer)AudioEvents.GET_DISTANCE.invoker()).accept(distanceEvent);
        PlayEventImpl event = new PlayEventImpl(data, serverLevel, null, soundIdToPlay, type.getDefaultRange().get().floatValue(), distanceEvent.getDistance(), type.getCategory(), pos);
        ((Consumer)playEvent.invoker()).accept(event);
        if (event.isCancelled()) {
            return null;
        }
        ChannelReference<?> channel = event.getOverrideChannel();
        if (channel == null) {
            channel = PlayerManager.instance().playLocational(serverLevel, event.getPosition(), event.getSoundId(), player, event.getDistance(), event.getCategory(), maxDuration);
        }
        if (channel != null) {
            ((Consumer)postPlayEvent.invoker()).accept(new PostPlayEventImpl(channel, data, event.getSoundId(), event.getCategory(), event.getPosition(), serverLevel, player, event.getDistance()));
        }
        return channel;
    }

    @Nullable
    public ChannelReferenceImpl<LocationalAudioChannel> playLocational(class_3218 level, class_243 pos, UUID sound, @Nullable class_3222 p, float distance, @Nullable String category, @Nullable Float maxLengthSeconds) {
        VoicechatServerApi api = VoicechatAudioPlayerPlugin.voicechatServerApi;
        if (api == null) {
            return null;
        }
        UUID channelID = UUID.randomUUID();
        LocationalAudioChannel channel = api.createLocationalAudioChannel(channelID, api.fromServerLevel((Object)level), api.createPosition(pos.field_1352, pos.field_1351, pos.field_1350));
        if (channel == null) {
            return null;
        }
        if (category != null) {
            channel.setCategory(category);
        }
        channel.setDistance(distance);
        api.getPlayersInRange(api.fromServerLevel((Object)level), channel.getLocation(), (double)(distance + 1.0f), serverPlayer -> {
            VoicechatConnection connection = api.getConnectionOf(serverPlayer);
            return !ChatUtils.isAbleToHearVoicechat(connection);
        }).stream().map(Player::getPlayer).map(class_3222.class::cast).forEach(ChatUtils::sendEnableVoicechatMessage);
        return this.playChannel(channel, sound, p, maxLengthSeconds);
    }

    public <T extends AudioChannel> ChannelReferenceImpl<T> playChannel(T channel, UUID sound, @Nullable class_3222 p, @Nullable Float maxLengthSeconds) {
        PlayerThread playerThread = new PlayerThread(channel, () -> this.players.remove(channel.getId()));
        this.players.put(channel.getId(), playerThread);
        this.executor.execute(() -> {
            if (!this.playChannel0(playerThread, sound, p, maxLengthSeconds)) {
                this.players.remove(channel.getId());
            }
        });
        return new ChannelReferenceImpl<T>(channel, sound, playerThread);
    }

    private <T extends AudioChannel> boolean playChannel0(PlayerThread<T> playerThread, UUID sound, @Nullable class_3222 p, @Nullable Float maxLengthSeconds) {
        try {
            CachedAudio audio = AudioStorageManager.audioCache().getAudio(sound);
            if (maxLengthSeconds != null && audio.getDurationSeconds() > maxLengthSeconds.floatValue()) {
                if (p != null) {
                    p.method_51469().method_8503().execute(() -> p.method_7353((class_2561)Lang.translatable("audioplayer.audio_too_long", new Object[0]).method_27692(class_124.field_1079), true));
                }
                AudioPlayerMod.LOGGER.error("Audio {} was too long to play", (Object)sound);
                return false;
            }
            playerThread.startPlaying(audio);
            return true;
        }
        catch (Exception e) {
            AudioPlayerMod.LOGGER.error("Failed to play audio", (Throwable)e);
            if (p != null) {
                p.method_51469().method_8503().execute(() -> p.method_7353((class_2561)Lang.translatable("audioplayer.play_audio_failed", e.getMessage()).method_27692(class_124.field_1079), true));
            }
            return false;
        }
    }

    public void stop(UUID channelID) {
        PlayerThread<?> player = this.players.get(channelID);
        if (player == null) {
            this.players.remove(channelID);
            return;
        }
        player.stopPlaying();
    }

    public boolean isStopped(UUID channelID) {
        PlayerThread<?> player = this.players.get(channelID);
        if (player == null) {
            return true;
        }
        return player.isStopped();
    }

    public static PlayerManager instance() {
        if (instance == null) {
            instance = new PlayerManager();
        }
        return instance;
    }

    public int stopAll(UUID audioId) {
        List<PlayerThread> list = this.players.values().stream().filter(playerThread -> {
            CachedAudio audio = playerThread.getAudio();
            if (audio == null) {
                return false;
            }
            return audio.getId().equals(audioId);
        }).toList();
        list.forEach(PlayerThread::stopPlaying);
        return list.size();
    }
}

