/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.audioplayback;

import de.maxhenkel.audioplayer.audioloader.cache.CachedAudio;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class PlayerThread<T extends AudioChannel>
extends Thread {
    private static final long FRAME_DURATION_NS = 20000000L;
    private final T audioChannel;
    @Nullable
    private CachedAudio audio;
    @Nullable
    private final Runnable onStopped;
    @Nullable
    private Consumer<T> channelUpdate;

    public PlayerThread(T audioChannel, @Nullable Runnable onStopped) {
        this.audioChannel = audioChannel;
        this.onStopped = onStopped;
        this.setDaemon(true);
        this.setName("AudioPlayback-%s".formatted(audioChannel.getId()));
    }

    public void startPlaying(CachedAudio cachedAudio) {
        if (this.audio != null) {
            return;
        }
        this.audio = cachedAudio;
        this.start();
    }

    @Nullable
    public CachedAudio getAudio() {
        return this.audio;
    }

    private void updateChannel(T audioChannel) {
        if (this.channelUpdate != null) {
            this.channelUpdate.accept(audioChannel);
        }
    }

    public void stopPlaying() {
        this.interrupt();
    }

    public boolean isInitialized() {
        return this.audio != null;
    }

    public boolean isCurrentlyPlaying() {
        return this.isAlive();
    }

    public boolean isStopped() {
        return this.isInitialized() && !this.isAlive();
    }

    public void setChannelUpdate(@Nullable Consumer<T> channelUpdate) {
        this.channelUpdate = channelUpdate;
    }

    @Override
    public void run() {
        byte[] frame;
        if (this.isInterrupted()) {
            if (this.onStopped != null) {
                this.onStopped.run();
            }
            return;
        }
        int framePosition = 0;
        long startTime = System.nanoTime();
        while ((frame = this.audio.getOpusFrames()[framePosition]) != null) {
            this.audioChannel.send(frame);
            this.updateChannel(this.audioChannel);
            long waitTimestamp = startTime + (long)(++framePosition) * 20000000L;
            long waitNanos = waitTimestamp - System.nanoTime();
            try {
                if (waitNanos <= 0L) continue;
                Thread.sleep(waitNanos / 1000000L, (int)(waitNanos % 1000000L));
            }
            catch (InterruptedException e) {
                break;
            }
        }
        this.audioChannel.flush();
        if (this.onStopped != null) {
            this.onStopped.run();
        }
    }
}

