/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.microhttp;

import de.maxhenkel.audioplayer.microhttp.CloseUtils;
import de.maxhenkel.audioplayer.microhttp.ConnectionEventLoop;
import de.maxhenkel.audioplayer.microhttp.Handler;
import de.maxhenkel.audioplayer.microhttp.LogEntry;
import de.maxhenkel.audioplayer.microhttp.Logger;
import de.maxhenkel.audioplayer.microhttp.NoopLogger;
import de.maxhenkel.audioplayer.microhttp.Options;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class EventLoop {
    private final Options options;
    private final Logger logger;
    private final Selector selector;
    private final AtomicBoolean stop;
    private final ServerSocketChannel serverSocketChannel;
    private final List<ConnectionEventLoop> connectionEventLoops;
    private final Thread thread;

    public EventLoop(Handler handler) throws IOException {
        this(Options.builder().build(), handler);
    }

    public EventLoop(Options options, Handler handler) throws IOException {
        this(options, NoopLogger.instance(), handler);
    }

    public EventLoop(Options options, Logger logger, Handler handler) throws IOException {
        this.options = options;
        this.logger = logger;
        this.selector = Selector.open();
        this.stop = new AtomicBoolean();
        AtomicLong connectionCounter = new AtomicLong();
        this.connectionEventLoops = new ArrayList<ConnectionEventLoop>();
        for (int i = 0; i < options.concurrency(); ++i) {
            this.connectionEventLoops.add(new ConnectionEventLoop(options, logger, handler, connectionCounter, this.stop));
        }
        this.thread = new Thread(this::run, "event-loop");
        InetSocketAddress address = options.host() == null ? new InetSocketAddress(options.port()) : new InetSocketAddress(options.host(), options.port());
        this.serverSocketChannel = ServerSocketChannel.open();
        if (options.reuseAddr()) {
            this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)options.reuseAddr());
        }
        if (options.reusePort()) {
            this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEPORT, (Object)options.reusePort());
        }
        this.serverSocketChannel.configureBlocking(false);
        this.serverSocketChannel.bind(address, options.acceptLength());
        this.serverSocketChannel.register(this.selector, 16);
    }

    public int getPort() throws IOException {
        int n;
        SocketAddress socketAddress = this.serverSocketChannel.getLocalAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress a = (InetSocketAddress)socketAddress;
            n = a.getPort();
        } else {
            n = -1;
        }
        return n;
    }

    public void start() {
        this.thread.start();
        this.connectionEventLoops.forEach(ConnectionEventLoop::start);
    }

    private void run() {
        try {
            this.doRun();
        }
        catch (IOException e) {
            if (this.logger.enabled()) {
                this.logger.log(e, new LogEntry("event", "event_loop_terminate"));
            }
            this.stop.set(true);
        }
        finally {
            CloseUtils.closeQuietly(this.selector);
            CloseUtils.closeQuietly(this.serverSocketChannel);
        }
    }

    private void doRun() throws IOException {
        while (!this.stop.get()) {
            this.selector.select(this.options.resolution().toMillis());
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> it = selectedKeys.iterator();
            while (it.hasNext()) {
                SelectionKey selKey = it.next();
                if (selKey.isAcceptable()) {
                    ConnectionEventLoop connectionEventLoop = this.leastConnections();
                    connectionEventLoop.register(this.serverSocketChannel.accept());
                }
                it.remove();
            }
        }
    }

    private ConnectionEventLoop leastConnections() {
        return this.connectionEventLoops.stream().min(Comparator.comparing(ConnectionEventLoop::numConnections)).get();
    }

    public void stop() {
        this.stop.set(true);
    }

    public void join() throws InterruptedException {
        this.thread.join();
        for (ConnectionEventLoop connectionEventLoop : this.connectionEventLoops) {
            connectionEventLoop.join();
        }
    }
}

