/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.maxhenkel.audioplayer.api.AudioPlayerApi;
import de.maxhenkel.audioplayer.api.data.AudioDataModule;
import de.maxhenkel.audioplayer.api.data.ModuleKey;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_2960;

public class AudioPlayerModule
implements AudioDataModule {
    public static final class_2960 ID = class_2960.method_60655((String)"audioplayer", (String)"audio");
    public static ModuleKey<AudioPlayerModule> KEY;
    protected UUID soundId;
    @Nullable
    protected Float range;

    private AudioPlayerModule() {
    }

    public AudioPlayerModule(UUID soundId, @Nullable Float range) {
        this.soundId = soundId;
        this.range = range;
    }

    public static void onInitialize() {
        if (KEY != null) {
            return;
        }
        KEY = AudioPlayerApi.instance().registerModuleType(ID, AudioPlayerModule::new);
    }

    public UUID getSoundId() {
        return this.soundId;
    }

    @Nullable
    public Float getRange() {
        return this.range;
    }

    @Override
    public void load(JsonObject json) throws Exception {
        JsonElement id = json.get("id");
        if (id == null) {
            throw new Exception("Missing sound ID");
        }
        this.soundId = UUID.fromString(id.getAsString());
        JsonElement rangeElement = json.get("range");
        this.range = rangeElement == null ? null : Float.valueOf(rangeElement.getAsFloat());
    }

    @Override
    public void save(JsonObject json) throws Exception {
        json.addProperty("id", this.soundId.toString());
        if (this.range != null) {
            json.addProperty("range", (Number)this.range);
        }
    }
}

