/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.audioloader.importer;

import de.maxhenkel.audioplayer.AudioPlayerMod;
import de.maxhenkel.audioplayer.api.importer.AudioImportInfo;
import de.maxhenkel.audioplayer.api.importer.AudioImporter;
import de.maxhenkel.audioplayer.audioloader.AudioStorageManager;
import de.maxhenkel.audioplayer.lang.Lang;
import de.maxhenkel.audioplayer.utils.ChatUtils;
import de.maxhenkel.audioplayer.utils.ComponentException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.apache.commons.io.IOUtils;

public class ServerfileImporter
implements AudioImporter {
    private final UUID soundId = UUID.randomUUID();
    private final String fileName;
    private Path file;

    public ServerfileImporter(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public AudioImportInfo onPreprocess(@Nullable class_3222 player) throws Exception {
        Path uploadFolder = AudioStorageManager.getUploadFolder();
        this.file = uploadFolder.resolve(this.fileName);
        if (!uploadFolder.equals(this.file.getParent())) {
            throw new ComponentException((class_2561)Lang.translatable("audioplayer.invalid_file_name", new Object[0]));
        }
        if (!Files.exists(this.file, new LinkOption[0]) || !Files.isRegularFile(this.file, new LinkOption[0])) {
            throw new NoSuchFileException("The file %s does not exist".formatted(this.file.toString()));
        }
        long size = Files.size(this.file);
        ChatUtils.checkFileSize(size);
        return new AudioImportInfo(this.soundId, ServerfileImporter.getFileNameFromPath(this.file));
    }

    @Nullable
    public static String getFileNameFromPath(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return null;
        }
        String name = path.getFileName().toString();
        if (name.isEmpty()) {
            return null;
        }
        return name;
    }

    @Override
    public byte[] onProcess(@Nullable class_3222 player) throws Exception {
        return IOUtils.toByteArray((InputStream)Files.newInputStream(this.file, new OpenOption[0]));
    }

    @Override
    public void onPostprocess(@Nullable class_3222 player) throws Exception {
        try {
            Files.delete(this.file);
            if (player != null) {
                player.method_64398((class_2561)Lang.translatable("audioplayer.deleted_temp_file", class_2561.method_43470((String)this.fileName).method_27692(class_124.field_1080)));
            }
        }
        catch (Exception e) {
            AudioPlayerMod.LOGGER.error("Failed to delete file {}", (Object)this.file, (Object)e);
        }
    }

    @Override
    public String getHandlerName() {
        return "serverfile";
    }
}

