/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Max;
import de.maxhenkel.admiral.annotations.Min;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.OptionalArgument;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.audioplayer.audioloader.AudioStorageManager;
import de.maxhenkel.audioplayer.command.UtilityCommands;
import de.maxhenkel.audioplayer.lang.Lang;
import java.text.DecimalFormat;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

@Command(value={"audioplayer"})
@RequiresPermission(value="audioplayer.volume")
public class VolumeCommands {
    public static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("#.00");

    @Command(value={"volume"})
    public void volumeWithId(CommandContext<class_2168> context, @Name(value="id") UUID uuid, @OptionalArgument @Name(value="volume_percent") @Min(value="0.01") @Max(value="100") Float volume) {
        this.volumeCommand(context, uuid, volume);
    }

    @Command(value={"volume"})
    public void volumeHeldItem(CommandContext<class_2168> context, @OptionalArgument @Name(value="volume_percent") @Min(value="0.01") @Max(value="100") Float volume) throws CommandSyntaxException {
        UUID id = UtilityCommands.getHeldItemId(context);
        if (id == null) {
            return;
        }
        this.volumeCommand(context, id, volume);
    }

    private void volumeCommand(CommandContext<class_2168> context, UUID id, @Nullable Float volume) {
        if (!AudioStorageManager.instance().checkSoundExists(id)) {
            ((class_2168)context.getSource()).method_9213((class_2561)Lang.translatable("audioplayer.audio_file_not_found", new Object[0]));
            return;
        }
        if (volume == null) {
            float currentVolume = AudioStorageManager.metadataManager().getVolumeOverride(id).orElse(Float.valueOf(1.0f)).floatValue();
            ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.current_volume", PERCENT_FORMAT.format(currentVolume * 100.0f)), false);
            return;
        }
        if (volume.floatValue() >= 100.0f) {
            AudioStorageManager.metadataManager().setVolumeOverride(id, null);
        }
        AudioStorageManager.metadataManager().setVolumeOverride(id, Float.valueOf(volume.floatValue() / 100.0f));
        AudioStorageManager.audioCache().invalidate(id);
        ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.set_volume_successful", PERCENT_FORMAT.format(volume)), false);
    }
}

