/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.utils;

import de.maxhenkel.audioplayer.AudioPlayerMod;
import de.maxhenkel.audioplayer.audioloader.AudioStorageManager;
import de.maxhenkel.audioplayer.audioloader.Metadata;
import de.maxhenkel.audioplayer.lang.Lang;
import de.maxhenkel.audioplayer.voicechat.VoicechatAudioPlayerPlugin;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class ChatUtils {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public static class_5250 createApplyMessage(UUID audioID, class_5250 component) {
        component.method_27693(" ");
        component.method_10852((class_2561)class_2564.method_10885((class_2561)Lang.translatable("audioplayer.copy_id", new Object[0])).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10606(audioID.toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)Lang.translatable("audioplayer.copy_id_tooltip", new Object[0])))).method_27692(class_124.field_1060));
        component.method_27693(" ");
        component.method_10852((class_2561)class_2564.method_10885((class_2561)Lang.translatable("audioplayer.put_on_item", new Object[0])).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610("/audioplayer apply %s".formatted(audioID.toString()))).method_10949((class_2568)new class_2568.class_10613((class_2561)Lang.translatable("audioplayer.put_on_item_tooltip", new Object[0])))).method_27692(class_124.field_1060));
        return component;
    }

    public static class_5250 createInfoMessage(UUID audioID) {
        Metadata.Owner owner;
        Long created;
        String fileName;
        Metadata metadata = AudioStorageManager.metadataManager().getMetadata(audioID).orElse(null);
        class_5250 base = class_2561.method_43473();
        String string = fileName = metadata == null ? null : metadata.getFileName();
        if (fileName != null) {
            base.method_10852((class_2561)class_2561.method_43470((String)fileName).method_27694(style -> style.method_10977(class_124.field_1078).method_10949((class_2568)new class_2568.class_10613((class_2561)Lang.translatable("audioplayer.click_copy", new Object[0]))).method_10958((class_2558)new class_2558.class_10606(fileName))));
        } else {
            base.method_10852((class_2561)Lang.translatable("audioplayer.unnamed", new Object[0]).method_27692(class_124.field_1078));
        }
        Long l = created = metadata == null ? null : metadata.getCreated();
        if (created != null) {
            base.method_27693(" ");
            base.method_10852((class_2561)Lang.translatable("audioplayer.creation_date", class_2561.method_43470((String)DATE_FORMAT.format(new Date(created))).method_27692(class_124.field_1080)));
        }
        Metadata.Owner owner2 = owner = metadata == null ? null : metadata.getOwner();
        if (owner != null) {
            base.method_27693(" ");
            base.method_10852((class_2561)Lang.translatable("audioplayer.by", class_2561.method_43470((String)owner.name()).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10611(new class_2568.class_5248(class_1299.field_6097, owner.uuid(), (class_2561)class_2561.method_43470((String)owner.name())))).method_10977(class_124.field_1080))));
        }
        return ChatUtils.createApplyMessage(audioID, base);
    }

    public static void checkFileSize(long size) throws IOException {
        if (size > AudioPlayerMod.SERVER_CONFIG.maxUploadSize.get()) {
            throw new IOException("Maximum file size exceeded (%sMB>%sMB)".formatted(Math.round((float)size / 1000000.0f), Math.round(AudioPlayerMod.SERVER_CONFIG.maxUploadSize.get().floatValue() / 1000000.0f)));
        }
    }

    public static void notifyToEnableVoicechatIfNoVoicechat(class_3222 player) {
        if (ChatUtils.isAbleToHearVoicechat(player)) {
            return;
        }
        ChatUtils.sendEnableVoicechatMessage(player);
    }

    public static boolean isAbleToHearVoicechat(class_3222 player) {
        VoicechatServerApi api = VoicechatAudioPlayerPlugin.voicechatServerApi;
        if (api == null) {
            return false;
        }
        VoicechatConnection connection = api.getConnectionOf(player.method_5667());
        return ChatUtils.isAbleToHearVoicechat(connection);
    }

    public static boolean isAbleToHearVoicechat(VoicechatConnection connection) {
        return connection != null && !connection.isDisabled() && connection.isConnected() && connection.isInstalled();
    }

    public static void sendEnableVoicechatMessage(class_3222 player) {
        player.method_7353((class_2561)Lang.translatable("audioplayer.enable_voicechat", new Object[0]), true);
    }
}

