/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.utils;

import de.maxhenkel.audioplayer.AudioPlayerMod;
import de.maxhenkel.audioplayer.voicechat.VoicechatAudioPlayerPlugin;
import de.maxhenkel.voicechat.api.mp3.Mp3Decoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.fabricmc.loader.api.FabricLoader;

public class AudioUtils {
    public static AudioFormat FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, 1, 2, 48000.0f, false);

    @Nullable
    public static AudioType getAudioType(Path path) throws IOException {
        if (AudioUtils.isWav(Files.newInputStream(path, new OpenOption[0]))) {
            return AudioType.WAV;
        }
        if (AudioUtils.isMp3(Files.newInputStream(path, new OpenOption[0]))) {
            return AudioType.MP3;
        }
        return null;
    }

    @Nullable
    public static AudioType getAudioType(byte[] data) throws IOException {
        if (AudioUtils.isWav(new ByteArrayInputStream(data))) {
            return AudioType.WAV;
        }
        if (AudioUtils.isMp3(new ByteArrayInputStream(data))) {
            return AudioType.MP3;
        }
        return null;
    }

    public static boolean isWav(InputStream inputStream) throws IOException {
        boolean bl;
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        try {
            AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(bis);
            bl = fileFormat.getType().toString().equalsIgnoreCase("wave");
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedAudioFileException e) {
                return false;
            }
        }
        bis.close();
        return bl;
    }

    public static boolean isMp3(InputStream inputStream) throws IOException {
        boolean bl;
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        try {
            AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(bis);
            bl = fileFormat.getType().toString().equalsIgnoreCase("mp3");
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedAudioFileException e) {
                return false;
            }
        }
        bis.close();
        return bl;
    }

    public static float getLengthSeconds(short[] audio) {
        return AudioUtils.getLengthSeconds(audio.length);
    }

    public static float getLengthSeconds(int sampleLength) {
        return (float)sampleLength / FORMAT.getSampleRate();
    }

    public static float getLengthSeconds(byte[] file) throws UnsupportedAudioFileException, IOException {
        return AudioUtils.getLengthSeconds(AudioUtils.convert(file));
    }

    public static void adjustVolume(short[] samples, float volume) {
        float gain = (float)Math.pow(10.0, volume - 1.0f);
        for (int i = 0; i < samples.length; ++i) {
            int out = Math.round((float)samples[i] * gain);
            samples[i] = (short)Math.max(Math.min(out, Short.MAX_VALUE), Short.MIN_VALUE);
        }
    }

    public static short[] convert(Path file) throws IOException, UnsupportedAudioFileException {
        return AudioUtils.convert(() -> new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])), AudioUtils.getAudioType(file));
    }

    public static short[] convert(byte[] file) throws IOException, UnsupportedAudioFileException {
        return AudioUtils.convert(() -> new ByteArrayInputStream(file), AudioUtils.getAudioType(file));
    }

    public static short[] convert(Path file, @Nullable Float volume) throws IOException, UnsupportedAudioFileException {
        short[] converted = AudioUtils.convert(file);
        if (volume != null) {
            AudioUtils.adjustVolume(converted, volume.floatValue());
        }
        return converted;
    }

    private static short[] convert(InputStreamSupplier inputStreamSupplier, AudioType audioType) throws IOException, UnsupportedAudioFileException {
        if (audioType == AudioType.WAV) {
            return AudioUtils.convertWav(inputStreamSupplier);
        }
        if (audioType == AudioType.MP3) {
            return AudioUtils.convertMp3(inputStreamSupplier);
        }
        throw new UnsupportedAudioFileException("Unsupported audio type");
    }

    private static short[] convertWav(InputStreamSupplier inputStreamSupplier) throws IOException, UnsupportedAudioFileException {
        try (AudioInputStream source = AudioSystem.getAudioInputStream(inputStreamSupplier.get());){
            short[] sArray = AudioUtils.convert(source);
            return sArray;
        }
    }

    private static short[] convertMp3(InputStreamSupplier inputStreamSupplier) throws IOException, UnsupportedAudioFileException {
        try {
            Mp3Decoder mp3Decoder = VoicechatAudioPlayerPlugin.voicechatApi.createMp3Decoder(inputStreamSupplier.get());
            if (mp3Decoder == null) {
                throw new IOException("Error creating mp3 decoder");
            }
            byte[] data = VoicechatAudioPlayerPlugin.voicechatApi.getAudioConverter().shortsToBytes(mp3Decoder.decode());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
            AudioFormat audioFormat = mp3Decoder.getAudioFormat();
            AudioInputStream source = new AudioInputStream(byteArrayInputStream, audioFormat, data.length / audioFormat.getFrameSize());
            return AudioUtils.convert(source);
        }
        catch (Exception e) {
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                AudioPlayerMod.LOGGER.error("Could not convert mp3 using native decoder, using fallback", (Throwable)e);
            } else {
                AudioPlayerMod.LOGGER.debug("Could not convert mp3 using native decoder, using fallback");
            }
            return AudioUtils.convert(AudioSystem.getAudioInputStream(inputStreamSupplier.get()));
        }
    }

    private static short[] convert(AudioInputStream source) throws IOException {
        AudioFormat sourceFormat = source.getFormat();
        AudioFormat convertFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), sourceFormat.getChannels() * 2, sourceFormat.getSampleRate(), false);
        AudioInputStream stream1 = AudioSystem.getAudioInputStream(convertFormat, source);
        AudioInputStream stream2 = AudioSystem.getAudioInputStream(FORMAT, stream1);
        return VoicechatAudioPlayerPlugin.voicechatApi.getAudioConverter().bytesToShorts(stream2.readAllBytes());
    }

    public static enum AudioType {
        MP3("mp3"),
        WAV("wav");

        private final String extension;

        private AudioType(String fileName) {
            this.extension = fileName;
        }

        public boolean isValidFileName(Path path) {
            return path.toString().toLowerCase().endsWith(".%s".formatted(this.extension));
        }

        public String getExtension() {
            return this.extension;
        }
    }

    private static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }
}

