/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.apiimpl;

import de.maxhenkel.audioplayer.api.AudioPlayerApi;
import de.maxhenkel.audioplayer.api.ChannelReference;
import de.maxhenkel.audioplayer.api.data.AudioDataModule;
import de.maxhenkel.audioplayer.api.data.ModuleKey;
import de.maxhenkel.audioplayer.api.importer.AudioImporter;
import de.maxhenkel.audioplayer.apiimpl.ModuleKeyImpl;
import de.maxhenkel.audioplayer.audioloader.AudioData;
import de.maxhenkel.audioplayer.audioloader.AudioStorageManager;
import de.maxhenkel.audioplayer.audioplayback.PlayerManager;
import de.maxhenkel.audioplayer.utils.ChatUtils;
import de.maxhenkel.audioplayer.voicechat.VoicechatAudioPlayerPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class AudioPlayerApiImpl
implements AudioPlayerApi {
    public static final AudioPlayerApiImpl INSTANCE = new AudioPlayerApiImpl();
    protected Map<class_2960, ModuleKeyImpl<? extends AudioDataModule>> moduleTypes = new ConcurrentHashMap<class_2960, ModuleKeyImpl<? extends AudioDataModule>>();

    public ModuleKey<? extends AudioDataModule> getModuleType(class_2960 id) {
        return this.moduleTypes.get(id);
    }

    @Override
    public <T extends AudioDataModule> ModuleKey<T> registerModuleType(class_2960 id, Supplier<T> constructor) {
        ModuleKeyImpl<T> key = new ModuleKeyImpl<T>(id, constructor);
        this.moduleTypes.put(id, key);
        return key;
    }

    @Override
    public void importAudio(AudioImporter importer, @Nullable class_3222 player) {
        AudioStorageManager.instance().handleImport(importer, player);
    }

    @Override
    public class_5250 createApplyMessage(UUID audioID, class_5250 component) {
        return ChatUtils.createApplyMessage(audioID, component);
    }

    @Override
    public void invalidateCachedAudio(UUID audioID) {
        AudioStorageManager.audioCache().invalidate(audioID);
    }

    @Override
    public void clearAudioCache() {
        AudioStorageManager.audioCache().clear();
    }

    @Override
    public void notifyPlayerToEnableVoicechat(class_3222 player) {
        ChatUtils.notifyToEnableVoicechatIfNoVoicechat(player);
    }

    @Override
    public boolean canPlayerHearVoicechatAudio(class_3222 player) {
        return ChatUtils.isAbleToHearVoicechat(player);
    }

    @Override
    @Nullable
    public VoicechatServerApi getVoicechatServerApi() {
        return VoicechatAudioPlayerPlugin.voicechatServerApi;
    }

    @Override
    public ChannelReference<LocationalAudioChannel> playLocational(class_3218 level, class_243 pos, UUID audioId, @Nullable class_3222 p, float distance, @Nullable String category) {
        return PlayerManager.instance().playLocational(level, pos, audioId, p, distance, category, null);
    }

    @Override
    public <T extends AudioChannel> ChannelReference<T> playChannel(T channel, UUID audioId, @Nullable class_3222 p) {
        return PlayerManager.instance().playChannel(channel, audioId, p, null);
    }

    @Override
    public Optional<de.maxhenkel.audioplayer.api.data.AudioData> getAudioData(class_1799 stack) {
        return Optional.ofNullable(AudioData.of(stack));
    }
}

