/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.audioloader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.maxhenkel.audioplayer.AudioPlayerMod;
import de.maxhenkel.audioplayer.api.AudioPlayerModule;
import de.maxhenkel.audioplayer.api.data.AudioDataModule;
import de.maxhenkel.audioplayer.api.data.ModuleKey;
import de.maxhenkel.audioplayer.api.events.AudioEvents;
import de.maxhenkel.audioplayer.api.events.ItemEvents;
import de.maxhenkel.audioplayer.apiimpl.AudioPlayerApiImpl;
import de.maxhenkel.audioplayer.apiimpl.events.ApplyEventImpl;
import de.maxhenkel.audioplayer.apiimpl.events.ClearEventImpl;
import de.maxhenkel.audioplayer.apiimpl.events.GetSoundIdEventImpl;
import de.maxhenkel.audioplayer.audioplayback.PlayerType;
import de.maxhenkel.audioplayer.configbuilder.entry.ConfigEntry;
import de.maxhenkel.audioplayer.utils.ComponentUtils;
import de.maxhenkel.audioplayer.utils.upgrade.ItemUpgrader;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_10710;
import net.minecraft.class_10712;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11580;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7445;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9792;
import net.minecraft.server.MinecraftServer;

public class AudioData
implements de.maxhenkel.audioplayer.api.data.AudioData {
    public static final String AUDIOPLAYER_CUSTOM_DATA = "audioplayer";
    public static final String DEFAULT_HEAD_LORE = "Has custom audio";
    public static final Gson GSON = new GsonBuilder().create();
    protected Map<ModuleKey<? extends AudioDataModule>, AudioDataModule> modules = new ConcurrentHashMap<ModuleKey<? extends AudioDataModule>, AudioDataModule>();
    protected Map<class_2960, JsonObject> unknownModules = new ConcurrentHashMap<class_2960, JsonObject>();

    protected AudioData() {
    }

    @Nullable
    private static AudioData fromJson(JsonObject rawData) {
        AudioData data = new AudioData();
        for (Map.Entry entry : rawData.entrySet()) {
            class_2960 resourceLocation = class_2960.method_12829((String)((String)entry.getKey()));
            if (resourceLocation == null) {
                AudioPlayerMod.LOGGER.warn("Invalid module key: {}", entry.getKey());
                continue;
            }
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (!jsonElement.isJsonObject()) {
                AudioPlayerMod.LOGGER.warn("Invalid content for module: {}", entry.getKey());
                continue;
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            ModuleKey<? extends AudioDataModule> moduleKey = AudioPlayerApiImpl.INSTANCE.getModuleType(resourceLocation);
            if (moduleKey == null) {
                data.unknownModules.put(resourceLocation, jsonObject);
                AudioPlayerMod.LOGGER.debug("Unknown module: {}", (Object)resourceLocation);
                continue;
            }
            AudioDataModule module = moduleKey.create();
            try {
                module.load(jsonObject);
                data.modules.put(moduleKey, module);
            }
            catch (Exception e) {
                data.unknownModules.put(resourceLocation, jsonObject);
                AudioPlayerMod.LOGGER.error("Failed to load module {}", (Object)resourceLocation, (Object)e);
            }
        }
        if (!data.modules.containsKey(AudioPlayerModule.KEY)) {
            AudioPlayerMod.LOGGER.error("Missing audio player module");
            return null;
        }
        return data;
    }

    @Nullable
    public static AudioData of(class_1799 item) {
        class_9279 customData;
        if (ItemUpgrader.upgradeItem(item)) {
            AudioPlayerMod.LOGGER.info("Upgraded audio player data of item {}", (Object)item.method_7964().getString());
        }
        if ((customData = (class_9279)item.method_58694(class_9334.field_49628)) == null) {
            return null;
        }
        return AudioData.of(customData.method_57461().method_68564(AUDIOPLAYER_CUSTOM_DATA, null));
    }

    @Nullable
    public static AudioData of(class_11368 valueInput) {
        AudioData upgradeData = ItemUpgrader.upgradeBlockEntity(valueInput);
        if (upgradeData != null) {
            AudioPlayerMod.LOGGER.info("Upgraded audio player data {}", (Object)upgradeData.getActualSoundId());
            return upgradeData;
        }
        return AudioData.of(valueInput.method_71428(AUDIOPLAYER_CUSTOM_DATA, null));
    }

    @Nullable
    public static AudioData of(@Nullable String data) {
        if (data == null) {
            return null;
        }
        try {
            JsonElement jsonElement = JsonParser.parseString((String)data);
            if (!jsonElement.isJsonObject()) {
                AudioPlayerMod.LOGGER.error("Failed to parse item data - element is not a json object");
                return null;
            }
            return AudioData.fromJson(jsonElement.getAsJsonObject());
        }
        catch (JsonSyntaxException e) {
            AudioPlayerMod.LOGGER.error("Failed to parse item data", (Throwable)e);
            return null;
        }
    }

    public static AudioData withSoundAndRange(UUID soundId, @Nullable Float range) {
        AudioData audioData = new AudioData();
        audioData.modules.put(AudioPlayerModule.KEY, new AudioPlayerModule(soundId, range));
        return audioData;
    }

    @Override
    public <T extends AudioDataModule> Optional<T> getModule(ModuleKey<T> id) {
        AudioDataModule module = this.modules.get(id);
        return Optional.ofNullable(module);
    }

    @Override
    public <T extends AudioDataModule> void setModule(ModuleKey<T> moduleKey, T module) {
        this.modules.put(moduleKey, module);
    }

    @Nullable
    public UUID getSoundIdToPlay() {
        UUID soundId = this.getModule(AudioPlayerModule.KEY).map(AudioPlayerModule::getSoundId).orElse(null);
        GetSoundIdEventImpl event = new GetSoundIdEventImpl(this, soundId);
        ((Consumer)AudioEvents.GET_SOUND_ID.invoker()).accept(event);
        return event.getSoundId();
    }

    @Nullable
    public UUID getActualSoundId() {
        return this.getModule(AudioPlayerModule.KEY).map(AudioPlayerModule::getSoundId).orElse(null);
    }

    @Override
    public UUID getSoundId() {
        return this.getModule(AudioPlayerModule.KEY).map(AudioPlayerModule::getSoundId).orElseThrow();
    }

    @Override
    @Nullable
    public Float getRange() {
        return this.getModule(AudioPlayerModule.KEY).map(AudioPlayerModule::getRange).orElse(null);
    }

    public Optional<Float> getOptionalRange() {
        return this.getModule(AudioPlayerModule.KEY).flatMap(m -> Optional.ofNullable(m.getRange()));
    }

    public float getRange(PlayerType playerType) {
        return this.getRangeOrDefault(playerType.getDefaultRange(), playerType.getMaxRange());
    }

    public float getRangeOrDefault(ConfigEntry<Float> defaultRange, ConfigEntry<Float> maxRange) {
        float range = this.getOptionalRange().orElseGet(defaultRange::get).floatValue();
        if (range > maxRange.get().floatValue()) {
            return maxRange.get().floatValue();
        }
        return range;
    }

    private JsonObject toJson() {
        JsonObject rawData = new JsonObject();
        for (Map.Entry<class_2960, JsonObject> entry : this.unknownModules.entrySet()) {
            rawData.add(entry.toString(), (JsonElement)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.modules.entrySet()) {
            AudioDataModule module = (AudioDataModule)entry.getValue();
            JsonObject jsonData = new JsonObject();
            try {
                module.save(jsonData);
                rawData.add(((ModuleKey)entry.getKey()).getId().toString(), (JsonElement)jsonData);
            }
            catch (Exception e) {
                AudioPlayerMod.LOGGER.error("Failed to save module {}", (Object)((ModuleKey)entry.getKey()).getId(), (Object)e);
            }
        }
        return rawData;
    }

    public void saveToNbt(class_2487 tag) {
        tag.method_10582(AUDIOPLAYER_CUSTOM_DATA, GSON.toJson((JsonElement)this.toJson()));
    }

    public void saveToValueOutput(class_11372 valueOutput) {
        valueOutput.method_71469(AUDIOPLAYER_CUSTOM_DATA, GSON.toJson((JsonElement)this.toJson()));
    }

    public void saveToItemIgnoreLore(class_1799 stack) {
        this.saveToItem(stack, null, false);
    }

    @Override
    public void saveToItem(class_1799 stack) {
        this.saveToItem(stack, (class_2561)null);
    }

    public void saveToItem(class_1799 stack, @Nullable String loreString) {
        this.saveToItem(stack, (class_2561)(loreString == null ? null : class_2561.method_43470((String)loreString)), true);
    }

    @Override
    public void saveToItem(class_1799 stack, @Nullable class_2561 lore) {
        this.saveToItem(stack, lore, true);
    }

    public void saveToItem(class_1799 stack, @Nullable class_2561 lore, boolean applyLore) {
        class_1747 blockItem;
        class_9279 customData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 tag = customData.method_57461();
        this.saveToNbt(tag);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        if (stack.method_57826(class_9334.field_49612)) {
            stack.method_57379(class_9334.field_49612, (Object)ComponentUtils.EMPTY_INSTRUMENT);
        }
        if (stack.method_57826(class_9334.field_52175)) {
            stack.method_57379(class_9334.field_52175, (Object)ComponentUtils.CUSTOM_JUKEBOX_PLAYABLE);
        }
        class_9290 l = null;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_2484) {
            class_11580 blockEntityData = (class_11580)stack.method_58695(class_9334.field_49611, (Object)class_11580.method_72535((Object)class_2591.field_11913, (class_2487)new class_2487()));
            class_2487 blockEntityTag = blockEntityData.method_72540();
            this.saveToNbt(blockEntityTag);
            stack.method_57379(class_9334.field_49611, (Object)class_11580.method_72535((Object)class_2591.field_11913, (class_2487)blockEntityTag));
            if (lore == null) {
                l = new class_9290(Collections.singletonList(class_2561.method_43470((String)DEFAULT_HEAD_LORE).method_27694(style -> style.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1080)));
            }
        }
        if (lore != null) {
            l = new class_9290(Collections.singletonList(lore.method_27661().method_27694(style -> style.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1080)));
        }
        if (applyLore) {
            if (l != null) {
                stack.method_57379(class_9334.field_49632, l);
            } else {
                stack.method_57381(class_9334.field_49632);
            }
        }
        class_10712 tooltipDisplay = (class_10712)stack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318);
        LinkedHashSet<class_9331> hiddenComponents = new LinkedHashSet<class_9331>(tooltipDisplay.comp_3601());
        hiddenComponents.add(class_9334.field_52175);
        hiddenComponents.add(class_9334.field_49612);
        stack.method_57379(class_9334.field_56400, (Object)new class_10712(tooltipDisplay.comp_3600(), hiddenComponents));
        ((Consumer)ItemEvents.APPLY.invoker()).accept(new ApplyEventImpl(this, stack));
    }

    public static boolean clearItem(MinecraftServer server, class_1799 stack) {
        class_11580 blockEntityData;
        AudioData audioData = AudioData.of(stack);
        if (audioData == null) {
            return false;
        }
        class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
        if (customData == null) {
            return false;
        }
        class_2487 tag = customData.method_57461();
        if (!tag.method_10545(AUDIOPLAYER_CUSTOM_DATA)) {
            return false;
        }
        tag.method_10551(AUDIOPLAYER_CUSTOM_DATA);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        if (stack.method_7909() instanceof class_1747 && (blockEntityData = (class_11580)stack.method_58694(class_9334.field_49611)) != null) {
            class_2487 blockEntityTag = blockEntityData.method_72540();
            blockEntityTag.method_10551(AUDIOPLAYER_CUSTOM_DATA);
            stack.method_57379(class_9334.field_49611, (Object)class_11580.method_72535((Object)((class_2591)blockEntityData.method_72530()), (class_2487)blockEntityTag));
        }
        AudioData.revertMinecraftData(server, stack);
        ((Consumer)ItemEvents.CLEAR.invoker()).accept(new ClearEventImpl(audioData, stack));
        return true;
    }

    private static void revertMinecraftData(MinecraftServer server, class_1799 stack) {
        class_10712 tooltipDisplay;
        if (stack.method_57826(class_9334.field_49612)) {
            Optional holder = server.method_30611().method_30530(class_7924.field_41275).method_46746(class_7445.field_39126);
            holder.ifPresent(instrumentReference -> stack.method_57379(class_9334.field_49612, (Object)new class_10710((class_6880)instrumentReference)));
        }
        if (stack.method_57826(class_9334.field_52175)) {
            class_9792 jukeboxPlayable = (class_9792)stack.method_7909().method_57347().method_58694(class_9334.field_52175);
            if (jukeboxPlayable != null) {
                stack.method_57379(class_9334.field_52175, (Object)jukeboxPlayable);
            } else {
                stack.method_57381(class_9334.field_52175);
            }
        }
        if ((tooltipDisplay = (class_10712)stack.method_58694(class_9334.field_56400)) != null) {
            LinkedHashSet hiddenComponents = new LinkedHashSet(tooltipDisplay.comp_3601());
            hiddenComponents.remove(class_9334.field_52175);
            hiddenComponents.remove(class_9334.field_49612);
            stack.method_57379(class_9334.field_56400, (Object)new class_10712(tooltipDisplay.comp_3600(), hiddenComponents));
        }
        if (stack.method_57826(class_9334.field_49632)) {
            stack.method_57381(class_9334.field_49632);
        }
    }
}

