/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.audioloader;

import de.maxhenkel.audioplayer.AudioPlayerMod;
import de.maxhenkel.audioplayer.api.importer.AudioImportInfo;
import de.maxhenkel.audioplayer.api.importer.AudioImporter;
import de.maxhenkel.audioplayer.audioloader.FileMetadataManager;
import de.maxhenkel.audioplayer.audioloader.Metadata;
import de.maxhenkel.audioplayer.audioloader.cache.AudioCache;
import de.maxhenkel.audioplayer.lang.Lang;
import de.maxhenkel.audioplayer.utils.AudioUtils;
import de.maxhenkel.audioplayer.utils.ChatUtils;
import de.maxhenkel.audioplayer.utils.ComponentException;
import de.maxhenkel.audioplayer.utils.upgrade.MetadataUpgrader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.IOUtils;

public class AudioStorageManager {
    public static class_5218 AUDIO_DATA_LEVEL_RESOURCE = new class_5218("audio_player_data");
    public static AudioStorageManager instance;
    private final MinecraftServer server;
    private final ExecutorService executor;
    private final FileMetadataManager fileMetadataManager;
    private final AudioCache audioCache;

    public AudioStorageManager(MinecraftServer server) throws Exception {
        this.server = server;
        this.executor = Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r, "AudioPlayerStorageManagerExecutor");
            thread.setDaemon(true);
            return thread;
        });
        Path metaPath = this.getAudioDataFolder().resolve("meta.json");
        boolean initial = !Files.exists(metaPath, new LinkOption[0]);
        this.fileMetadataManager = new FileMetadataManager(metaPath);
        this.audioCache = new AudioCache();
        MetadataUpgrader.upgrade(this, initial);
    }

    public static void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(AudioStorageManager::onServerStarted);
        ServerLifecycleEvents.SERVER_STOPPED.register(AudioStorageManager::onServerStopped);
        try {
            Files.createDirectories(AudioStorageManager.getUploadFolder(), new FileAttribute[0]);
        }
        catch (IOException e) {
            AudioPlayerMod.LOGGER.warn("Failed to create upload folder", (Throwable)e);
        }
    }

    private static void onServerStarted(MinecraftServer server) {
        try {
            instance = new AudioStorageManager(server);
        }
        catch (Exception e) {
            AudioPlayerMod.LOGGER.error("Failed to initialize audio storage manager");
            throw new RuntimeException(e);
        }
    }

    private static void onServerStopped(MinecraftServer server) {
        if (instance != null) {
            instance.close();
        }
        instance = null;
    }

    private void close() {
        this.executor.shutdown();
    }

    public FileMetadataManager getFileMetadataManager() {
        return this.fileMetadataManager;
    }

    public static AudioStorageManager instance() {
        return instance;
    }

    public static FileMetadataManager metadataManager() {
        return AudioStorageManager.instance().fileMetadataManager;
    }

    public static AudioCache audioCache() {
        return AudioStorageManager.instance().audioCache;
    }

    public Path getSoundFile(UUID id, String extension) {
        return this.getAudioDataFolder().resolve(id.toString() + "." + extension);
    }

    public Path getAudioDataFolder() {
        return this.server.method_27050(AUDIO_DATA_LEVEL_RESOURCE);
    }

    public Path getExistingSoundFile(UUID id) throws FileNotFoundException {
        Path file = this.getSoundFile(id, AudioUtils.AudioType.MP3.getExtension());
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        file = this.getSoundFile(id, AudioUtils.AudioType.WAV.getExtension());
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        throw new FileNotFoundException("Audio does not exist");
    }

    public boolean checkSoundExists(UUID id) {
        Path file = this.getSoundFile(id, AudioUtils.AudioType.MP3.getExtension());
        if (Files.exists(file, new LinkOption[0])) {
            return true;
        }
        file = this.getSoundFile(id, AudioUtils.AudioType.WAV.getExtension());
        return Files.exists(file, new LinkOption[0]);
    }

    public static Path getUploadFolder() {
        return FabricLoader.getInstance().getGameDir().resolve("audioplayer_uploads");
    }

    public void handleImport(AudioImporter importer, @Nullable class_3222 player) {
        this.executor.execute(() -> {
            try {
                AudioImportInfo audioDownloadInfo = importer.onPreprocess(player);
                byte[] bytes = importer.onProcess(player);
                ChatUtils.checkFileSize(bytes.length);
                UUID id = audioDownloadInfo.getAudioId();
                String fileName = audioDownloadInfo.getName();
                this.saveSound(id, fileName, bytes, player);
                this.runOnMain(() -> {
                    if (player != null) {
                        player.method_64398((class_2561)ChatUtils.createApplyMessage(id, Lang.translatable("audioplayer.import_successful", new Object[0])));
                    }
                });
                importer.onPostprocess(player);
            }
            catch (Exception e) {
                this.runOnMain(() -> {
                    if (player != null) {
                        if (e instanceof ComponentException) {
                            ComponentException c = (ComponentException)e;
                            player.method_64398((class_2561)Lang.translatable("audioplayer.error", c.getComponent()).method_27692(class_124.field_1061));
                        } else {
                            player.method_64398((class_2561)Lang.translatable("audioplayer.error", e.getMessage()).method_27692(class_124.field_1061));
                        }
                    }
                });
                AudioPlayerMod.LOGGER.error("Failed to download audio using '{}' download handler", (Object)importer.getHandlerName(), (Object)e);
            }
        });
    }

    private void runOnMain(Runnable runnable) {
        this.server.execute(runnable);
    }

    private void saveSound(UUID id, @Nullable String fileName, byte[] data, @Nullable class_3222 player) throws UnsupportedAudioFileException, IOException {
        AudioUtils.AudioType audioType = AudioUtils.getAudioType(data);
        AudioStorageManager.checkExtensionAllowed(audioType);
        Path soundFile = this.getSoundFile(id, audioType.getExtension());
        if (Files.exists(soundFile, new LinkOption[0])) {
            throw new FileAlreadyExistsException("This audio already exists");
        }
        Files.createDirectories(soundFile.getParent(), new FileAttribute[0]);
        float lengthSeconds = AudioUtils.getLengthSeconds(data);
        if (lengthSeconds > AudioPlayerMod.SERVER_CONFIG.maxUploadDuration.get().floatValue()) {
            throw new IOException("Maximum upload duration exceeded (%.1fs>%.1fs)".formatted(Float.valueOf(lengthSeconds), AudioPlayerMod.SERVER_CONFIG.maxUploadDuration.get()));
        }
        try (OutputStream outputStream = Files.newOutputStream(soundFile, new OpenOption[0]);){
            IOUtils.write((byte[])data, (OutputStream)outputStream);
        }
        this.fileMetadataManager.modifyMetadata(id, metadata -> {
            metadata.setFileName(fileName);
            metadata.setCreated(System.currentTimeMillis());
            if (player != null) {
                metadata.setOwner(Metadata.Owner.of((class_1657)player));
            }
        });
    }

    private static void checkExtensionAllowed(@Nullable AudioUtils.AudioType audioType) throws UnsupportedAudioFileException {
        if (audioType == null) {
            throw new UnsupportedAudioFileException("Unsupported audio format");
        }
        if (audioType.equals((Object)AudioUtils.AudioType.MP3) && !AudioPlayerMod.SERVER_CONFIG.allowMp3Upload.get().booleanValue()) {
            throw new UnsupportedAudioFileException("Importing mp3 files is not allowed on this server");
        }
        if (audioType.equals((Object)AudioUtils.AudioType.WAV) && !AudioPlayerMod.SERVER_CONFIG.allowWavUpload.get().booleanValue()) {
            throw new UnsupportedAudioFileException("Importing wav files is not allowed on this server");
        }
    }
}

